
package semorg.classes;

import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * Instances of this class represent contacts used for contacting clients and companies.
 *
 * @author Ivan Pribela
 * @version 1.1
 */

public class ContactT extends Ancestor
{

  /**
   * Holds information about the contact.
   */

  private String EMail, Phone, Fax;

  /**
   * Holds information about the contact.
   */

  private AddressT Address;

  /**
   * Holds information about the contact.
   */

  private String Default;

  /**
   * Constructs a new instance of <code>ContactT</code> class.
   */

  public ContactT()
  {
    EMail = "";
    Phone = "";
    Fax = "";
    Address = new AddressT();
    Default = "Address";
  }

  /**
   * Constructs a new instance of <code>ContactT</code> class.
   *
   * @param SQL database row from which to read attributes.
   * @param Column starting column in database from which to read
   *     attributes.
   */

  public ContactT(ResultSet SQL, int Column)
  {
    this();
    try
    {
      EMail = SQL.getString(Column); Column++;
      Phone = SQL.getString(Column); Column++;
      Fax = SQL.getString(Column); Column++;
      Address = new AddressT(SQL, Column);
      Column = Column + AddressT.noOfSQLColumns();
      Default = SQL.getString(Column); Column++;
    }
    catch (SQLException e)
    {
    }
  }

  /**
   * Returns string containing names of all columns in the database.
   *
   * @param prefix prefix string added to all database column names.
   * @return string containing names of all columns in the database.
   */

  public static final String tableColumns(String prefix)
  {
    return prefix + "EMail, " +
           prefix + "Phone, " +
           prefix + "Fax, " +
           AddressT.tableColumns(prefix) + ", " +
           prefix + "DefaultContact";
  }

  /**
   * Returns number of table columns in database.
   *
   * @return number of table columns in database.
   */

  public static int noOfSQLColumns()
  {
    return 4 + AddressT.noOfSQLColumns();
  }

  /**
   * Returns string representation that is used for creating the corresponding table in the database.
   *
   * @param prefix prefix string added to all database column names.
   * @return string representation that is used for creating the corresponding
   *      table in the database.
   */

  public static String SQLCreateString(String prefix)
  {
    return prefix + "EMail varchar(30), " +
           prefix + "Phone varchar(20), " +
           prefix + "Fax varchar(20), " +
           AddressT.SQLCreateString(prefix) + ", " +
           prefix + "DefaultContact varchar(10)";
  }

  /**
   * Returns string representation of this instance that is used for adding it to the database.
   *
   * @param prefix prefix string added to all database column names.
   * @return string representation of this instance that is used for adding it
   *      to the database.
   */

  public String toSQLAddString()
  {
    return "'" + getEMail() + "', " +
           "'" + getPhone() + "', " +
           "'" + getFax() + "', " +
           getAddress().toSQLAddString() + ", " +
           "'" + getDefault() + "'";
  }

  /**
   * Returns string representation of this instance that is used for modifying its attributes it the database.
   *
   * @param prefix prefix string added to all database column names.
   * @return string representation of this instance that is used for modifying
   *      its attributes it the database.
   */

  public String toSQLModifyString(String prefix)
  {
    return prefix + "EMail = '" + getEMail() + "', " +
           prefix + "Phone = '" + getPhone() + "', " +
           prefix + "Fax = '" + getFax() + "', " +
           getAddress().toSQLModifyString(prefix) + ", " +
           prefix + "DefaultContact = '" + getDefault() + "'";
  }

  /**
   * Returns string representation of contained contact.
   *
   * @return string representation of contained contact.
   */

  public String toString()
  {
    if (Default == "e-Mail")
    {
      return Default + ": " + EMail;
    }
    else if (Default == "Phone")
    {
      return Default + ": " + Phone;
    }
    else if (Default == "Fax")
    {
      return Default + ": " + Fax;
    }
    else if (Default == "Address")
    {
      return Default + ": " + Address.toString();
    }
    else
    {
      return "Unknown";
    }
  }

  /**
   * Returns prefered way of contacting.
   *
   * @return prefered way of contacting.
   */

  public String getDefault()
  {
    return Default;
  }

  /**
   * Sets default mean of contact.
   *
   * @param value the prefered way of contacting.
   */

  public void setDefault(String value)
  {
    if (value.toUpperCase() == "E-MAIL")
    {
      Default = "e-Mail";
    }
    else if (value.toUpperCase() == "PHONE")
    {
      Default = "Phone";
    }
    else if (value.toUpperCase() == "FAX")
    {
      Default = "Fax";
    }
    else if (value.toUpperCase() == "ADDRESS")
    {
      Default = "Address";
    }
  }

  /**
   * Returns available default contacts.
   *
   * @return available default contacts.
   */

  public static String [] options()
  {
    String [] a = new String[4];
    a[0] = "e-Mail";
    a[1] = "Phone";
    a[2] = "Fax";
    a[3] = "Address";
    return a;
  }

  /**
   * Returns e-mail of the contained contact.
   *
   * @return e-mail of the contained contact.
   */

  public String getEMail()
  {
    return EMail;
  }

  /**
   * Returns phone number of the contained contact.
   *
   * @return phone number of the contained contact.
   */

  public String getPhone()
  {
    return Phone;
  }

  /**
   * Returns fax number of the contained contact.
   *
   * @return fax number of the contained contact.
   */

  public String getFax()
  {
    return Fax;
  }

  /**
   * Returns address of the contained contact.
   *
   * @return address of the contained contact.
   */

  public AddressT getAddress()
  {
    return Address;
  }

  /**
   * Sets e-mail for the contained contact.
   *
   * @param value new e-mail for the contained contact.
   */

  public void setEMail(String value)
  {
    EMail = value;
  }

  /**
   * Sets phone number for the contained contact.
   *
   * @param value new phone number  the contained contact.
   */

  public void setPhone(String value)
  {
    Phone = value;
  }

  /**
   * Sets fax number for the contained contact.
   *
   * @param value new fax number for the contained contact.
   */

  public void setFax(String value)
  {
    Fax = value;
  }

  /**
   * Sets address for the contained contact.
   *
   * @param value new address for the contained contact.
   */

  public void setAddress(AddressT value)
  {
    Address = value;
  }

  public Object getKey()
  {
    return null;
  }

}
