package semorg.classes;

/**
 * This class is ancestor of all classes that can be stored in database.
 *
 * @author Ivan Pribela
 * @version 1.0
 */

abstract public class Ancestor
{

  /**
   * Returns value of primary key for this instance.
   *
   * @return value of primary key for this instance.
   */

  public abstract Object getKey();

  /**
   * Returns string representation of this instance that is used for adding it
   * to the database.
   *
   * @return string representation of this instance that is used for adding it
   *         to the database.
   */

  public abstract String toSQLAddString();

  /**
   * Returns string representation of this instance that is used for modifying
   * its attributes it the database.
   *
   * @param prefix prefix string added to all database column names.
   * @return string representation of this instance that is used for modifying
   *         its attributes it the database.
   */

  public abstract String toSQLModifyString(String prefix);

  /**
   * Returns string representation of this instance that is used for adding it
   * to the database.
   *
   * @return string representation of this instance that is used for adding it
   *         to the database.
   */

  public String toSQLAddStringNew(){return toSQLAddString();}

  /**
   * Returns string representation of this instance that is used for modifying
   * its attributes it the database.
   *
   * @param prefix prefix string added to all database column names.
   * @return string representation of this instance that is used for modifying
   *         its attributes it the database.
   */

  public String toSQLModifyStringNew(String prefix){return toSQLModifyString(prefix);}

  /**
   * Returns string representation of contained compant.
   *
   * @return string representation of contained compant.
   */

  public String toString()
  {
    return "Ancestor";
  }

}
