
package semorg.classes;

import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * Instances of this class represent addresses used for contacting clients and
 * companies.
 *
 * @author Ivan Pribela
 * @version 1.1
 */

public class AddressT extends Ancestor
{

  /**
   * Holds information about the address.
   */

  private String Country, Province, Town;

  /**
   * Holds information about the address.
   */

  private String Street, Building;

  /**
   * Constructs a new instance of <code>AddressT</code> class.
   */

  public AddressT()
  {
    Country = "";
    Province = "";
    Town = "";
    Street = "";
    Building = "";
  }

  /**
   * Constructs a new instance of <code>AddressT</code> class.
   *
   * @param SQL database row from which to read attributes.
   * @param Column starting column in database from which to read
   *     attributes.
   */

  public AddressT(ResultSet SQL, int Column)
  {
    this();
    try
    {
      Country = SQL.getString(Column); Column++;
      Province = SQL.getString(Column); Column++;
      Town = SQL.getString(Column); Column++;
      Street = SQL.getString(Column); Column++;
      Building = SQL.getString(Column); Column++;
    }
    catch (SQLException e)
    {
    }
  }

  /**
   * Returns string containing names of all columns in the database.
   *
   * @param prefix prefix string added to all database column names.
   * @return string containing names of all columns in the database.
   */

  public static final String tableColumns(String prefix)
  {
    return prefix + "Country, " +
           prefix + "Provincy, " +
           prefix + "Town, " +
           prefix + "Street, " +
           prefix + "Building";
  }

  /**
   * Returns number of table columns in database.
   *
   * @return number of table columns in database.
   */

  public static int noOfSQLColumns()
  {
    return 5;
  }

  /**
   * Returns string representation that is used for creating the corresponding table in the database.
   *
   * @param prefix prefix string added to all database column names.
   * @return string representation that is used for creating the corresponding
   *      table in the database.
   */

  public static String SQLCreateString(String prefix)
  {
    return prefix + "Country varchar(30), " +
           prefix + "Provincy varchar(30), " +
           prefix + "Town varchar(30), " +
           prefix + "Street varchar(30), " +
           prefix + "Building varchar(10)";
  }

  /**
   * Returns string representation of this instance that is used for adding it to the database.
   *
   * @param prefix prefix string added to all database column names.
   * @return string representation of this instance that is used for adding it
   *      to the database.
   */

  public String toSQLAddString()
  {
    return "'" + getCountry() + "', " +
           "'" + getProvince() + "', " +
           "'" + getTown() + "', " +
           "'" + getStreet() + "', " +
           "'" + getBuilding() + "'";
  }

  /**
   * Returns string representation of this instance that is used for modifying its attributes it the database.
   *
   * @param prefix prefix string added to all database column names.
   * @return string representation of this instance that is used for modifying
   *      its attributes it the database.
   */

  public String toSQLModifyString(String prefix)
  {
    return prefix + "Country = '" + getCountry() + "', " +
           prefix + "Provincy = '" + getProvince() + "', " +
           prefix + "Town = '" + getTown() + "', " +
           prefix + "Street = '" + getStreet() + "', " +
           prefix + "Building = '" + getBuilding() + "'";
  }

  /**
   * Returns string representation of this instance.
   *
   * @return string representation of this instance.
   */

  public String toString()
  {
    return "Country: " + Country + "\n" +
           "Provincy: " + Province + "\n" +
           "Town: " + Town + "\n" +
           "Street: " + Street + "\n" +
           "Building: " + Building;
  }

  /**
   * Returns country part of the contained address.
   *
   * @return country part of the contained address.
   */

  public String getCountry()
  {
    return Country;
  }

  /**
   * Returns province part of the contained address.
   *
   * @return province part of the contained address.
   */

  public String getProvince()
  {
    return Province;
  }

  /**
   * Returns town part of the contained address.
   *
   * @return town part of the contained address.
   */

  public String getTown()
  {
    return Town;
  }

  /**
   * Returns street part of the contained address.
   *
   * @return street part of the contained address.
   */

  public String getStreet()
  {
    return Street;
  }

  /**
   * Returns building number part of the contained address.
   *
   * @return building number part of the contained address.
   */

  public String getBuilding()
  {
    return Building;
  }

  /**
   * Sets country part of the contained address.
   *
   * @param value new country part of the contained address.
   */

  public void setCountry(String value)
  {
    Country = value;
  }

  /**
   * Sets province part of the contained address.
   *
   * @param value new province part of the contained address.
   */

  public void setProvince(String value)
  {
    Province = value;
  }

  /**
   * Sets town part of the contained address.
   *
   * @param value new town part of the contained address.
   */

  public void setTown(String value)
  {
    Town = value;
  }

  /**
   * Sets street part of the contained address.
   *
   * @param value new street part of the contained address.
   */

  public void setStreet(String value)
  {
    Street = value;
  }

  /**
   * Sets building number part of the contained address.
   *
   * @param value new building number part of the contained address.
   */

  public void setBuilding(String value)
  {
    Building = value;
  }

  public Object getKey()
  {
    return null;
  }

}
