
package semorg.booking;

import java.sql.ResultSet;
import java.sql.SQLException;

import semorg.classes.DateT;
import semorg.company.CompanyListT;
import semorg.company.CompanyT;
import semorg.presentation.CompanyPresentationListT;
import semorg.presentation.CompanyPresentationT;

/**
 * Objects of this class are representing bookings in the database.
 *
 * @author Ivan Pribela
 * @version 1.2
 */

public class CompanyBookingT extends BookingT
{

  /**
   * Holds information about the booking.
   */

  private String orderingParty;

  /**
   * Holds information about the booking.
   */

  private Long presentation;

  /**
   * The list of companies.
   */

  private CompanyListT companyList;

  /**
   * The list of presentations.
   */

  private CompanyPresentationListT presentationList;

  /**
   * Constructs a new instace with default values for all fields.
   */

  public CompanyBookingT()
  {
    super();
    orderingParty = null;
    presentation = null;
  }

  /**
   * Constructs a new instace with the given field values.
   */

  public CompanyBookingT(long IDNumber, DateT registered, DateT confirmation, DateT bill, DateT checkedOut, DateT notification, String orderingParty, Long presentation)
  {
    super(IDNumber, registered, confirmation, bill, checkedOut, notification);
    this.orderingParty = orderingParty;
    this.presentation = presentation;
  }

  /**
   * Constructs a new instace from the database.
   *
   * @param SQL a <code>ResultSet</code> instance holdin the information from
   *            the database.
   * @param column starting column from which to read data.
   */

  public CompanyBookingT(ResultSet SQL, int Column)
  {
    orderingParty = null;
    presentation = null;
    try
    {
      setIDNumber(SQL.getLong(Column)); Column++;
      orderingParty = SQL.getString(Column); Column++;
      presentation = new Long(SQL.getLong(Column)); Column++;
    }
    catch (SQLException e)
    {
    }
  }

  /**
   * Assignes all atributes from the given booking.
   *
   * @param Booking object containing values to be assigned to atributes.
   */

  public void assignFromBooking(BookingT Booking)
  {
    if ((Booking != null) && (Booking.getIDNumber() == getIDNumber()))
    {
      setRegistered(Booking.getRegistered());
      setConfirmation(Booking.getConfirmation());
      setBill(Booking.getBill());
      setCheckedOut(Booking.getCheckedOut());
      setNotification(Booking.getNotification());
    }
  }

  /**
   * Returns the number of columns of the apropriate table in the database.
   *
   * @return the number of columns of the apropriate table in the database.
   */

  public static int noOfSQLColumns()
  {
    return 3;
  }

  /**
   * Returns string representation that is used for creating the corresponding
   * table in the database.
   *
   * @param prefix prefix string added to all database column names.
   * @return string representation that is used for creating the corresponding
   *         table in the database.
   */

  public static String SQLCreateStringNew(String prefix)
  {
    return prefix + "IDNumber int, " +
           prefix + "OrderingParty varchar(10), " +
           prefix + "Presentation int, " +
           prefix + "CONSTRAINT PK_CompanyBooking PRIMARY KEY (IDNumber)";
  }

  public String toSQLAddStringNew()
  {
    return getIDNumber() + ", " +
           ((orderingParty != null) ? "'" + orderingParty.toString() + "'" : "NULL") + ", " +
           ((presentation != null) ? presentation.toString() : "NULL");
  }

  public String toSQLModifyStringNew(String prefix)
  {
    return prefix + "IDNumber = " + getIDNumber() + ", " +
           prefix + "OrderingParty = " + ((orderingParty != null) ? "'" + orderingParty.toString() + "'" : "NULL") + ", " +
           prefix + "Presentation = " + ((presentation != null) ? presentation.toString() : "NULL");
  }

  /**
   * Returns ordering party for this booking.
   *
   * @return ordering party for this booking.
   */

  public CompanyT getOrderingParty()
  {
    if (companyList == null)
    {
      return null;
    }
    else if (orderingParty == null)
    {
      return null;
    }
    else
    {
      return (CompanyT) companyList.find(orderingParty);
    }
  }

  /**
   * Returns presentation for this booking.
   *
   * @return presentation for this booking.
   */

  public CompanyPresentationT getPresentation()
  {
    if (presentationList == null)
    {
      return null;
    }
    else if (presentation == null)
    {
      return null;
    }
    else
    {
      return (CompanyPresentationT) presentationList.find(presentation);
    }
  }

  /**
   * Sets ordering party for this booking.
   *
   * @param value new value.
   */

  public void setOrderingParty(CompanyT value)
  {
    if (value != null)
    {
      orderingParty = value.getShortName();
    }
    else
    {
      orderingParty = null;
    }
  }

  /**
   * Sets ordering party for this booking.
   *
   * @param value new value.
   */

  public void setOrderingParty(String value)
  {
    orderingParty = value;
  }

  /**
   * Sets presentation for this booking.
   *
   * @param value new value.
   */

  public void setPresentation(CompanyPresentationT value)
  {
    if (value != null)
    {
      presentation = new Long(value.getIDNumber());
    }
    else
    {
      presentation = null;
    }
  }

  /**
   * Sets presentation for this booking.
   *
   * @param value new value.
   */

  public void setPresentation(Long value)
  {
    presentation = value;
  }

  /**
   * Sets company list for this booking.
   *
   * @param value company list for this booking
   */

  public void setCompanyList(CompanyListT value)
  {
    this.companyList = value;
  }

  /**
   * Sets presentation list for this booking.
   *
   * @param value presentation list for this booking
   */

  public void setPresentationList(CompanyPresentationListT value)
  {
    this.presentationList = value;
  }

}
