
package semorg.booking;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

import semorg.classes.Ancestor;
import semorg.classes.DataBaseT;
import semorg.classes.List;
import semorg.company.CompanyListT;
import semorg.presentation.CompanyPresentationListT;

/**
 * Instances of this class represent list of elements that are contained in the
 * associated database.
 *
 * @author Ivan Pribela
 * @version 1.2
 */

public class CompanyBookingListT extends List
{

  /**
   * The associated list.
   */

  private BookingListT bookingList;

  /**
   * The associated list.
   */

  private CompanyListT companyList;

  /**
   * The associated list.
   */

  private CompanyPresentationListT presentationList;

  /**
   * Creates a new instance associated with the database with the given
   * connection.
   *
   * @param DBConnection connection with the database.
   */

  public CompanyBookingListT(Connection DBConnection)
  {
    super(DBConnection);
    this.bookingList = new BookingListT(database);
  }

  /**
   * Creates a new instance associated with the given database.
   *
   * @param database the database to which is a new instance connected.
   */

  public CompanyBookingListT(DataBaseT database)
  {
    super(database);
    this.bookingList = new BookingListT(database);
  }

  /**
   * Name of the table in which are elements stored in the database.
   */

  private final String companyBookingTableName = "CompanyBooking";

  /**
   * The primary key name of the table in which are elements stored in the
   * database.
   */

  private final String companyBookingTableKeyName = "IDNumber";

  /**
   * List of names of all the table columns in the database.
   *
   * @param prefix string prefix to be added to all table column names.
   */

  public static final String tableColumns(String prefix)
  {
    return prefix + "IDNumber, " +
           prefix + "OrderingParty, " +
           prefix + "Presentation";
  }

  public String toString()
  {
    return "List of " + count() + " CompanyBookings";
  }

  public boolean create()
  {
    bookingList.create();
    return create(companyBookingTableName, CompanyBookingT.SQLCreateStringNew(""));
  }

  public boolean destroy()
  {
    return destroy(companyBookingTableName);
  }

  public boolean add(Ancestor element)
  {
    return bookingList.add(element) &&
           add(companyBookingTableName, tableColumns(""), element.toSQLAddStringNew());
  }

  public boolean remove(Object key)
  {
    return remove(companyBookingTableName, companyBookingTableKeyName, key) &&
           bookingList.remove(key);
  }

  public boolean modify(Ancestor element)
  {
    boolean Ok = modify(companyBookingTableName, companyBookingTableKeyName, element.toSQLModifyStringNew(""), element.getKey());
    if (!Ok)
    {
      Ok = add(element);
    }
    else
    {
      Ok = bookingList.modify(element);
    }
    return Ok;
  }

  public int count()
  {
    return count(companyBookingTableName);
  }

  public Ancestor get(int index)
  {

    // Get data from database
    ResultSet Result = get(companyBookingTableName, index);

    // No data
    if (Result == null)
    {
      return null;
    }

    // There is data, now find right row
    try
    {
      while (Result.next() && (index > 0))
      {
        index = index - 1;
      }
    }
    catch (SQLException e)
    {
      return null;
    }

    // Row is found
    if (index == 0)
    {
      CompanyBookingT CompanyBooking = new CompanyBookingT(Result, 1);
      CompanyBooking.assignFromBooking( (BookingT) bookingList.find(CompanyBooking.getKey()));
      database.close(Result);
      CompanyBooking.setCompanyList(companyList);
      CompanyBooking.setPresentationList(presentationList);
      return CompanyBooking;
    }

    // Row not found
    return null;

  }

  public Ancestor find(Object key)
  {

    // Get data from database
    ResultSet Result = find(companyBookingTableName, companyBookingTableKeyName, key);

    // No data
    if (Result == null)
    {
      return null;
    }

    // There is data
    try
    {
      if (Result.next())
      {
        CompanyBookingT CompanyBooking = new CompanyBookingT(Result, 1);
        CompanyBooking.assignFromBooking( (BookingT) bookingList.find(key));
        database.close(Result);
        CompanyBooking.setCompanyList(companyList);
        CompanyBooking.setPresentationList(presentationList);
        return CompanyBooking;
      }
    }
    catch (SQLException e)
    {
      return null;
    }

    // There are no rows
    return null;

  }

  /**
   * Sets associated list to a desired one.
   *
   * @param value a new list to be associated with.
   */

  public void setCompanyList(CompanyListT value)
  {
    this.companyList = value;
  }

  public CompanyListT getCompanyList()
  {
    return companyList;
  }

  /**
   * Sets associated list to a desired one.
   *
   * @param value a new list to be associated with.
   */

  public void setPresentationList(CompanyPresentationListT value)
  {
    this.presentationList = value;
  }

  public CompanyPresentationListT getPresentationList()
  {
    return presentationList;
  }

}
