
package semorg.booking;

import java.sql.ResultSet;
import java.sql.SQLException;

import semorg.classes.DateT;
import semorg.person.ClientListT;
import semorg.person.ClientT;
import semorg.presentation.ClientPresentationListT;
import semorg.presentation.ClientPresentationT;

/**
 * Objects of this class are representing bookings in the database.
 *
 * @author Ivan Pribela
 * @version 1.2
 */

public class ClientBookingT extends BookingT
{

  /**
   * Holds information about the booking.
   */

  private Long participiant;

  /**
   * Holds information about the booking.
   */

  private Long substitute;

  /**
   * Holds information about the booking.
   */

  private Long customer;

  /**
   * Holds information about the booking.
   */

  private Long presentation;

  /**
   * The list of clients.
   */

  private ClientListT clientList;

  /**
   * The list of presentations.
   */

  private ClientPresentationListT presentationList;

  /**
   * Constructs a new instace with default values for all fields.
   */

  public ClientBookingT()
  {
    super();
    participiant = null;
    substitute = null;
    customer = null;
    presentation = null;
  }

  /**
   * Constructs a new instace with the given field values.
   *
   * @param IDNumber ID number for this booking
   * @param registered date of registration for this booking
   * @param confirmation date of confirmation for this booking
   * @param bill date of bill for this booking
   * @param checkedOut date of  checking out for this booking
   * @param notification date of notification for this booking
   * @param participiant participant for this booking
   * @param substitute substitution for this booking
   * @param customer customer for this booking
   * @param presentation the presentation for this booking
   */

  public ClientBookingT(long IDNumber, DateT registered, DateT confirmation, DateT bill, DateT checkedOut, DateT notification, Long participiant, Long substitute, Long customer, Long presentation)
  {
    super(IDNumber, registered, confirmation, bill, checkedOut, notification);
    this.participiant = participiant;
    this.substitute = substitute;
    this.customer = customer;
    this.presentation = presentation;
  }

  /**
   * Constructs a new instace from the database.
   *
   * @param SQL a <code>ResultSet</code> instance holdin the information from
   *            the database.
   * @param column starting column from which to read data.
   */

  public ClientBookingT(ResultSet SQL, int Column)
  {
    participiant = null;
    substitute = null;
    customer = null;
    presentation = null;
    try
    {
      setIDNumber(SQL.getLong(Column)); Column++;
      participiant = new Long(SQL.getLong(Column)); Column++;
      substitute = new Long(SQL.getLong(Column)); Column++;
      customer = new Long(SQL.getLong(Column)); Column++;
      presentation = new Long(SQL.getLong(Column)); Column++;
    }
    catch (SQLException e)
    {
    }
  }

  /**
   * Assigns all atributes from the given booking.
   *
   * @param booking object containing values to be assigned to atributes.
   */

  public void assignFromBooking(BookingT booking)
  {
    if ((booking != null) && (booking.getIDNumber() == getIDNumber()))
    {
      setRegistered(booking.getRegistered());
      setConfirmation(booking.getConfirmation());
      setBill(booking.getBill());
      setCheckedOut(booking.getCheckedOut());
      setNotification(booking.getNotification());
    }
  }

  /**
   * Returns the number of columns of the apropriate table in the database.
   *
   * @return the number of columns of the apropriate table in the database.
   */

  public static int noOfSQLColumns()
  {
    return 5;
  }

  /**
   * Returns string representation that is used for creating the corresponding
   * table in the database.
   *
   * @param prefix prefix string added to all database column names.
   * @return string representation that is used for creating the corresponding
   *         table in the database.
   */

  public static String SQLCreateStringNew(String prefix)
  {
    return prefix + "IDNumber int, " +
           prefix + "Participiant int, " +
           prefix + "Substitute int, " +
           prefix + "Customer int, " +
           prefix + "Presentation int, " +
           prefix + "CONSTRAINT PK_ClientBooking PRIMARY KEY (IDNumber)";
  }

  public String toSQLAddStringNew()
  {
    return getIDNumber() + ", " +
           ((participiant != null) ? participiant.toString() : "NULL") + ", " +
           ((substitute != null) ? substitute.toString() : "NULL") + ", " +
           ((customer != null) ? customer.toString() : "NULL") + ", " +
           ((presentation != null) ? presentation.toString() : "NULL");
  }

  public String toSQLModifyStringNew(String prefix)
  {
    return prefix + "IDNumber = " + getIDNumber() + ", " +
           prefix + "Participiant = " + ((participiant != null) ? participiant.toString() : "NULL") + ", " +
           prefix + "Substitute = " + ((substitute != null) ? substitute.toString() : "NULL") + ", " +
           prefix + "Customer = " + ((customer != null) ? customer.toString() : "NULL") + ", " +
           prefix + "Presentation = " + ((presentation != null) ? presentation.toString() : "NULL");
  }

  /**
   * Returns participant for this booking.
   *
   * @return client that is participant for this booking.
   */

  public ClientT getParticipiant()
  {
    if (clientList == null)
    {
      return null;
    }
    else if (participiant == null)
    {
      return null;
    }
    else
    {
      return (ClientT) clientList.find(participiant);
    }
  }

  /**
   * Returns the substitution for this booking.
   *
   * @return client that is substitution for this presentation.
   */

  public ClientT getSubstitute()
  {
    if (clientList == null)
    {
      return null;
    }
    else if (substitute == null)
    {
      return null;
    }
    else
    {
      return (ClientT) clientList.find(substitute);
    }
  }

  /**
   * Return the customer for this booking.
   *
   * @return client that is customer for this booking.
   */

  public ClientT getCustomer()
  {
    if (clientList == null)
    {
      return null;
    }
    else if (customer == null)
    {
      return null;
    }
    else
    {
      return (ClientT) clientList.find(customer);
    }
  }

  /**
   * Returns presentation for this booking.
   *
   * @return presentation for this booking.
   */

  public ClientPresentationT getPresentation()
  {
    if (presentationList == null)
    {
      return null;
    }
    else if (presentation == null)
    {
      return null;
    }
    else
    {
      return (ClientPresentationT) presentationList.find(presentation);
    }
  }

  /**
   * Sets participant for this booking.
   *
   * @param value new value.
   */

  public void setParticipiant(ClientT value)
  {
    if (value != null)
    {
      participiant = new Long(value.getIDNumber());
    }
    else
    {
      participiant = null;
    }
  }

  /**
   * Sets participant for this booking.
   *
   * @param value new value.
   */

  public void setParticipiant(Long value)
  {
    participiant = value;
  }

  /**
   * Sets substitute for this booking.
   *
   * @param value new value.
   */

  public void setSubstitute(ClientT value)
  {
    if (value != null)
    {
      substitute = new Long(value.getIDNumber());
    }
    else
    {
      substitute = null;
    }
  }

  /**
   * Sets substitute for this booking.
   *
   * @param value new value.
   */

  public void setSubstitute(Long value)
  {
    substitute = value;
  }

  /**
   * Sets customer for this booking.
   *
   * @param value new value.
   */

  public void setCustomer(ClientT value)
  {
    if (value != null)
    {
      customer = new Long(value.getIDNumber());
    }
    else
    {
      customer = null;
    }
  }

  /**
   * Sets customer for this booking.
   *
   * @param value new value.
   */

  public void setCustomer(Long value)
  {
    customer = value;
  }

  /**
   * Sets presentation for this booking.
   *
   * @param value new value.
   */

  public void setPresentation(ClientPresentationT value)
  {
    if (value != null)
    {
      presentation = new Long(value.getIDNumber());
    }
    else
    {
      presentation = null;
    }
  }

  /**
   * Sets presentation for this booking.
   *
   * @param value new value.
   */

  public void setPresentation(Long value)
  {
    presentation = value;
  }

  /**
   * Sets client list for this booking.
   *
   * @param value client list for this booking
   */

  public void setClientList(ClientListT value)
  {
    this.clientList = value;
  }

  /**
   * Set presentation list for this booking.
   *
   * @param value presentation list for this booking.
   */

  public void setPresentationList(ClientPresentationListT value)
  {
    this.presentationList = value;
  }

}
