
package semorg.booking;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

import semorg.classes.Ancestor;
import semorg.classes.DataBaseT;
import semorg.classes.List;
import semorg.person.ClientListT;
import semorg.presentation.ClientPresentationListT;

/**
 * Instances of this class represent list of elements that are contained in the
 * associated database.
 *
 * @author Ivan Pribela
 * @version 1.2
 */

public class ClientBookingListT extends List
{

  /**
   * The associated list.
   */

  private BookingListT bookingList;

  /**
   * The associated list.
   */

  private ClientListT clientList;

  /**
   * The associated list.
   */

  private ClientPresentationListT presentationList;

  /**
   * Creates a new instance associated with the database with the given
   * connection.
   *
   * @param DBConnection connection with the database.
   */

  public ClientBookingListT(Connection DBConnection)
  {
    super(DBConnection);
    this.bookingList = new BookingListT(database);
  }

  /**
   * Creates a new instance associated with the given database.
   *
   * @param database the database to which is a new instance connected.
   */

  public ClientBookingListT(DataBaseT database)
  {
    super(database);
    this.bookingList = new BookingListT(database);
  }

  /**
   * Name of the table in which are elements stored in the database.
   */

  private final String clientBookingTableName = "ClientBooking";

  /**
   * The primary key name of the table in which are elements stored in the
   * database.
   */

  private final String clientBookingTableKeyName = "IDNumber";

  /**
   * List of names of all the table columns in the database.
   *
   * @param prefix string prefix to be added to all table column names.
   */

  public static final String tableColumns(String prefix)
  {
    return prefix + "IDNumber, " +
           prefix + "Participiant, " +
           prefix + "Substitute, " +
           prefix + "Customer, " +
           prefix + "Presentation";
  }

  public String toString()
  {
    return "List of " + count() + " ClientBookings";
  }

  public boolean create()
  {
    bookingList.create();
    return create(clientBookingTableName, ClientBookingT.SQLCreateStringNew(""));
  }

  public boolean destroy()
  {
    return destroy(clientBookingTableName);
  }

  public boolean destroy(boolean all)
  {
    destroy(clientBookingTableName);
    return destroy("Booking");
  }

  public boolean add(Ancestor element)
  {
    return bookingList.add(element) &&
           add(clientBookingTableName, tableColumns(""), element.toSQLAddStringNew());
  }

  public boolean remove(Object key)
  {
    return remove(clientBookingTableName, clientBookingTableKeyName, key) &&
           bookingList.remove(key);
  }

  public boolean modify(Ancestor element)
  {
    boolean Ok = modify(clientBookingTableName, clientBookingTableKeyName, element.toSQLModifyStringNew(""), element.getKey());
    if (!Ok)
    {
      Ok = add(element);
    }
    else
    {
      Ok = bookingList.modify(element);
    }
    return Ok;
  }

  public int count()
  {
    return count(clientBookingTableName);
  }

  public Ancestor get(int index)
  {

    // Get data from database
    ResultSet Result = get(clientBookingTableName, index);

    // No data
    if (Result == null)
    {
      return null;
    }

    // There is data, now find right row
    try
    {
      while (Result.next() && (index > 0))
      {
        index = index - 1;
      }
    }
    catch (SQLException e)
    {
      return null;
    }

    // Row is found
    if (index == 0)
    {
      ClientBookingT ClientBooking = new ClientBookingT(Result, 1);
      ClientBooking.assignFromBooking((BookingT)bookingList.find(ClientBooking.getKey()));
      database.close(Result);
      ClientBooking.setClientList(clientList);
      ClientBooking.setPresentationList(presentationList);
      return ClientBooking;
    }

    // Row not found
    return null;

  }

  public Ancestor find(Object key)
  {

    // Get data from database
    ResultSet Result = find(clientBookingTableName, clientBookingTableKeyName, key);

    // No data
    if (Result == null)
    {
      return null;
    }

    // There is data
    try
    {
      if (Result.next())
      {
        ClientBookingT ClientBooking = new ClientBookingT(Result, 1);
        ClientBooking.assignFromBooking( (BookingT) bookingList.find(key));
        database.close(Result);
        ClientBooking.setClientList(clientList);
        ClientBooking.setPresentationList(presentationList);
        return ClientBooking;
      }
    }
    catch (SQLException e)
    {
      return null;
    }

    // There are no rows
    return null;

  }

  /**
   * Sets associated list to a desired one.
   *
   * @param value a new list to be associated with.
   */

  public void setClientList(ClientListT value)
  {
    this.clientList = value;
  }

  public ClientListT getClientList()
  {
    return clientList;
  }

  /**
   * Sets associated list to a desired one.
   *
   * @param value a new list to be associated with.
   */

  public void setPresentationList(ClientPresentationListT value)
  {
    this.presentationList = value;
  }

  public ClientPresentationListT getPresentationList()
  {
    return presentationList;
  }

}
