
package semorg.booking;

import java.sql.ResultSet;
import java.sql.SQLException;

import semorg.classes.Ancestor;
import semorg.classes.DateT;

/**
 * Objects of this class are representing bookings in the database.
 *
 * @author Ivan Pribela
 * @version 1.2
 */

public class BookingT extends Ancestor
{

  /**
   * Holds information about the booking.
   */

  private long IDNumber;

  /**
   * Holds information about the booking.
   */

  private DateT registered;

  /**
   * Holds information about the booking.
   */

  private DateT confirmation;

  /**
   * Holds information about the booking.
   */

  private DateT bill;

  /**
   * Holds information about the booking.
   */

  private DateT checkedOut;

  /**
   * Holds information about the booking.
   */

  private DateT notification;

  /**
   * Constructs a new instace with default values for all fields.
   */

  public BookingT()
  {
    IDNumber = 0;
    registered = new DateT();
    confirmation = new DateT();
    bill = new DateT();
    checkedOut = new DateT();
    notification = new DateT();
  }

  /**
   * Constructs a new instace with the given field values.
   *
   * @param IDNumber ID number for this booking
   * @param registered date of registration for this booking
   * @param confirmation date of confirmation for this booking
   * @param bill date of bill for this booking
   * @param checkedOut date of checking out for this booking
   * @param notification date of notification for this booking
   */

  public BookingT(long IDNumber, DateT registered, DateT confirmation, DateT bill, DateT checkedOut, DateT notification)
  {
    this.IDNumber = IDNumber;
    this.registered = registered;
    this.confirmation = confirmation;
    this.bill = bill;
    this.checkedOut = checkedOut;
    this.notification = notification;
  }

  /**
   * Constructs a new instace from the database.
   *
   * @param SQL a <code>ResultSet</code> instance holdin the information from
   *            the database.
   * @param column starting column from which to read data.
   */

  public BookingT(ResultSet SQL, int Column)
  {
    this();
    try
    {
      IDNumber = SQL.getLong(Column); Column++;
      registered = new DateT(SQL, Column); Column += DateT.noOfSQLColumns();
      confirmation = new DateT(SQL, Column); Column += DateT.noOfSQLColumns();
      bill = new DateT(SQL, Column); Column += DateT.noOfSQLColumns();
      checkedOut = new DateT(SQL, Column); Column += DateT.noOfSQLColumns();
      notification = new DateT(SQL, Column); Column += DateT.noOfSQLColumns();
    }
    catch (SQLException e)
    {
    }
  }

  /**
   * Returns the number of columns of the apropriate table in the database.
   *
   * @return the number of columns of the apropriate table in the database.
   */

  public static int noOfSQLColumns()
  {
    return 1 + 5 * DateT.noOfSQLColumns();
  }

  /**
   * Returns string representation that is used for creating the corresponding
   * table in the database.
   *
   * @param prefix prefix string added to all database column names.
   * @return string representation that is used for creating the corresponding
   *         table in the database.
   */

  public static String SQLCreateString(String prefix)
  {
    return prefix + "IDNumber int, " +
           DateT.SQLCreateString(prefix + "Registered") + ", " +    
           DateT.SQLCreateString(prefix + "Confirmation") + ", " +    
           DateT.SQLCreateString(prefix + "Bill") + ", " +    
           DateT.SQLCreateString(prefix + "CheckedOut") + ", " +    
           DateT.SQLCreateString(prefix + "Notification") + ", " +    
           prefix + "CONSTRAINT PK_Booking PRIMARY KEY (IDNumber)";
  }

  public String toSQLAddString()
  {
    return getIDNumber() + ", " +
           getRegistered().toSQLAddString() + ", " +
           getConfirmation().toSQLAddString() + ", " +
           getBill().toSQLAddString() + ", " +
           getCheckedOut().toSQLAddString() + ", " +
           getNotification().toSQLAddString();
  }

  public String toSQLModifyString(String prefix)
  {
    return prefix + "IDNumber = " + getIDNumber() + ", " +
           getRegistered().toSQLModifyString(prefix + "Registered") + ", " +
           getConfirmation().toSQLModifyString(prefix + "Confirmation") + ", " +
           getBill().toSQLModifyString(prefix + "Bill") + ", " +
           getCheckedOut().toSQLModifyString(prefix + "CheckedOut") + ", " +
           getNotification().toSQLModifyString(prefix + "Notification");
  }

  public String toString()
  {
    return "ID: " + IDNumber + ", Registered: " + registered;
  }

  /**
   * Returns identification of a booking.
   *
   * @return identification of a booking.
   */

  public long getIDNumber()
  {
    return IDNumber;
  }

  /**
   * Returns date of registration of this booking.
   *
   * @return date of registration of this booking.
   */

  public DateT getRegistered()
  {
    return registered;
  }

  /**
   * Returns date of confirmation for this booking.
   *
   * @return date of confirmation for this booking.
   */

  public DateT getConfirmation()
  {
    return confirmation;
  }

  /**
   * Returns date of the bill for this booking.
   *
   * @return date of the bill for this booking.
   */

  public DateT getBill()
  {
    return bill;
  }

  /**
   * Returns date of cheking out for this booking.
   *
   * @return date of cheking out for this booking.
   */

  public DateT getCheckedOut()
  {
    return checkedOut;
  }

  /**
   * Returns date of notification for this booking.
   *
   * @return date of notification for this booking.
   */

  public DateT getNotification()
  {
    return notification;
  }

  /**
   * Sets identification of this booking.
   *
   * @param value new value.
   */

  public void setIDNumber(long value)
  {
    IDNumber = value;
  }

  /**
   * Sets the date of registration for this booking.
   *
   * @param value new value.
   */

  public void setRegistered(DateT value)
  {
    registered = value;
  }

  /**
   * Sets date of confirmation for this booking.
   *
   * @param value new value.
   */

  public void setConfirmation(DateT value)
  {
    confirmation = value;
  }

  /**
   * Sets date of the bill for this booking.
   *
   * @param value new value.
   */

  public void setBill(DateT value)
  {
    bill = value;
  }

  /**
   * Sets date of cheking out for this booking.
   *
   * @param value new value.
   */

  public void setCheckedOut(DateT value)
  {
    checkedOut = value;
  }

  /**
   * Sets date of notification for this booking.
   *
   * @param value new value.
   */

  public void setNotification(DateT value)
  {
    notification = value;
  }

  /**
   * Registers the booking. Sets the current date for the date of registering.
   */

  public void register()
  {
    registered = new DateT(System.currentTimeMillis());
  }

  /**
   * Checks out the booking. Sets the current date for the date of checking out.
   */

  public void checkOut()
  {
    checkedOut = new DateT(System.currentTimeMillis());
  }

  /**
   * Notifies the booking. Sets the current date for the date of notification.
   */

  public void produceNotification()
  {
    notification = new DateT(System.currentTimeMillis());
  }

  /**
   * Aproves the payment for the booking. Sets the current date for the date of bill.
   */

  public void provePayment()
  {
    bill = new DateT(System.currentTimeMillis());
  }

  public Object getKey()
  {
    return new Long(getIDNumber());
  }

}
