
package semorg.booking;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

import semorg.classes.Ancestor;
import semorg.classes.DataBaseT;
import semorg.classes.DateT;
import semorg.classes.List;

/**
 * Instances of this class represent list of elements that are contained in the
 * associated database.
 *
 * @author Ivan Pribela
 * @version 1.2
 */

public class BookingListT extends List
{

  /**
   * Creates a new instance associated with the database with the given
   * connection.
   *
   * @param DBConnection connection with the database.
   */

  public BookingListT(Connection DBConnection)
  {
    super(DBConnection);
  }

  /**
   * Creates a new instance associated with the given database.
   *
   * @param database the database to which is a new instance connected.
   */

  public BookingListT(DataBaseT database)
  {
    super(database);
  }

  /**
   * Name of the table in which are elements stored in the database.
   */

  private final String bookingTableName = "Booking";

  /**
   * The primary key name of the table in which are elements stored in the
   * database.
   */

  private final String bookingTableKeyName = "IDNumber";

  /**
   * List of names of all the table columns in the database.
   *
   * @param prefix string prefix to be added to all table column names.
   */

  public static final String tableColumns(String prefix)
  {
    return prefix + "IDNumber, " +
           DateT.tableColumns(prefix + "Registered") + ", " +
   	       DateT.tableColumns(prefix + "Confirmation") + ", " +
   	       DateT.tableColumns(prefix + "Bill") + ", " +
   	       DateT.tableColumns(prefix + "CheckedOut") + ", " +
   	       DateT.tableColumns(prefix + "Notification");
  }

  public String toString()
  {
    return "List of " + count() + " Bookings";
  }

  public boolean create()
  {
    return create(bookingTableName, BookingT.SQLCreateString(""));
  }

  public boolean destroy()
  {
    return destroy(bookingTableName);
  }

  public boolean add(Ancestor element)
  {
    return add(bookingTableName, tableColumns(""), element.toSQLAddString());
  }

  public boolean remove(Object key)
  {
    return remove(bookingTableName, bookingTableKeyName, key);
  }

  public boolean modify(Ancestor element)
  {
    boolean Ok = modify(bookingTableName, bookingTableKeyName, element.toSQLModifyString(""), element.getKey());
    if (!Ok)
    {
      Ok = add(element);
    }
    return Ok;
  }

  public int count()
  {
    return count(bookingTableName);
  }

  public Ancestor get(int index)
  {

    // Get data from database
    ResultSet Result = get(bookingTableName, index);

    // No data
    if (Result == null)
    {
      return null;
    }

    // There is data, now find right row
    try
    {
      while (Result.next() && (index > 0))
      {
        index = index - 1;
      }
    }
    catch (SQLException e)
    {
      return null;
    }

    // Row is found
    if (index == 0)
    {
      BookingT Booking = new BookingT(Result, 1);
      database.close(Result);
      return Booking;
    }

    // Row not found
    return null;

  }

  public Ancestor find(Object key)
  {

    // Get data from database
    ResultSet Result = find(bookingTableName, bookingTableKeyName, key);

    // No data
    if (Result == null)
    {
      return null;
    }

    // There is data
    try
    {
      if (Result.next())
      {
        BookingT Booking = new BookingT(Result, 1);
        database.close(Result);
        return Booking;
      }
    }
    catch (SQLException e)
    {
      return null;
    }

    // There are no rows
    return null;

  }

}
