
package semorg;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

import semorg.booking.ClientBookingListT;
import semorg.booking.CompanyBookingListT;
import semorg.classes.DataBaseT;
import semorg.company.CompanyListT;
import semorg.person.AssociateListT;
import semorg.person.ClientListT;
import semorg.person.DocentListT;
import semorg.presentation.ClientPresentationListT;
import semorg.presentation.CompanyPresentationListT;
import semorg.seminar.CanConductListT;
import semorg.seminar.SeminarListT;

/**
 * Instances of this class hold all lists of objects needed by application.
 *
 * @author Ivan Pribela
 * @version 1.0
 */

public class SemOrgListsT extends Object
{
	
//----------------------------------------------------------------------------------
// Holds the information about a chosen database.
//----------------------------------------------------------------------------------
	
// Database driver name
private static String chosenDataBaseDriver = "com.borland.datastore.jdbc.DataStoreDriver";

// Database URL
private static String chosenDatabaseURL = "jdbc:borland:dslocal:SemOrg.jds";

// username
private static String databaseUsername = "semorg";

// password
private static String databasePassword = "semorg";

//----------------------------------------------------------------------------------
  
  /**
   * Holds needed information.
   */

  private DataBaseT database;

  /**
   * Holds needed information.
   */

  private CompanyListT companyList;

  /**
   * Holds needed information.
   */

  private ClientListT clientList;

  /**
   * Holds needed information.
   */

  private CompanyBookingListT companyBookingList;

  /**
   * Holds needed information.
   */

  private ClientBookingListT clientBookingList;

  /**
   * Holds needed information.
   */

  private AssociateListT associateList;

  /**
   * Holds needed information.
   */

  private SeminarListT seminarList;

  /**
   * Holds needed information.
   */

  private ClientPresentationListT clientPresentationList;

  /**
   * Holds needed information.
   */

  private CompanyPresentationListT companyPresentationList;

  /**
   * Holds needed information.
   */

  private DocentListT docentList;

  /**
   * Holds needed information.
   */

  private CanConductListT canConductList;

  /**
   * Constructs a new instance from the default database.
   */

  public SemOrgListsT() throws ClassNotFoundException, SQLException
  {
    this(chosenDataBaseDriver, chosenDatabaseURL, databaseUsername, databasePassword);
  }

  /**
   * Constructs a new instance from the specified database.
   */

  public SemOrgListsT(String driverClass, String databaseName, String userName, String password) throws ClassNotFoundException, SQLException
  {
    Class.forName(driverClass);
    Connection conn = DriverManager.getConnection(databaseName, userName, password);
    this.database = new DataBaseT(conn);
    createAllLists();
  }

  /**
   * Constructs a new instance from the given database connection.
   */

  public SemOrgListsT(Connection DBConnection)
  {
    this(new DataBaseT(DBConnection));
  }

  /**
   * Constructs a new instance from the database.
   */

  public SemOrgListsT(DataBaseT database)
  {
    this.database = database;
  }

  /**
   * Returns a String object representing this list.
   *
   * @return a string representation of this list.
   */

  public String toString()
  {
    return "'Seminar Organisation' objects lists";
  }

  /**
   * Creates all the lists.
   */

  private void createAllLists()
  {
    if (database != null)
    {

      clientList = new ClientListT(database);
      companyList = new CompanyListT(database);
      clientList.setCompanyList(companyList);
      companyList.setClientList(clientList);

      associateList = new AssociateListT(database);

      seminarList = new SeminarListT(database);
      clientPresentationList = new ClientPresentationListT(database);
      companyPresentationList = new CompanyPresentationListT(database);

      clientPresentationList.setSeminarList(seminarList);
      companyPresentationList.setSeminarList(seminarList);

      clientBookingList = new ClientBookingListT(database);
      companyBookingList = new CompanyBookingListT(database);
      clientBookingList.setClientList(clientList);
      companyBookingList.setCompanyList(companyList);
      clientBookingList.setPresentationList(clientPresentationList);
      companyBookingList.setPresentationList(companyPresentationList);

      docentList = new DocentListT(database);

      canConductList = new CanConductListT(database);
      canConductList.setDocentList(docentList);
      canConductList.setSeminarList(seminarList);
      docentList.setCanConductList(canConductList);
      seminarList.setCanConductList(canConductList);

    }
  }

  /**
   * Returns requested information.
   *
   * @return requested information.
   */

  public DataBaseT getDataBase()
  {
    return database;
  }

  /**
   * Returns requested list.
   *
   * @return requested list.
   */

  public CompanyListT getCompanyList()
  {
    return companyList;
  }

  /**
   * Returns requested list.
   *
   * @return requested list.
   */

  public ClientListT getClientList()
  {
    return clientList;
  }

  /**
   * Returns requested list.
   *
   * @return requested list.
   */

  public CompanyBookingListT getCompanyBookingList()
  {
    return companyBookingList;
  }

  /**
   * Returns requested list.
   *
   * @return requested list.
   */

  public ClientBookingListT getClientBookingList()
  {
    return clientBookingList;
  }

  /**
   * Returns requested list.
   *
   * @return requested list.
   */

  public AssociateListT getAssociateList()
  {
    return associateList;
  }

  /**
   * Returns requested list.
   *
   * @return requested list.
   */

  public SeminarListT getSeminarList()
  {
    return seminarList;
  }

  /**
   * Returns requested list.
   *
   * @return requested list.
   */

  public ClientPresentationListT getClientPresentationList()
  {
    return clientPresentationList;
  }

  /**
   * Returns requested list.
   *
   * @return requested list.
   */

  public CompanyPresentationListT getCompanyPresentationList()
  {
    return companyPresentationList;
  }

  public DocentListT getDocentList()
  {
    return docentList;
  }

  /**
   * Returns requested list.
   *
   * @return requested list.
   */

  public CanConductListT getCanConductList()
  {
    return canConductList;
  }

  /**
   * Sets desired information.
   *
   * @param value new information.
   */

  public void setDataBase(DataBaseT value)
  {
    database = value;
    createAllLists();
  }

  /**
   * Sets the list to given one.
   *
   * @param value new list.
   */

  public void setCompanyList(CompanyListT value)
  {
    companyList = value;
    clientList.setCompanyList(companyList);
    companyList.setClientList(clientList);
    companyBookingList.setCompanyList(companyList);
  }

  /**
   * Sets the list to given one.
   *
   * @param value new list.
   */

  public void setClientList(ClientListT value)
  {
    clientList = value;
    clientList.setCompanyList(companyList);
    companyList.setClientList(clientList);
    clientBookingList.setClientList(clientList);
  }

  /**
   * Sets the list to given one.
   *
   * @param value new list.
   */

  public void setCompanyBookingList(CompanyBookingListT value)
  {
    companyBookingList = value;
    companyBookingList.setCompanyList(companyList);
    companyBookingList.setPresentationList(companyPresentationList);
  }

  /**
   * Sets the list to given one.
   *
   * @param value new list.
   */

  public void setClientBookingList(ClientBookingListT value)
  {
    clientBookingList = value;
    clientBookingList.setClientList(clientList);
    clientBookingList.setPresentationList(clientPresentationList);
  }

  /**
   * Sets the list to given one.
   *
   * @param value new list.
   */

  public void setAssociateList(AssociateListT value)
  {
    associateList = value;
  }

  /**
   * Sets the list to given one.
   *
   * @param value new list.
   */

  public void setSeminarList(SeminarListT value)
  {
    seminarList = value;
    clientPresentationList.setSeminarList(seminarList);
    companyPresentationList.setSeminarList(seminarList);
    canConductList.setSeminarList(seminarList);
    seminarList.setCanConductList(canConductList);
  }

  /**
   * Sets the list to given one.
   *
   * @param value new list.
   */

  public void setClientPresentationList(ClientPresentationListT value)
  {
    clientPresentationList = value;
    clientPresentationList.setSeminarList(seminarList);
    clientBookingList.setPresentationList(clientPresentationList);
  }

  /**
   * Sets the list to given one.
   *
   * @param value new list.
   */

  public void setCompanyPresentationList(CompanyPresentationListT value)
  {
    companyPresentationList = value;
    companyPresentationList.setSeminarList(seminarList);
    companyBookingList.setPresentationList(companyPresentationList);
  }

  /**
   * Sets the list to given one.
   *
   * @param value new list.
   */

  public void setDocentList(DocentListT value)
  {
    docentList = value;
    canConductList.setDocentList(docentList);
    docentList.setCanConductList(canConductList);
  }

  /**
   * Sets the list to given one.
   *
   * @param value new list.
   */

  public void setCanConductList(CanConductListT value)
  {
    canConductList = value;
    canConductList.setDocentList(docentList);
    canConductList.setSeminarList(seminarList);
    docentList.setCanConductList(canConductList);
    seminarList.setCanConductList(canConductList);
  }

  public void create()
  {
    companyList.create();
    clientList.create();
    companyBookingList.create();
    clientBookingList.create();
    associateList.create();
    seminarList.create();
    clientPresentationList.create();
    companyPresentationList.create();
    docentList.create();
    canConductList.create();
  }

  public void destroy()
  {
    companyList.destroy();
    clientList.destroy(true);
    companyBookingList.destroy();
    clientBookingList.destroy(true);
    associateList.destroy();
    seminarList.destroy();
    clientPresentationList.destroy(true);
    companyPresentationList.destroy();
    docentList.destroy();
    canConductList.destroy();
  }

  public void finish()
  {
    database.endSesion();
  }

}
