package semorg;

import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.UIManager;
import java.awt.event.WindowEvent;
import java.awt.event.WindowAdapter;

import semorg.gui.MainFrame;

public class SemOrgApp
{
  boolean packFrame = false;
  
  //Construct the application
  public SemOrgApp()
  {
    MainFrame frame = new MainFrame();
        
    //Validate frames that have preset sizes
    //Pack frames that have useful preferred size info, e.g. from their layout
    if (packFrame)
    {
      frame.pack();
    }
    else
    {
      frame.validate();
    }
    //Center the window
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    Dimension frameSize = frame.getSize();
    if (frameSize.height > screenSize.height)
    {
      frameSize.height = screenSize.height;
    }
    if (frameSize.width > screenSize.width)
    {
      frameSize.width = screenSize.width;
    }
    frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
     
      frame.addWindowListener(new WindowAdapter()
        {            
          public void windowClosing(WindowEvent e) 
          {
           System.exit(0);
          }
        }
       );
    frame.setVisible(true); 
  }
  //Main method
  public static void main(String[] args)
  {
    try
    {
      UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
         
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
    new SemOrgApp();
  }
}