package semorg.sql.util;

/** Models a pair of DB-IDs. */
public class KeyPair {

    /** The first id. */
    private int key1;
    /** The second id. */
    private int key2;

    /** Creates a {@link KeyPair} instance with the given parameters. */
    public KeyPair(int k1, int k2) {
	this.key1 = k1;
	this.key2 = k2;
    }

    /**
     * Compares two {@link KeyPair} instances (k1,k2) and (k3,k4).
     * 
     * @return <code>true</code>, if k1 = k3 and k2 = k4, otherwise
     *         <code>false</code>
     */
    public boolean equals(KeyPair toCompare) {
	return ((toCompare.getKey1() == this.key1) && (toCompare.getKey2() == this.key2));
    }

    public int getKey1() {
	return key1;
    }

    public int getKey2() {
	return key2;
    }
}
