package semorg.sql.util;

import java.util.Collection;
import java.util.Vector;

/**
 * This class complies the class {@link Vector}, exclusive the method
 * {@link #add(Object)} is now thread-safe.
 */
@SuppressWarnings("serial")
public class DistinctVector<E> extends Vector<E> {

    /** Creates a {@link DistinctVector} . */
    public DistinctVector() {
	super();
    }

    /**
     * Creates a {@link DistinctVector}, which gets initialized with the
     * elements of the given {@link Collection} instance.
     * 
     * @param collection
     *                {@link Collection} instance containing elements to
     *                initialize the new {@link DistinctVector}.
     */
    public DistinctVector(Collection<? extends E> collection) {
	super(collection);
    }

    /** 
     * Appends a new element at the end of a {@link DistinctVector}. 
     * 
     * @see Vector#add(Object)
     */
    @Override
    public synchronized boolean add(E elem) {
	if (!contains(elem))
	    return super.add(elem);
	else
	    return false;
    }
}
