package semorg.sql.util;

/**
 * Models a column of a GUI table used in several list windows. Instances of
 * this class serve as the connection between the database layer and the GUI
 * layer.
 */
public class DBColumn {
    /** Internal column name, used in the database layer. */
    private String internalColumnName;

    /** Public column name, used in the GUI layer. */
    private String publicColumnName;

    /** (Java-)Datatype of the column. */
    private Class columnType;

    /**
     * Creates a {@link DBColumn} instance with given parameters.
     * 
     * @param internalColumnName
     *                Internal column name, used in the database layer.
     * @param publicColumnName
     *                Public column name, used in the GUI layer.
     * @param columnType
     *                (Java-)Datatype of the column.
     */
    public DBColumn(String internalColumnName, String publicColumnName,
	    Class columnType) {
	this.internalColumnName = internalColumnName;
	this.publicColumnName = publicColumnName;
	this.columnType = columnType;
    }

    public String getInternalColumnName() {
	return internalColumnName;
    }

    public String getPublicColumnName() {
	return publicColumnName;
    }

    public Class getColumnType() {
	return columnType;
    }
}
