package semorg.gui.util;

/** This class encapsulates all properties of a column of a GUI table. */
public class TableColumnProperty {

    /** The index of the column. */
    private final int index;
    /** The number of a column. */
    private int columnNumber;
    /** The alignment of a column. */
    private int alignment;
    /** The width of a column. */
    private int width;
    /** If <tt>true</tt> the column can be resized by the user. Otherwise it is <tt>false</tt>. */
    private boolean resizable;
    /** The text (name) of a columns. */
    private String text;

    /** Creates a {@link TableColumnProperty} instance with the given values. */
    public TableColumnProperty(int index, int columnNumber, String text,
	    int alignment, int width, boolean resizable) {
	this.index = index;
	this.columnNumber = columnNumber;
	this.text = text;
	this.alignment = alignment;
	this.width = width;
	this.resizable = resizable;
    }

    public int getAlignment() {
	return alignment;
    }

    public void setAlignment(int alignment) {
	this.alignment = alignment;
    }

    public int getColumnNumber() {
	return columnNumber;
    }

    public void setColumnNumber(int columnNumber) {
	this.columnNumber = columnNumber;
    }

    public boolean getResizable() {
	return resizable;
    }

    public void setResizable(boolean resizable) {
	this.resizable = resizable;
    }

    public int getWidth() {
	return width;
    }

    public void setWidth(int width) {
	this.width = width;
    }

    public String getText() {
	return text;
    }

    public void setText(String text) {
	this.text = text;
    }

    public int getIndex() {
	return index;
    }

}
