package semorg.gui.util;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import semorg.gui.MainWindow;

/**
 * This class loads the dictionary files and inserts all strings seen by the
 * user. It considers thereby the chosen language by the user.
 */
public class Messages {

    /**
     * The resource bundle, which contains the german strings of the
     * application.
     */
    private static ResourceBundle RESOURCE_BUNDLE_DE = ResourceBundle
	    .getBundle("semorg.gui.languages.semorg_de");

    /**
     * The resource bundle, which contains the english strings of the
     * application.
     */
    private static ResourceBundle RESOURCE_BUNDLE_EN = ResourceBundle
	    .getBundle("semorg.gui.languages.semorg_en");

    private Messages() {
    }

    /**
     * Delivers for given key and the current language setting a string used in
     * the GUI.
     * 
     * @param key
     *                the key of the wanted string.
     * @return externalized string according to the given string. If the key is
     *         not found in the bundle it returns the key string surrounded by
     *         '!'.
     */
    public static String getString(String key) {

	try {
	    if (MainWindow.getInstance().getConfiguration().getProperty("language").equals(
		    "en")) {
		return RESOURCE_BUNDLE_EN.getString(key);
	    } else {
		return RESOURCE_BUNDLE_DE.getString(key);
	    }

	} catch (MissingResourceException e) {
	    return '!' + key + '!';
	}
    }
}
