package semorg.gui.util;

import java.sql.SQLException;
import java.util.Date;

import semorg.sql.tables.Presentation;
import semorg.sql.tables.SeminarType;

/**
 * This class is used for displaying the delayed payments. Since there is no
 * class which matches the wanted values we've got to use this one.
 */
public class DelayedPaymentItem {
    /** The id of the presentation the debtor didn't pay the charge for. */
    private int presentationId;
    /** The date of the billing unpaid. */
    private Date billed;
    /** The amount of money owed by a client */
    private Float debt;

    /**
     * Creates a DelayedPaymentItem object. Note that the constructor queries
     * the database to get the charge of the seminartype which equals the debt
     * of the debtor.
     */
    public DelayedPaymentItem(int presentationId, Date billed) {
	SeminarType tmpSemType = null;

	this.presentationId = presentationId;
	this.billed = billed;

	try {
	    tmpSemType = Presentation
		    .getSeminarTypeForPresId(this.presentationId);
	} catch (SQLException e) {
	    e.printStackTrace();
	}
	if (tmpSemType != null) {
	    this.debt = tmpSemType.getCharge();
	} else {
	    this.debt = null;
	}

    }

    public int getPresentationId() {
	return presentationId;
    }

    public Date getBilled() {
	return billed;
    }

    public Float getDebt() {
	return debt;
    }
}