package semorg.gui.util;

/**
 * Models a Listener which reacts on changes of the database tables. All child
 * classes are anonymous inner classes.
 */
public abstract class DBTableChangedListener {

    /** Indicates that the Listener is fired by a method of class AbstractTable. */
    public static final int TYPE_ABSTRACTTABLE = 0;

    /** Indicates that the Listener is fired by a method of class Associate. */
    public static final int TYPE_ASSOCIATE = 1;

    /** Indicates that the Listener is fired by a method of class Booking. */
    public static final int TYPE_BOOKING = 2;

    /** Indicates that the Listener is fired by a method of class Client. */
    public static final int TYPE_CLIENT = 3;

    /** Indicates that the Listener is fired by a method of class ClientBooking. */
    public static final int TYPE_CLIENTBOOKING = 4;

    /** Indicates that the Listener is fired by a method of class Company. */
    public static final int TYPE_COMPANY = 5;

    /** Indicates that the Listener is fired by a method of class CompanyBooking. */
    public static final int TYPE_COMPANYBOOKING = 6;

    /**
     * Indicates that the Listener is fired by a method of class
     * CompanyInternalPresentation.
     */
    public static final int TYPE_COMPANYINTERNALPRESENTATION = 7;

    /** Indicates that the Listener is fired by a method of class Conduct. */
    public static final int TYPE_CONDUCT = 8;

    /** Indicates that the Listener is fired by a method of class Enumeration. */
    public static final int TYPE_ENUMERATION = 9;

    /** Indicates that the Listener is fired by a method of class Instructor. */
    public static final int TYPE_INSTRUCTOR = 10;

    /** Indicates that the Listener is fired by a method of class Lecturer. */
    public static final int TYPE_LECTURER = 11;

    /** Indicates that the Listener is fired by a method of class Person. */
    public static final int TYPE_PERSON = 12;

    /** Indicates that the Listener is fired by a method of class Presentation. */
    public static final int TYPE_PRESENTATION = 13;

    /**
     * Indicates that the Listener is fired by a method of class
     * PublicPresentation.
     */
    public static final int TYPE_PUBLICPRESENTATION = 14;

    /** Indicates that the Listener is fired by a method of class Seminartype. */
    public static final int TYPE_SEMINARTYPE = 15;

    /** Indicates that the Listener is fired by a method of class Supervisor. */
    public static final int TYPE_SUPERVISOR = 16;

    /**
     * The type of the DBTableChangedListener. Indicates from which class the
     * listener was fired.
     */
    private int type;

    /**
     * Creates an DBTableChangedListener instance with the given type.
     * 
     * @param type
     *                the desired type of the new DBTableChangedListener
     */
    public DBTableChangedListener(int type) {
	this.type = type;
    }

    public final int getType() {
	return type;
    }

    /**
     * Performs the action of the listener. This class is implemented by
     * anonymous inner classes.
     */
    public abstract void dBTableChanged();
}
