package semorg.gui.util;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;

/**
 * Provides a dialog to configure the appearance of the GUI tables, i.e. the
 * shown columns, their sizes and so on.
 */
public class ConfigureListDlg extends Dialog {

    /** The columns of a GUI table. */
    private TableColumn[] columns;

    /** The order of the columns of a GUI table. */
    int[] columnOrder;

    /** The SWT widget to configure the appearance of the GUI tables. */
    private ConfigureListWidget chooseWidget;

    /**
     * Creates a {@link ConfigureListDlg} instance with the given parameters.
     * 
     * @param parent
     *                the parent shell of this dialog.
     * @param columns
     *                array of columns get manage.
     * @param columnOrder
     *                the order of the columns.
     */
    public ConfigureListDlg(Shell parent, TableColumn[] columns,
	    int[] columnOrder) {
	super(parent);
	this.columns = columns;
	this.columnOrder = columnOrder;
    }

    /**
     * Adds buttons to this dialog's button bar.
     * 
     * The Dialog implementation of this framework method adds standard ok and
     * cancel buttons using the createButton framework method. These standard
     * buttons will be accessible from getCancelButton, and getOKButton.
     * Subclasses may override.
     * 
     * @param parent
     *                the button bar composite
     * 
     * @see org.eclipse.jface.dialogs.Dialog#createButtonsForButtonBar(org.eclipse.swt.widgets.Composite)
     */
    protected void createButtonsForButtonBar(Composite parent) {
	createButton(parent, IDialogConstants.OK_ID, Messages
		.getString("GUIText.OkButtonText"), true);
	createButton(parent, IDialogConstants.CANCEL_ID, Messages
		.getString("GUIText.AbortButtonText"), false);
    }

    /**
     * Notifies that this dialog's button with the given id has been pressed.
     * 
     * The Dialog implementation of this framework method calls okPressed if the
     * ok button is the pressed, and cancelPressed if the cancel button is the
     * pressed. All other button presses are ignored. Subclasses may override to
     * handle other buttons, but should call super.buttonPressed if the default
     * handling of the ok and cancel buttons is desired.
     * 
     * @param buttonId
     *                the id of the button that was pressed (see
     *                IDialogConstants.*_ID constants)
     * 
     * @see org.eclipse.jface.dialogs.Dialog#buttonPressed(int)
     */
    protected void buttonPressed(int buttonId) {
	switch (buttonId) {
	case IDialogConstants.OK_ID:
	    okPressed();
	    break;
	case IDialogConstants.CANCEL_ID:
	    cancelPressed();
	    break;
	}
    }

    /**
     * Is invoked if the ok button is pressed. It simply sets the return code of
     * the window and closes it.
     * 
     * @see org.eclipse.jface.dialogs.Dialog#okPressed()
     */
    protected void okPressed() {
	setReturnCode(IDialogConstants.OK_ID);
	close();
    }

    /**
     * Is invoked if the cancel button is pressed. It simply sets the return
     * code of the window and closes it.
     * 
     * @see org.eclipse.jface.dialogs.Dialog#cancelPressed()
     */
    protected void cancelPressed() {
	setReturnCode(IDialogConstants.CANCEL_ID);
	close();
    }

    /**
     * Creates the {@link #chooseWidget} using the values of {@link #columns},
     * {@link #columnOrder} and the parameter.
     * 
     * @param parent
     *                the parent composite.
     * @return the created {@link #chooseWidget}.
     */
    protected Control createDialogArea(Composite parent) {
	chooseWidget = new ConfigureListWidget(parent, columns, columnOrder);

	applyDialogFont(chooseWidget);
	return chooseWidget;
    }

    /**
     * @return array of {@link TableColumnProperty} instances which contains the
     *         properties for each column.
     */
    public TableColumnProperty[] getColumnProperties() {
	return chooseWidget.getColumns();
    }

    /**
     * Configures the given shell.
     * 
     * @param shell
     *                the Shell to configure.
     */
    protected void configureShell(Shell shell) {
	super.configureShell(shell);
	shell.setText(Messages.getString("GUIText.ConfigureListWindowTitle"));
    }

}
