package semorg.gui.provider;

import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

import semorg.gui.list.AssociateListWindow;
import semorg.gui.list.SeminarTypeListWindow;
import semorg.sql.tables.SeminarType;
import semorg.sql.util.Utility;

/**
 * This class provides the data of the items in the GUI table in the
 * {@link SeminarTypeListWindow}.
 */
public class SeminarTypeTableProvider implements ITableLabelProvider {

    // not implemented
    public void dispose() {
    }

    // not implemented
    public Image getColumnImage(Object arg0, int arg1) {
	return null;
    }

    /**
     * Returns for given object and column number the appropriate value from the
     * object for the specified column.
     * 
     * @param input
     *                the object which contains the information
     * @param column
     *                the number of the column which should display a particular
     *                attribute of the given object.
     * @return particular attribute as a String.
     */
    public String getColumnText(Object input, int column) {
	SeminarType seminarType = (SeminarType) input;
	switch (column) {
	case 0:
	    return "" + seminarType.getId();
	case 1:
	    return seminarType.getShortTitle();
	case 2:
	    return seminarType.getTitle();
	case 3:
	    return seminarType.getObjective();
	case 4:
	    return seminarType.getMethodology();
	case 5:
	    return seminarType.getTopic();
	case 6:
	    return seminarType.getRoutine();
	case 7:
	    if (seminarType.getDuration() != null)
		return seminarType.getDuration().toString();
	    else
		return null;

	case 8:
	    return seminarType.getDocuments();
	case 9:
	    return seminarType.getAudience();
	case 10:
	    return seminarType.getRequirements();
	case 11:
	    if (seminarType.getCharge() != null)
		return Utility.createFloatText(seminarType.getCharge());
	    else
		return null;

	case 12:
	    if (seminarType.getMaxEntrants() != null)
		return seminarType.getMaxEntrants().toString();
	    else
		return null;

	case 13:
	    if (seminarType.getMinEntrants() != null)
		return seminarType.getMinEntrants().toString();
	    else
		return null;

	case 14:
	    if (seminarType.getCreationDate() != null) {
		return Utility.dateAndTimeFormatter.format(seminarType
			.getCreationDate());
	    } else
		return null;

	case 15:
	    if (seminarType.getModificationDate() != null) {
		return Utility.dateAndTimeFormatter.format(seminarType
			.getModificationDate());
	    } else
		return null;
	default:
	    return null;
	}
    }

    // not implemented
    public void addListener(ILabelProviderListener arg0) {
    }

    // not implemented
    public boolean isLabelProperty(Object arg0, String arg1) {
	return false;
    }

    // not implemented
    public void removeListener(ILabelProviderListener arg0) {
    }
}
