package semorg.gui.provider;

import semorg.gui.list.AssociateListWindow;
import semorg.gui.list.PublicPresentationListWindow;
import semorg.sql.tables.PublicPresentation;
import semorg.sql.util.Utility;

/**
 * This class provides the data of the items in the GUI table in the
 * {@link PublicPresentationListWindow}.
 */
public class PublicPresentationTableProvider extends PresentationTableProvider {

    /**
     * Returns for given object and column number the appropriate value from the
     * object for the specified column.
     * 
     * @param input
     *                the object which contains the information
     * @param column
     *                the number of the column which should display a particular
     *                attribute of the given object.
     * @return particular attribute as a String.
     */
    public String getColumnText(Object input, int column) {
	PublicPresentation presentation = (PublicPresentation) input;
	switch (column) {
	case 16:
	    return presentation.getCoopPartner();
	case 17:
	    if (presentation.getCancelFee() != null)
		return Utility.createFloatText(presentation.getCancelFee());
	    else
		return null;

	default:
	    if (column < 16)
		return super.getColumnText(input, column);
	    else
		return super.getColumnText(input, column - 2);
	}
    }
}
