package semorg.gui.provider;

import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

import semorg.gui.list.CompanyInternalPresentationListWindow;
import semorg.gui.list.PresentationListWindow;
import semorg.gui.list.PublicPresentationListWindow;
import semorg.gui.util.Messages;
import semorg.sql.tables.Presentation;
import semorg.sql.util.Utility;

/**
 * This class provides the common data attributes of the presentation items in
 * the GUI table in the {@link PublicPresentationListWindow},
 * {@link CompanyInternalPresentationListWindow} and the
 * {@link PresentationListWindow}.
 */
public class PresentationTableProvider implements ITableLabelProvider {
    // not implemented
    public void dispose() {
    }

    // not implemented
    public Image getColumnImage(Object arg0, int arg1) {
	return null;
    }

    /**
     * Returns for given object and column number the appropriate value from the
     * object for the specified column.
     * 
     * @param input
     *                the object which contains the information
     * @param column
     *                the number of the column which should display a particular
     *                attribute of the given object.
     * @return particular attribute as a String.
     */
    public String getColumnText(Object input, int column) {
	Presentation presentation = (Presentation) input;
	switch (column) {
	case 0:
	    return new Integer(presentation.getId()).toString();
	case 1:
	    return presentation.getSeminarTypeDescription();
	case 2:
	    if (presentation.getDuration() != null)
		return presentation.getDuration().toString();
	    else
		return null;
	case 3:
	    if (presentation.getBeginningDay() != null)
		return Utility.dateOnlyFormatter.format(presentation
			.getBeginningDay());
	    else
		return null;
	case 4:
	    if (presentation.getEndingDay() != null)
		return Utility.dateOnlyFormatter.format(presentation
			.getEndingDay());
	    else
		return null;
	case 5:
	    if (presentation.getStartingTime() != null)
		return Utility.timeOnlyFormatter.format(presentation
			.getStartingTime());
	    else
		return null;
	case 6:
	    if (presentation.getEndingTime() != null)
		return Utility.timeOnlyFormatter.format(presentation
			.getEndingTime());
	    else
		return null;
	case 7:
	    if (presentation.getFirstStartingTime() != null)
		return Utility.timeOnlyFormatter.format(presentation
			.getFirstStartingTime());
	    else
		return null;
	case 8:
	    if (presentation.getLastEndingTime() != null)
		return Utility.timeOnlyFormatter.format(presentation
			.getLastEndingTime());
	    else
		return null;
	case 9:
	    return presentation.getLocation();
	case 10:
	    return presentation.getStreet();
	case 11:
	    return presentation.getZipCode();
	case 12:
	    return presentation.getCity();
	case 13:
	    return presentation.getCountry();
	case 14:
	    return presentation.getAnnex();
	case 15:
	    return (presentation.isCancelled()) ? Messages
		    .getString("ProviderText.PresentationTableProviderIsCanceledText")
		    : Messages
			    .getString("ProviderText.PresentationTableProviderIsNotCanceledText");
	case 16:
	    if (presentation.getCreationDate() != null) {
		return Utility.dateAndTimeFormatter.format(presentation
			.getCreationDate());
	    } else
		return null;

	case 17:
	    if (presentation.getModificationDate() != null) {
		return Utility.dateAndTimeFormatter.format(presentation
			.getModificationDate());
	    }

	default:
	    return null;
	}
    }

    // not implemented
    public void addListener(ILabelProviderListener arg0) {
    }

    // not implemented
    public boolean isLabelProperty(Object arg0, String arg1) {
	return false;
    }

    // not implemented
    public void removeListener(ILabelProviderListener arg0) {
    }
}
