package semorg.gui.provider;

import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

import semorg.gui.list.AssociateListWindow;
import semorg.gui.list.LecturerListWindow;
import semorg.sql.tables.Lecturer;
import semorg.sql.util.Utility;

/**
 * This class provides the data of the items in the GUI table in the
 * {@link LecturerListWindow}.
 */
public class LecturerTableProvider implements ITableLabelProvider {
    // not implemented
    public void dispose() {
    }

    // not implemented
    public Image getColumnImage(Object arg0, int arg1) {
	return null;
    }

    /**
     * Returns for given object and column number the appropriate value from the
     * object for the specified column.
     * 
     * @param input
     *                the object which contains the information
     * @param column
     *                the number of the column which should display a particular
     *                attribute of the given object.
     * @return particular attribute as a String.
     */
    public String getColumnText(Object input, int column) {
	Lecturer lecturer = (Lecturer) input;
	switch (column) {
	case 0:
	    return "" + lecturer.getId();
	case 1:
	    return lecturer.getSalutation();
	case 2:
	    return lecturer.getTitle();
	case 3:
	    return lecturer.getFirstname();
	case 4:
	    return lecturer.getName();
	case 5:
	    return lecturer.getStreet();
	case 6:
	    return lecturer.getZipCode();
	case 7:
	    return lecturer.getCity();
	case 8:
	    return lecturer.getCountry();
	case 9:
	    return lecturer.getAnnex();
	case 10:
	    return lecturer.getPhone();
	case 11:
	    return lecturer.getMobile();
	case 12:
	    return lecturer.getFax();
	case 13:
	    return lecturer.getEmail();
	case 14:
	    if (lecturer.getBirthday() != null) {
		return Utility.dateOnlyFormatter.format(lecturer.getBirthday());
	    } else
		return null;
	case 15:
	    if (lecturer.getFirstContact() != null)
		return Utility.dateOnlyFormatter.format(lecturer
			.getFirstContact());
	    else
		return null;

	case 16:
	    return lecturer.getShortinfo();
	case 17:
	    return lecturer.getNotices();

	case 18:
	    return lecturer.getBio();
	case 19:
	    if (lecturer.getDailyFee() != null)
		return (Utility.createFloatText(lecturer.getDailyFee()));
	    else
		return null;
	case 20:
	    if (lecturer.getHourlyFee() != null)
		return (Utility.createFloatText(lecturer.getHourlyFee()));
	    else
		return null;

	case 21:
	    if (lecturer.getCreationDate() != null) {
		return Utility.dateAndTimeFormatter.format(lecturer
			.getCreationDate());
	    } else
		return null;

	case 22:
	    if (lecturer.getModificationDate() != null) {
		return Utility.dateAndTimeFormatter.format(lecturer
			.getModificationDate());
	    } else
		return null;
	default:
	    return null;
	}
    }

    // not implemented
    public void addListener(ILabelProviderListener arg0) {
    }

    // not implemented
    public boolean isLabelProperty(Object arg0, String arg1) {
	return false;
    }

    // not implemented
    public void removeListener(ILabelProviderListener arg0) {
    }
}
