package semorg.gui.provider;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import semorg.gui.util.Messages;
import semorg.sql.util.Utility;

/**
 * Provides a very simple dialog to edit enumeration constants.
 */
public class EnumDlg extends Dialog {

    /**
     * <tt>true</tt> if the user inserts a new enumeration otherwise it is set
     * to <tt>false</tt>, i.e. the user changes an existing enumeration.
     */
    private boolean newDialog;

    /** The text field to enter the new values. */
    private Text editor;

    /** The new value of the enumeration. */
    private String newValue;

    /** The old value of the enumeration. */
    private String oldValue;

    /**
     * Creates a new enumeration dialog to edit the value of a enumeration.
     * 
     * @param parent
     *                the parent shell.
     * @param value
     *                the old value of the enumeration (= initial value of the
     *                text field {@link #editor}).
     */
    public EnumDlg(Shell parent, String value) {
	super(parent);
	this.newDialog = (value == null);
	this.oldValue = value;

    }

    /**
     * Creates the buttons for the button bar of this dialog.
     * 
     * @param parent
     *                the parent composite which contains the buttons
     */
    protected void createButtonsForButtonBar(Composite parent) {
	createButton(parent, IDialogConstants.OK_ID, Messages
		.getString("GUIText.OkButtonText"), true);
	createButton(parent, IDialogConstants.CANCEL_ID, Messages
		.getString("GUIText.AbortButtonText"), false);
    }

    /**
     * Assigns methods to the buttons, which will be executed when the
     * appropriate button was pressed.
     * 
     * @param buttonId
     *                the id of the button pressed.
     */
    protected void buttonPressed(int buttonId) {
	newValue = editor.getText();
	switch (buttonId) {
	case IDialogConstants.OK_ID:
	    okPressed();
	    break;
	case IDialogConstants.CANCEL_ID:
	    cancelPressed();
	    break;
	}
    }

    /** Sets the return code to the ok button id and closes the dialog. */
    protected void okPressed() {
	setReturnCode(IDialogConstants.OK_ID);
	close();
    }

    /** Sets the return code to the cancel button id and closes the dialog. */
    protected void cancelPressed() {
	setReturnCode(IDialogConstants.CANCEL_ID);
	close();
    }

    /**
     * Creates the dialog area including the text field to enter new values or
     * change existing one.
     * 
     * @param parent
     *                the composite which contains the dialog.
     * 
     * @return the created dialog area as a {@link Composite}.
     */
    protected Control createDialogArea(Composite parent) {
	Composite comp = new Composite(parent, SWT.NULL);
	comp.setLayoutData(new GridData(GridData.FILL_BOTH));
	GridLayout mainGridLayout = new GridLayout(1, false);
	comp.setLayout(mainGridLayout);
	Group group = new Group(comp, SWT.NULL);
	group.setLayoutData(new GridData(GridData.FILL_BOTH));
	group.setLayout(new GridLayout(2, false));

	Label label = new Label(group, SWT.NULL);
	label.setText(Messages.getString("GUIText.EnumerationEditWindowText"));

	editor = new Text(group, SWT.BORDER);
	if (!newDialog)
	    editor.setText(oldValue);

	Utility.setLength(editor, 13);

	applyDialogFont(comp);

	return comp;
    }

    /**
     * Gets the new value of enumeration type.
     * 
     * @return the new value
     */
    public String getNewValue() {
	return newValue;
    }

    /**
     * Simply configures the given shell by setting the size and the title e.g..
     * 
     * @param shell
     *                the shell to configure.
     */
    protected void configureShell(Shell shell) {
	super.configureShell(shell);
	shell.setSize(240, 130);
	shell
		.setText(newDialog ? Messages
			.getString("GUIText.EnumerationEditWindowNewItemText")
			: Messages
				.getString("GUIText.EnumerationEditWindowChangeItemText"));
    }

}
