package semorg.gui.provider;

import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

import semorg.gui.util.DelayedPaymentItem;
import semorg.gui.util.DelayedPaymentViewerControl;
import semorg.sql.util.Utility;

/**
 * This class provides the data of the items in the GUI table in the
 * {@link DelayedPaymentViewerControl}.
 */
public class DelayedPaymentItemTableProvider implements ITableLabelProvider {
    // not implemented
    public Image getColumnImage(Object element, int columnIndex) {
	return null;
    }

    /**
     * Returns for given object and column number the appropriate value from the
     * object for the specified column.
     * 
     * @param element
     *                the object which contains the information
     * @param columnIndex
     *                the number of the column which should display a particular
     *                attribute of the given object.
     * @return particular attribute as a String.
     */
    public String getColumnText(Object element, int columnIndex) {
	DelayedPaymentItem delayedPayment = (DelayedPaymentItem) element;

	switch (columnIndex) {
	case 0:
	    return "" + delayedPayment.getPresentationId();
	case 1:
	    return (delayedPayment.getBilled() != null) ? Utility.dateOnlyFormatter
		    .format(delayedPayment.getBilled())
		    : null;
	case 2:
	    if (delayedPayment.getDebt() != null) {
		return Utility.createFloatText(delayedPayment.getDebt());
	    } else {
		return null;
	    }
	}
	return null;
    }

    // not implemented
    public void addListener(ILabelProviderListener listener) {
    }

    // not implemented
    public void dispose() {
    }

    // not implemented
    public boolean isLabelProperty(Object element, String property) {
	return false;
    }

    // not implemented
    public void removeListener(ILabelProviderListener listener) {
    }

}
