package semorg.gui.provider;

import semorg.gui.list.CompanyInternalPresentationListWindow;
import semorg.sql.tables.CompanyInternalPresentation;
import semorg.sql.util.Utility;

/**
 * This class provides the data of the items in the GUI table in the
 * {@link CompanyInternalPresentationListWindow}.
 */
public class CompanyInternalPresentationTableProvider extends
	PresentationTableProvider {

    /**
     * Returns for given object and column number the appropriate value from the
     * object for the specified column.
     * 
     * @param input
     *                the object which contains the information
     * @param column
     *                the number of the column which should display a particular
     *                attribute of the given object.
     * @return particular attribute as a String.
     */
    public String getColumnText(Object input, int column) {
	CompanyInternalPresentation presentation = (CompanyInternalPresentation) input;
	switch (column) {
	case 16:
	    if (presentation.getPackagePrice() != null)
		return Utility.createFloatText(presentation.getPackagePrice());
	    else
		return null;
	case 17:
	    if (presentation.getMaxEntrants() != null)
		return presentation.getMaxEntrants().toString();
	    else
		return null;

	default:
	    if (column < 16)
		return super.getColumnText(input, column);
	    else
		return super.getColumnText(input, column - 2);
	}
    }
}
