package semorg.gui.provider;

import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

import semorg.gui.list.AssociateListWindow;
import semorg.gui.list.CompanyBookingListWindow;
import semorg.sql.tables.CompanyBooking;
import semorg.sql.util.Utility;

/**
 * This class provides the data of the items in the GUI table in the
 * {@link CompanyBookingListWindow}.
 */
public class CompanyBookingTableProvider implements ITableLabelProvider {
    // not implemented
    public void dispose() {
    }

    // not implemented
    public Image getColumnImage(Object arg0, int arg1) {
	return null;
    }

    /**
     * Returns for given object and column number the appropriate value from the
     * object for the specified column.
     * 
     * @param input
     *                the object which contains the information
     * @param column
     *                the number of the column which should display a particular
     *                attribute of the given object.
     * @return particular attribute as a String.
     */
    public String getColumnText(Object input, int column) {
	CompanyBooking booking = (CompanyBooking) input;
	switch (column) {
	case 0:
	    return new Integer(booking.getId()).toString();
	case 1:
	    if (booking.getEnrolled() != null)
		return Utility.dateOnlyFormatter.format(booking.getEnrolled());
	    else
		return null;
	case 2:
	    if (booking.getConfirmed() != null)
		return Utility.dateOnlyFormatter.format(booking.getConfirmed());
	    else
		return null;
	case 3:
	    if (booking.getBilled() != null)
		return Utility.dateOnlyFormatter.format(booking.getBilled());
	    else
		return null;
	case 4:
	    if (booking.getSignedOff() != null)
		return Utility.dateOnlyFormatter.format(booking.getSignedOff());
	    else
		return null;
	case 5:
	    if (booking.getMessaged() != null)
		return Utility.dateOnlyFormatter.format(booking.getMessaged());
	    else
		return null;
	case 6:
	    return new Integer(booking.getPresentationId()).toString();
	case 7:
	    return new Integer(booking.getCompanyId()).toString();
	case 8:
	    if (booking.getCreationDate() != null) {
		return Utility.dateAndTimeFormatter.format(booking
			.getCreationDate());
	    } else
		return null;

	case 9:
	    if (booking.getModificationDate() != null) {
		return Utility.dateAndTimeFormatter.format(booking
			.getModificationDate());
	    } else
		return null;
	default:
	    return null;
	}
    }

    // not implemented
    public void addListener(ILabelProviderListener arg0) {
    }

    // not implemented
    public boolean isLabelProperty(Object arg0, String arg1) {
	return false;
    }

    // not implemented
    public void removeListener(ILabelProviderListener arg0) {
    }
}
