package semorg.gui.provider;

import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

import semorg.gui.list.AssociateListWindow;
import semorg.gui.list.ClientListWindow;
import semorg.sql.tables.Client;
import semorg.sql.util.Utility;

/**
 * This class provides the data of the items in the GUI table in the
 * {@link ClientListWindow}.
 */
public class ClientTableProvider implements ITableLabelProvider {
    // not implemented
    public void dispose() {
    }

    // not implemented
    public Image getColumnImage(Object arg0, int arg1) {
	return null;
    }

    /**
     * Returns for given object and column number the appropriate value from the
     * object for the specified column.
     * 
     * @param input
     *                the object which contains the information
     * @param column
     *                the number of the column which should display a particular
     *                attribute of the given object.
     * @return particular attribute as a String.
     */
    public String getColumnText(Object input, int column) {
	Client client = (Client) input;
	switch (column) {
	case 0:
	    return "" + client.getId();
	case 1:
	    return client.getSalutation();
	case 2:
	    return client.getTitle();
	case 3:
	    return client.getFirstname();
	case 4:
	    return client.getName();
	case 5:
	    return client.getStreet();
	case 6:
	    return client.getZipCode();
	case 7:
	    return client.getCity();
	case 8:
	    return client.getCountry();
	case 9:
	    return client.getAnnex();
	case 10:
	    return client.getPhone();
	case 11:
	    return client.getMobile();
	case 12:
	    return client.getFax();
	case 13:
	    return client.getEmail();
	case 14:
	    if (client.getBirthday() != null) {
		return Utility.dateOnlyFormatter.format(client.getBirthday());
	    } else
		return null;
	case 15:
	    if (client.getFirstContact() != null)
		return Utility.dateOnlyFormatter.format(client
			.getFirstContact());
	    else
		return null;

	case 16:
	    return client.getShortinfo();
	case 17:
	    return client.getNotices();

	case 18:
	    return client.getTask();
	case 19:
	    if (client.getTurnover() != null)
		return Utility.createFloatText(client.getTurnover());
	    else
		return "";

	case 20:
	    return client.getEmployerDescription();

	case 21:
	    if (client.getCreationDate() != null) {
		return Utility.dateAndTimeFormatter.format(client
			.getCreationDate());
	    } else
		return null;

	case 22:
	    if (client.getModificationDate() != null) {
		return Utility.dateAndTimeFormatter.format(client
			.getModificationDate());
	    } else
		return null;
	default:
	    return null;
	}
    }

    // not implemented
    public void addListener(ILabelProviderListener arg0) {
    }

    // not implemented
    public boolean isLabelProperty(Object arg0, String arg1) {
	return false;
    }

    // not implemented
    public void removeListener(ILabelProviderListener arg0) {
    }
}
