package semorg.gui.provider;

import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

import semorg.gui.list.AssociateListWindow;
import semorg.gui.util.Messages;
import semorg.sql.tables.Associate;
import semorg.sql.util.Utility;

/**
 * This class provides the data of the items in the GUI table in the
 * {@link AssociateListWindow}.
 */
public class AssociateTableProvider implements ITableLabelProvider {

    //not implemented
    public void dispose() {
    }
    
    //not implemented
    public Image getColumnImage(Object arg0, int arg1) {
	return null;
    }

    /**
     * Returns for given object and column number the appropriate value from the
     * object for the specified column.
     * 
     * @param input
     *                the object which contains the information
     * @param column
     *                the number of the column which should display a particular
     *                attribute of the given object.
     * @return particular attribute as a String.
     */
    public String getColumnText(Object input, int column) {
	Associate associate = (Associate) input;
	switch (column) {
	case 0:
	    return "" + associate.getId();
	case 1:
	    return associate.getSalutation();
	case 2:
	    return associate.getTitle();
	case 3:
	    return associate.getFirstname();
	case 4:
	    return associate.getName();
	case 5:
	    return associate.getStreet();
	case 6:
	    return associate.getZipCode();
	case 7:
	    return associate.getCity();
	case 8:
	    return associate.getCountry();
	case 9:
	    return associate.getAnnex();
	case 10:
	    return associate.getPhone();
	case 11:
	    return associate.getMobile();
	case 12:
	    return associate.getFax();
	case 13:
	    return associate.getEmail();
	case 14:
	    if (associate.getBirthday() != null) {
		return Utility.dateOnlyFormatter
			.format(associate.getBirthday());
	    } else
		return null;
	case 15:
	    if (associate.getFirstContact() != null)
		return Utility.dateOnlyFormatter.format(associate
			.getFirstContact());
	    else
		return null;

	case 16:
	    return associate.getShortinfo();
	case 17:
	    return associate.getNotices();
	case 18:
	    switch (associate.getEntitlement()) {
	    case 1:
		return Messages
			.getString("ProviderText.AssociateEntitlementSeminarAdministratorText");
	    case 2:
		return Messages
			.getString("ProviderText.AssociateEntitlementCustomerAdministratorText");
	    case 3:
		return Messages
			.getString("ProviderText.AssociateEntitlementPresentatioOrganizerText");
	    case 4:
		return Messages
			.getString("ProviderText.AssociateEntitlementAdministratorText");
	    default:
		return null;
	    }
	case 19:
	    return associate.getPassword();
	case 20:
	    return associate.getOccupation();
	case 21:
	    if (associate.getCreationDate() != null) {
		return Utility.dateAndTimeFormatter.format(associate
			.getCreationDate());
	    } else
		return null;

	case 22:
	    if (associate.getModificationDate() != null) {
		return Utility.dateAndTimeFormatter.format(associate
			.getModificationDate());
	    } else
		return null;
	default:
	    return null;
	}
    }

    //not implemented
    public void addListener(ILabelProviderListener arg0) {
    }

    //not implemented
    public boolean isLabelProperty(Object arg0, String arg1) {
	return false;
    }

    //not implemented
    public void removeListener(ILabelProviderListener arg0) {
    }
}
