package semorg.gui;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;

import semorg.gui.util.Messages;

/** This class provides a window for selecting the language of the application. */
public class SelectLanguageWindow {

    /** The shell. */
    private Shell shell;

    private Shell parent;

    /** The combo field of this window allowing to change the language. */
    private Combo selectLangCombo;

    /** The ok button to confirm the changes made to the language settings. */
    private Button okButton;

    /** The abort button to discard the changes made to the language settings. */
    private Button abortButton;

    /**
     * Creates an instance of the class using the given arguments.
     * 
     * @param parent
     *                the parent shell of this window.
     */
    public SelectLanguageWindow(Shell parent) {
	this.parent = parent;
	this.shell = new Shell(parent, SWT.TITLE | SWT.CLOSE
		| SWT.PRIMARY_MODAL);
	shell.setSize(200, 180);
	shell.setText(Messages
		.getString("GUIText.SelectLanguageComboTitleText"));
	shell.setLayout(new GridLayout(1, false));

	GridData mainFormData = new GridData();
	mainFormData.horizontalAlignment = GridData.CENTER;
	mainFormData.verticalAlignment = GridData.CENTER;
	mainFormData.grabExcessHorizontalSpace = true;
	mainFormData.grabExcessVerticalSpace = true;
	mainFormData.widthHint = 150;

	Group mainForm = new Group(shell, SWT.NULL);
	mainForm.setLayoutData(mainFormData);
	mainForm.setLayout(new GridLayout(1, false));
	mainForm.setText(Messages
		.getString("GUIText.SelectLanguageWindowTitleText"));

	GridData selectLangComboData = new GridData();
	selectLangComboData.horizontalAlignment = GridData.CENTER;
	selectLangComboData.grabExcessHorizontalSpace = true;
	selectLangComboData.grabExcessVerticalSpace = true;
	selectLangComboData.widthHint = 150;
	selectLangComboData.verticalIndent = 10;

	selectLangCombo = new Combo(mainForm, SWT.SIMPLE);
	selectLangCombo
		.setItems(new String[] {
			Messages
				.getString("GUIText.SelectLanguageComboItemGermanText"),
			Messages
				.getString("GUIText.SelectLanguageComboItemEnglishText") });
	selectLangCombo.select(getCurrentLanguage());
	selectLangCombo.setToolTipText(Messages
		.getString("GUIText.SelectLanguageComboToolTip"));
	selectLangCombo.setLayout(new GridLayout(1, false));
	selectLangCombo.setLayoutData(selectLangComboData);

	Composite buttons = new Composite(shell, shell.getStyle());
	buttons.setLayout(new GridLayout(2, false));
	GridData buttonsData = new GridData();
	buttonsData.horizontalAlignment = GridData.CENTER;
	buttonsData.verticalAlignment = GridData.END;
	buttonsData.grabExcessHorizontalSpace = true;
	buttonsData.grabExcessVerticalSpace = true;
	buttons.setLayoutData(buttonsData);

	okButton = new Button(buttons, SWT.PUSH);
	okButton.setText(Messages.getString("GUIText.OkButtonText"));
	okButton.setLayoutData(new GridData(GridData.CENTER));
	okButton.addSelectionListener(new SelectionAdapter() {
	    public void widgetSelected(SelectionEvent event) {
		String lang = selectLangCombo.getText();
		if (lang
			.equals(Messages
				.getString("GUIText.SelectLanguageComboItemGermanText"))) {
		    MainWindow.getInstance().getConfiguration().setProperty(
			    "language", "de");
		    MainWindow.getInstance().getConfiguration().setProperty(
			    "background", "back_de.png");
		} else if (lang
			.equals(Messages
				.getString("GUIText.SelectLanguageComboItemEnglishText"))) {
		    MainWindow.getInstance().getConfiguration().setProperty(
			    "language", "en");
		    MainWindow.getInstance().getConfiguration().setProperty(
			    "background", "back_en.png");
		}

		MessageDialog dlg = new MessageDialog(
			MainWindow.getInstance().getShell(),
			Messages
				.getString("GUIText.LanguageChangedMessageDialogWindowTitle"),
			null,
			Messages
				.getString("GUIText.LanguageChangedMessageDialogHintText"),
			MessageDialog.QUESTION, new String[] { Messages
				.getString("GUIText.OkButtonText") }, 0);
		dlg.open();
		shell.close();
		AppStarter.main(null);
		SelectLanguageWindow.this.parent.close();
	    }
	});

	abortButton = new Button(buttons, SWT.PUSH);
	abortButton.setText(Messages.getString("GUIText.AbortButtonText"));
	abortButton.addSelectionListener(new SelectionAdapter() {
	    public void widgetSelected(SelectionEvent event) {
		shell.close();
	    }
	});

	shell.open();
    }

    /** Retrieves the actual language and returns its name as a String. */
    private int getCurrentLanguage() {
	if (MainWindow.getInstance().getConfiguration().getProperty("language")
		.equals("en")) {
	    return 1;
	}
	if (MainWindow.getInstance().getConfiguration().getProperty("language")
		.equals("de")) {
	    return 0;
	}
	return -1; // config error occurred
    }
}
