/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import org.eclipse.swt.internal.image.PngDecodingDataStream;

public class PngHuffmanTable {
    CodeLengthInfo[] codeLengthInfo;
    int[] codeValues;
    static final int MAX_CODE_LENGTH = 15;
    static final int BAD_CODE = 0xFFFFFFF;

    PngHuffmanTable(int[] lengths) {
        this.initialize(lengths);
        this.generateTable(lengths);
    }

    private void initialize(int[] lengths) {
        this.codeValues = new int[lengths.length];
        int i = 0;
        while (i < this.codeValues.length) {
            this.codeValues[i] = i;
            ++i;
        }
        this.codeLengthInfo = new CodeLengthInfo[15];
        i = 0;
        while (i < 15) {
            this.codeLengthInfo[i] = new CodeLengthInfo();
            this.codeLengthInfo[i].length = i;
            this.codeLengthInfo[i].baseIndex = 0;
            this.codeLengthInfo[i].min = 0xFFFFFFF;
            this.codeLengthInfo[i].max = -1;
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void generateTable(int[] lengths) {
        i = 0;
        while (i < lengths.length - 1) {
            j = i + 1;
            while (j < lengths.length) {
                if (lengths[j] < lengths[i] || lengths[j] == lengths[i] && this.codeValues[j] < this.codeValues[i]) {
                    tmp = lengths[j];
                    lengths[j] = lengths[i];
                    lengths[i] = tmp;
                    tmp = this.codeValues[j];
                    this.codeValues[j] = this.codeValues[i];
                    this.codeValues[i] = tmp;
                }
                ++j;
            }
            ++i;
        }
        codes = new int[lengths.length];
        lastLength = 0;
        code = 0;
        i = 0;
        ** GOTO lbl28
        {
            ++lastLength;
            code <<= 1;
            do {
                if (lastLength != lengths[i]) continue block2;
                if (lastLength != 0) {
                    codes[i] = code++;
                }
                ++i;
lbl28:
                // 2 sources

            } while (i < lengths.length);
        }
        last = 0;
        i = 0;
        while (i < lengths.length) {
            if (last != lengths[i]) {
                last = lengths[i];
                this.codeLengthInfo[last - 1].baseIndex = i;
                this.codeLengthInfo[last - 1].min = codes[i];
            }
            if (last != 0) {
                this.codeLengthInfo[last - 1].max = codes[i];
            }
            ++i;
        }
    }

    int getNextValue(PngDecodingDataStream stream) {
        int code = stream.getNextIdatBit();
        int codelength = 0;
        while (codelength < 15 && code > this.codeLengthInfo[codelength].max) {
            code = code << 1 | stream.getNextIdatBit();
            ++codelength;
        }
        if (codelength >= 15) {
            stream.error();
        }
        int offset = code - this.codeLengthInfo[codelength].min;
        int index = this.codeLengthInfo[codelength].baseIndex + offset;
        return this.codeValues[index];
    }

    class CodeLengthInfo {
        int length;
        int max;
        int min;
        int baseIndex;

        CodeLengthInfo() {
        }
    }
}

