/*
 * Decompiled with CFR 0.152.
 */
package semorg.sql.util;

import java.io.InputStream;
import java.lang.reflect.Array;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class Utility {
    public static final String ATOSJ_COMPONENT_NAME_KEY = "ATOSJ_COMPONENT_NAME_KEY";
    private static ImageRegistry imgReg;
    public static final Color LIGHT_YELLOW;
    public static final Color LIGHT_RED;
    public static final DateFormat dateOnlyFormatter;
    public static final DateFormat dateAndTimeFormatter;
    public static final DateFormat timeOnlyFormatter;
    private static NumberFormat floatParser;
    public static FocusListener checkEmptyListener;
    public static FocusListener checkCorrectIntListener;
    public static FocusListener checkCorrectFloatListener;

    static {
        LIGHT_YELLOW = new Color((Device)Display.getDefault(), 255, 255, 153);
        LIGHT_RED = new Color((Device)Display.getDefault(), 255, 192, 192);
        dateOnlyFormatter = DateFormat.getDateInstance();
        dateAndTimeFormatter = DateFormat.getDateTimeInstance();
        timeOnlyFormatter = new SimpleDateFormat("HH:mm");
        floatParser = NumberFormat.getNumberInstance();
        checkEmptyListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (e.getSource() instanceof Text) {
                    Text t = (Text)e.getSource();
                    t.setBackground(LIGHT_YELLOW);
                } else if (e.getSource() instanceof Combo) {
                    Combo c = (Combo)e.getSource();
                    c.setBackground(LIGHT_YELLOW);
                }
            }

            public void focusLost(FocusEvent e) {
                Combo c;
                if (e.getSource() instanceof Text) {
                    Text t = (Text)e.getSource();
                    if (t.getText().trim().length() == 0) {
                        t.setBackground(LIGHT_RED);
                    }
                } else if (e.getSource() instanceof Combo && (c = (Combo)e.getSource()).getText().trim().length() == 0) {
                    c.setBackground(LIGHT_RED);
                }
            }
        };
        checkCorrectIntListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (e.getSource() instanceof Text) {
                    Text t = (Text)e.getSource();
                    t.setBackground(Display.getDefault().getSystemColor(1));
                }
            }

            public void focusLost(FocusEvent e) {
                Text t;
                String text;
                if (e.getSource() instanceof Text && !Utility.isCorrectInteger(text = (t = (Text)e.getSource()).getText())) {
                    t.setBackground(LIGHT_RED);
                }
            }
        };
        checkCorrectFloatListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (e.getSource() instanceof Text) {
                    Text t = (Text)e.getSource();
                    t.setBackground(Display.getDefault().getSystemColor(1));
                }
            }

            public void focusLost(FocusEvent e) {
                Text t;
                String text;
                if (e.getSource() instanceof Text && !Utility.isCorrectFloat(text = (t = (Text)e.getSource()).getText())) {
                    t.setBackground(LIGHT_RED);
                }
            }
        };
    }

    public static FormData getFormData(Object topPercentage, int topOffset, Object bottomPercentage, int bottomOffset, Object leftPercentage, int leftOffset, Object rightPercentage, int rightOffset) {
        FormData fm = new FormData();
        if (topPercentage instanceof Control) {
            fm.top = new FormAttachment((Control)topPercentage, topOffset);
        } else if (topPercentage instanceof Integer && Utility.isvalidPercentage((Integer)topPercentage)) {
            fm.top = new FormAttachment(((Integer)topPercentage).intValue(), topOffset);
        }
        if (bottomPercentage instanceof Control) {
            fm.bottom = new FormAttachment((Control)bottomPercentage, bottomOffset);
        } else if (bottomPercentage instanceof Integer && Utility.isvalidPercentage((Integer)bottomPercentage)) {
            fm.bottom = new FormAttachment(((Integer)bottomPercentage).intValue(), bottomOffset);
        }
        if (leftPercentage instanceof Control) {
            fm.left = new FormAttachment((Control)leftPercentage, leftOffset);
        } else if (leftPercentage instanceof Integer && Utility.isvalidPercentage((Integer)leftPercentage)) {
            fm.left = new FormAttachment(((Integer)leftPercentage).intValue(), leftOffset);
        }
        if (rightPercentage instanceof Control) {
            fm.right = new FormAttachment((Control)rightPercentage, rightOffset);
        } else if (rightPercentage instanceof Integer && Utility.isvalidPercentage((Integer)rightPercentage)) {
            fm.right = new FormAttachment(((Integer)rightPercentage).intValue(), rightOffset);
        }
        return fm;
    }

    private static boolean isvalidPercentage(int val) {
        return val >= 0 && val <= 100;
    }

    public static Text createTextTab(TabFolder parent, String name, Font font, int limit) {
        TabItem textTab = new TabItem(parent, 0);
        textTab.setText(name);
        Composite tabContent = new Composite((Composite)parent, 0);
        textTab.setControl((Control)tabContent);
        tabContent.setLayout((Layout)new FormLayout());
        Label header = new Label(tabContent, 8);
        header.setText(name);
        header.setLayoutData((Object)Utility.getFormData(14, 0, null, 0, 0, 9, null, 0));
        Text text = new Text(tabContent, 2626);
        text.setTextLimit(limit);
        text.setLayoutData((Object)Utility.getFormData(0, 39, 100, -16, 0, 9, 100, -10));
        if (font != null) {
            header.setFont(font);
            text.setFont(font);
        }
        return text;
    }

    public static Date convertToSQLDate(java.util.Date date) {
        return new Date(date.getTime());
    }

    public static Timestamp convertToTimestamp(java.util.Date date) {
        return new Timestamp(date.getTime());
    }

    public static void setLength(Text comp, int size) {
        Object ld = comp.getLayoutData();
        GridData gd = ld != null && ld instanceof GridData ? (GridData)ld : new GridData();
        comp.setTextLimit(size);
        gd.widthHint = 6 * size;
        comp.setLayoutData((Object)gd);
    }

    public static void setLength(Text comp, int textLength, int lettersShown) {
        Object ld = comp.getLayoutData();
        GridData gd = ld != null && ld instanceof GridData ? (GridData)ld : new GridData();
        comp.setTextLimit(textLength);
        gd.widthHint = 6 * lettersShown;
        comp.setLayoutData((Object)gd);
    }

    public static void setLength(Combo comp, int size) {
        Object ld = comp.getLayoutData();
        GridData gd = ld != null && ld instanceof GridData ? (GridData)ld : new GridData();
        comp.setTextLimit(size);
        gd.widthHint = 6 * size;
        comp.setLayoutData((Object)gd);
    }

    public static void alignRight(Control label) {
        Object ld = label.getLayoutData();
        GridData gd = ld != null && ld instanceof GridData ? (GridData)ld : new GridData();
        gd.horizontalAlignment = 3;
        label.setLayoutData((Object)gd);
    }

    private static void initImage(String name) {
        InputStream stream = Utility.class.getClassLoader().getResourceAsStream("semorg/gui/icon/" + name);
        imgReg.put(name, new Image((Device)Display.getDefault(), stream));
    }

    public static Image getImage(String name) {
        Image img;
        if (imgReg == null) {
            imgReg = new ImageRegistry(Display.getDefault());
        }
        if ((img = imgReg.get(name)) == null) {
            Utility.initImage(name);
            return imgReg.get(name);
        }
        return img;
    }

    public static void disposeImages() {
        imgReg.dispose();
    }

    public static Float parseFloat(String floatString) {
        if (floatString == null || floatString.trim().length() == 0) {
            return null;
        }
        try {
            return new Float(floatParser.parse(floatString).floatValue());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isCorrectFloat(String floatString) {
        if (floatString == null || floatString.trim().length() == 0) {
            return true;
        }
        floatString = floatString.trim();
        ParsePosition pp = new ParsePosition(0);
        floatParser.parse(floatString, pp);
        return pp.getIndex() == floatString.length();
    }

    public static Integer parseInteger(String integerString) {
        if (integerString == null || integerString.trim().length() == 0) {
            return null;
        }
        try {
            return new Integer(Integer.parseInt(integerString));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isCorrectInteger(String integerString) {
        if (integerString == null || integerString.trim().length() == 0) {
            return true;
        }
        try {
            Integer.parseInt(integerString);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String createFloatText(Float theFloat) {
        if (theFloat == null) {
            return "";
        }
        return floatParser.format(theFloat);
    }

    public static void initUtilities() {
        floatParser.setMaximumFractionDigits(2);
        floatParser.setMinimumFractionDigits(2);
        floatParser.setGroupingUsed(false);
    }

    public static Object[] castArray(Object[] array, Class clazz) {
        Object[] returnArray = (Object[])Array.newInstance(clazz, array.length);
        int i = 0;
        while (i < array.length) {
            returnArray[i] = array[i];
            ++i;
        }
        return returnArray;
    }
}

