/*
 * Decompiled with CFR 0.152.
 */
package semorg.sql.tables;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import semorg.gui.util.Messages;
import semorg.sql.access.DBAccess;
import semorg.sql.tables.AbstractTable;
import semorg.sql.tables.SimpleIDKey;
import semorg.sql.util.DBColumn;
import semorg.sql.util.DBConstraint;
import semorg.sql.util.DistinctVector;
import semorg.sql.util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeminarType
extends AbstractTable
implements SimpleIDKey {
    public static List<Integer> lockedIds = new ArrayList<Integer>();
    protected int id;
    protected String shortTitle;
    protected String title;
    protected String objective;
    protected String methodology;
    protected String topic;
    protected String routine;
    protected Integer duration;
    protected String documents;
    protected String audience;
    protected String requirements;
    protected Float charge;
    protected Integer maxEntrants;
    protected Integer minEntrants;
    private static String tableName = "seminartype";
    protected static String seminarTypeInsertString = "INSERT INTO " + tableName + " VALUES(?, ?, ?, ?, ?, " + "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static String createTableSQLString = "CREATE TABLE IF NOT EXISTS `" + tableName + "` (" + "`id_pk` integer NOT NULL auto_increment," + "`shorttitle` varchar(10) NOT NULL," + "`title` varchar(50)," + "`objective` varchar(400)," + "`methodology` varchar(400)," + "`topic` varchar(400)," + "`routine` varchar(200)," + "`duration` integer," + "`documents` varchar(200)," + "`audience` varchar(200)," + "`requirements` varchar(200)," + "`charge` float," + "`maxEntrants` integer," + "`minEntrants` integer," + "`creationdate` timestamp NOT NULL default '0000-00-00 00:00:00'," + "`modificationdate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP," + "PRIMARY KEY  (`id_pk`) )";
    protected static String seminarTypeUpdateString = "UPDATE " + tableName + " SET shorttitle=?, title=?, objective=?, methodology=?, topic=?, " + "routine=?, duration=?, documents=?, audience=?, requirements=?, charge=?, maxEntrants=?, minEntrants=?, " + "modificationdate=? WHERE id_pk=?";
    private static String queryString = "SELECT id_pk, shorttitle, title, objective, methodology, topic, routine, duration, documents, audience, requirements, charge, maxEntrants, minEntrants, creationdate, modificationdate FROM " + tableName + " WHERE true";
    private static String conductQueryString = "SELECT st.id_pk, st.shorttitle, st.title, st.objective, st.methodology, st.topic, st.routine, st.duration, st.documents, st.audience, st.requirements, st.charge, st.maxEntrants, st.minEntrants, st.creationdate, st.modificationdate FROM seminartype st, conduct c WHERE st.id_pk=c.seminartypeid AND c.lecturerid=?";

    public SeminarType(int id, String shortTitle, String title, String objective, String methodology, String topic, String routine, Integer duration, String documents, String audience, String requirements, Float charge, Integer maxEntrants, Integer minEntrants, Timestamp creationDate, Timestamp modificationDate) {
        super(creationDate, modificationDate);
        this.id = id;
        this.shortTitle = shortTitle;
        this.title = title;
        this.objective = objective;
        this.methodology = methodology;
        this.topic = topic;
        this.routine = routine;
        this.duration = duration;
        this.documents = documents;
        this.audience = audience;
        this.requirements = requirements;
        this.charge = charge;
        this.maxEntrants = maxEntrants;
        this.minEntrants = minEntrants;
        this.creationDate = creationDate;
        this.modificationDate = modificationDate;
    }

    public static boolean tableOK() {
        return AbstractTable.tableOK(tableName);
    }

    public static void createSeminarTypeTable(Statement statement) throws SQLException {
        statement.execute(createTableSQLString);
        statement.close();
    }

    public int insertIntoDB() throws SQLException {
        PreparedStatement insertStmt = DBAccess.dbAccess.getPreparedStatement(seminarTypeInsertString);
        insertStmt.setNull(1, 4);
        insertStmt.setString(2, this.shortTitle);
        insertStmt.setString(3, this.title);
        insertStmt.setString(4, this.objective);
        insertStmt.setString(5, this.methodology);
        insertStmt.setString(6, this.topic);
        insertStmt.setString(7, this.routine);
        if (this.duration != null) {
            insertStmt.setInt(8, this.duration);
        } else {
            insertStmt.setNull(8, 4);
        }
        insertStmt.setString(9, this.documents);
        insertStmt.setString(10, this.audience);
        insertStmt.setString(11, this.requirements);
        if (this.charge != null) {
            insertStmt.setFloat(12, this.charge.floatValue());
        } else {
            insertStmt.setNull(12, 6);
        }
        if (this.maxEntrants != null) {
            insertStmt.setInt(13, this.maxEntrants);
        } else {
            insertStmt.setNull(13, 4);
        }
        if (this.minEntrants != null) {
            insertStmt.setInt(14, this.minEntrants);
        } else {
            insertStmt.setNull(14, 4);
        }
        insertStmt.setTimestamp(15, Utility.convertToTimestamp(this.creationDate));
        insertStmt.setTimestamp(16, Utility.convertToTimestamp(this.modificationDate));
        insertStmt.executeUpdate();
        ResultSet rs = insertStmt.getGeneratedKeys();
        if (!rs.next()) {
            throw new SQLException();
        }
        this.id = rs.getInt(1);
        rs.close();
        insertStmt.close();
        AbstractTable.fireTableChangedEvent(15);
        return this.id;
    }

    public void updateDB() throws SQLException {
        PreparedStatement updateStmt = DBAccess.dbAccess.getPreparedStatement(seminarTypeUpdateString);
        updateStmt.setString(1, this.shortTitle);
        updateStmt.setString(2, this.title);
        updateStmt.setString(3, this.objective);
        updateStmt.setString(4, this.methodology);
        updateStmt.setString(5, this.topic);
        updateStmt.setString(6, this.routine);
        if (this.duration != null) {
            updateStmt.setInt(7, this.duration);
        } else {
            updateStmt.setNull(7, 4);
        }
        updateStmt.setString(8, this.documents);
        updateStmt.setString(9, this.audience);
        updateStmt.setString(10, this.requirements);
        if (this.charge != null) {
            updateStmt.setFloat(11, this.charge.floatValue());
        } else {
            updateStmt.setNull(11, 6);
        }
        if (this.maxEntrants != null) {
            updateStmt.setInt(12, this.maxEntrants);
        } else {
            updateStmt.setNull(12, 4);
        }
        if (this.minEntrants != null) {
            updateStmt.setInt(13, this.minEntrants);
        } else {
            updateStmt.setNull(13, 4);
        }
        updateStmt.setTimestamp(14, new Timestamp(System.currentTimeMillis()));
        updateStmt.setInt(15, this.id);
        updateStmt.executeUpdate();
        updateStmt.close();
        AbstractTable.fireTableChangedEvent(15);
    }

    public static void removeFromDB(Iterable selectedElements) throws SQLException {
        String deleteString = "DELETE FROM " + tableName + " WHERE ";
        Iterator it = selectedElements.iterator();
        int idToDelete = ((SeminarType)it.next()).getId();
        deleteString = String.valueOf(deleteString) + "id_pk=" + idToDelete + " ";
        while (it.hasNext()) {
            idToDelete = ((SeminarType)it.next()).getId();
            deleteString = String.valueOf(deleteString) + "OR id_pk=" + idToDelete + " ";
        }
        Statement stmt = DBAccess.dbAccess.getStatement();
        stmt.executeUpdate(deleteString);
        stmt.close();
        AbstractTable.fireTableChangedEvent(15);
        AbstractTable.fireTableChangedEvent(13);
        AbstractTable.fireTableChangedEvent(14);
        AbstractTable.fireTableChangedEvent(7);
        AbstractTable.fireTableChangedEvent(2);
        AbstractTable.fireTableChangedEvent(6);
        AbstractTable.fireTableChangedEvent(4);
    }

    private static DistinctVector<SeminarType> getVector(ResultSet resultSet) {
        DistinctVector<SeminarType> set = new DistinctVector<SeminarType>();
        try {
            while (resultSet.next()) {
                int id = resultSet.getInt("id_pk");
                String shortTitle = resultSet.getString("shorttitle");
                String title = resultSet.getString("title");
                String objective = resultSet.getString("objective");
                String methodology = resultSet.getString("methodology");
                String topic = resultSet.getString("topic");
                String routine = resultSet.getString("routine");
                Integer duration = resultSet.getInt("duration");
                if (resultSet.wasNull()) {
                    duration = null;
                }
                String documents = resultSet.getString("documents");
                String audience = resultSet.getString("audience");
                String requirements = resultSet.getString("requirements");
                Float charge = Float.valueOf(resultSet.getFloat("charge"));
                if (resultSet.wasNull()) {
                    charge = null;
                }
                Integer maxEntrants = resultSet.getInt("maxEntrants");
                if (resultSet.wasNull()) {
                    maxEntrants = null;
                }
                Integer minEntrants = resultSet.getInt("minEntrants");
                if (resultSet.wasNull()) {
                    minEntrants = null;
                }
                Timestamp creationDate = resultSet.getTimestamp("creationdate");
                Timestamp modificationDate = resultSet.getTimestamp("modificationdate");
                set.add(new SeminarType(id, shortTitle, title, objective, methodology, topic, routine, duration, documents, audience, requirements, charge, maxEntrants, minEntrants, creationDate, modificationDate));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return set;
    }

    public static DistinctVector<SeminarType> getVectorFromDB(Vector<DBConstraint> additionalConstraints, String sortString) throws SQLException {
        PreparedStatement stmt = AbstractTable.createExtendedQueryString(queryString, additionalConstraints, sortString);
        ResultSet rs = stmt.executeQuery();
        DistinctVector<SeminarType> returnValue = SeminarType.getVector(rs);
        rs.close();
        stmt.close();
        return returnValue;
    }

    public static SeminarType getSeminarTypeFromDB(int semTypeId) throws SQLException {
        Vector<DBConstraint> keyConstraint = new Vector<DBConstraint>();
        keyConstraint.add(new DBConstraint(SeminarType.getColumns().get(0).getInternalColumnName(), 0, new Integer(semTypeId), 0));
        DistinctVector<SeminarType> semTypes = SeminarType.getVectorFromDB(keyConstraint, null);
        if (semTypes.size() > 0) {
            return (SeminarType)semTypes.iterator().next();
        }
        return null;
    }

    public static Vector<DBColumn> getColumns() {
        Vector<DBColumn> columns = new Vector<DBColumn>();
        columns.add(new DBColumn("id_pk", Messages.getString("MAP.SeminarType.IdPK"), Integer.class));
        columns.add(new DBColumn("shorttitle", Messages.getString("MAP.SeminarType.ShortTitle"), String.class));
        columns.add(new DBColumn("title", Messages.getString("MAP.SeminarType.Title"), String.class));
        columns.add(new DBColumn("objective", Messages.getString("MAP.SeminarType.Objective"), String.class));
        columns.add(new DBColumn("methodology", Messages.getString("MAP.SeminarType.Methodology"), String.class));
        columns.add(new DBColumn("topic", Messages.getString("MAP.SeminarType.Topic"), String.class));
        columns.add(new DBColumn("routine", Messages.getString("MAP.SeminarType.Routine"), String.class));
        columns.add(new DBColumn("duration", Messages.getString("MAP.SeminarType.Duration"), Integer.class));
        columns.add(new DBColumn("documents", Messages.getString("MAP.SeminarType.Documents"), String.class));
        columns.add(new DBColumn("audience", Messages.getString("MAP.SeminarType.Audience"), String.class));
        columns.add(new DBColumn("requirements", Messages.getString("MAP.SeminarType.Requirements"), String.class));
        columns.add(new DBColumn("charge", Messages.getString("MAP.SeminarType.Charge"), Float.class));
        columns.add(new DBColumn("maxEntrants", Messages.getString("MAP.SeminarType.MaxEntrants"), Integer.class));
        columns.add(new DBColumn("minEntrants", Messages.getString("MAP.SeminarType.MinEntrants"), Integer.class));
        columns.addAll(AbstractTable.getColumns(""));
        return columns;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public Float getCharge() {
        return this.charge;
    }

    public void setCharge(Float charge) {
        this.charge = charge;
    }

    public String getDocuments() {
        return this.documents;
    }

    public void setDocuments(String documents) {
        this.documents = documents;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public Integer getMaxEntrants() {
        return this.maxEntrants;
    }

    public void setMaxEntrants(Integer maxEntrants) {
        this.maxEntrants = maxEntrants;
    }

    public String getMethodology() {
        return this.methodology;
    }

    public void setMethodology(String methodology) {
        this.methodology = methodology;
    }

    public Integer getMinEntrants() {
        return this.minEntrants;
    }

    public void setMinEntrants(Integer minEntrants) {
        this.minEntrants = minEntrants;
    }

    public String getObjective() {
        return this.objective;
    }

    public void setObjective(String objective) {
        this.objective = objective;
    }

    public String getRequirements() {
        return this.requirements;
    }

    public void setRequirements(String requirements) {
        this.requirements = requirements;
    }

    public String getRoutine() {
        return this.routine;
    }

    public void setRoutine(String routine) {
        this.routine = routine;
    }

    public String getShortTitle() {
        return this.shortTitle;
    }

    public void setShortTitle(String shortTitle) {
        this.shortTitle = shortTitle;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public static SeminarType getNext(int semTypeId) {
        SeminarType returnValue = null;
        ResultSet rs = AbstractTable.getNext(queryString, SeminarType.getColumns().get(0), semTypeId);
        if (rs != null) {
            returnValue = (SeminarType)SeminarType.getVector(rs).iterator().next();
            try {
                Statement producingStatement = rs.getStatement();
                rs.close();
                if (producingStatement != null) {
                    producingStatement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return returnValue;
    }

    public static SeminarType getPrevious(int semTypeId) {
        SeminarType returnValue = null;
        ResultSet rs = AbstractTable.getPrevious(queryString, SeminarType.getColumns().get(0), semTypeId);
        if (rs != null) {
            returnValue = (SeminarType)SeminarType.getVector(rs).iterator().next();
            try {
                Statement producingStatement = rs.getStatement();
                rs.close();
                if (producingStatement != null) {
                    producingStatement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return returnValue;
    }

    public static DistinctVector<SeminarType> getSemTypeConductedBy(int lecturerId) throws SQLException {
        PreparedStatement stmt = DBAccess.dbAccess.getPreparedStatement(conductQueryString);
        stmt.setInt(1, lecturerId);
        ResultSet rs = stmt.executeQuery();
        DistinctVector<SeminarType> returnValue = SeminarType.getVector(rs);
        rs.close();
        stmt.close();
        return returnValue;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(SeminarType otherSeminarType) {
        return this.id == otherSeminarType.id;
    }

    public boolean equals(Object otherSeminarType) {
        if (otherSeminarType instanceof SeminarType) {
            return this.id == ((SeminarType)otherSeminarType).id;
        }
        return super.equals(otherSeminarType);
    }
}

