/*
 * Decompiled with CFR 0.152.
 */
package semorg.sql.tables;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import semorg.gui.util.Messages;
import semorg.sql.access.DBAccess;
import semorg.sql.tables.AbstractTable;
import semorg.sql.tables.Presentation;
import semorg.sql.util.DBColumn;
import semorg.sql.util.DBConstraint;
import semorg.sql.util.DistinctVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublicPresentation
extends Presentation {
    private String coopPartner;
    private Float cancelFee;
    private String publicPresentationCurrentEntrantsString = "SELECT COUNT(*) FROM clientbooking WHERE presentationid=?";
    private static String tableName = "publicpresentation";
    private static String queryString = "SELECT pr.id_pk, pr.seminartype_fk, pr.duration, pr.beginningday, pr.endingday, pr.startingtime, pr.endingtime, pr.firststartingtime, pr.lastendingtime, pr.location, pr.street, pr.zipcode, pr.city, pr.country, pr.annex, pr.cancelled, ppr.cooppartner, ppr.cancelfee, pr.creationdate, pr.modificationdate FROM presentation pr, seminartype s, " + tableName + " ppr " + "WHERE pr.id_pk=ppr.presentation_fk AND s.id_pk=pr.seminartype_fk";
    private static String publicPresentationInsertString = "INSERT INTO " + tableName + " VALUES(?, ?, ?)";
    private static String publicPresentationUpdateString = "UPDATE " + tableName + " SET cooppartner=?, cancelfee=? WHERE presentation_fk=?";
    private static String createTableSQLString = "CREATE TABLE IF NOT EXISTS `" + tableName + "` (" + "`presentation_fk` integer NOT NULL," + "`cooppartner` varchar(100)," + "`cancelfee` float," + "PRIMARY KEY  (`presentation_fk`)," + "CONSTRAINT `publicpresentation_fk` FOREIGN KEY (`presentation_fk`) REFERENCES `presentation` (`id_pk`) ON DELETE CASCADE)";

    public PublicPresentation(int id, int seminarTypeId, Integer duration, Date beginningDay, Date endingDay, Time startingTime, Time endingTime, Time firstStartingTime, Time lastEndingTime, String location, String street, String zipCode, String city, String country, String annex, boolean cancelled, String coopPartner, Float cancelFee, Timestamp creationDate, Timestamp modificationDate) throws SQLException {
        super(id, seminarTypeId, duration, beginningDay, endingDay, startingTime, endingTime, firstStartingTime, lastEndingTime, location, street, zipCode, city, country, annex, cancelled, creationDate, modificationDate);
        this.coopPartner = coopPartner;
        this.cancelFee = cancelFee;
    }

    private static DistinctVector<PublicPresentation> getVector(ResultSet resultSet) {
        DistinctVector<PublicPresentation> set = new DistinctVector<PublicPresentation>();
        try {
            while (resultSet.next()) {
                int id = resultSet.getInt("id_pk");
                int seminarTypeId = resultSet.getInt("seminartype_fk");
                Integer duration = resultSet.getInt("duration");
                if (resultSet.wasNull()) {
                    duration = null;
                }
                java.sql.Date beginningDay = resultSet.getDate("beginningday");
                java.sql.Date endingDay = resultSet.getDate("endingday");
                Time startingTime = resultSet.getTime("startingtime");
                Time endingTime = resultSet.getTime("endingtime");
                Time firstStartingTime = resultSet.getTime("firststartingtime");
                Time lastEndingTime = resultSet.getTime("lastendingtime");
                String location = resultSet.getString("location");
                String street = resultSet.getString("street");
                String zipCode = resultSet.getString("zipcode");
                String city = resultSet.getString("city");
                String country = resultSet.getString("country");
                String annex = resultSet.getString("annex");
                boolean cancelled = resultSet.getBoolean("cancelled");
                String coopPartner = resultSet.getString("cooppartner");
                Float cancelFee = Float.valueOf(resultSet.getFloat("cancelfee"));
                if (resultSet.wasNull()) {
                    cancelFee = null;
                }
                Timestamp creationDate = resultSet.getTimestamp("creationdate");
                Timestamp modificationDate = resultSet.getTimestamp("modificationdate");
                set.add(new PublicPresentation(id, seminarTypeId, duration, beginningDay, endingDay, startingTime, endingTime, firstStartingTime, lastEndingTime, location, street, zipCode, city, country, annex, cancelled, coopPartner, cancelFee, creationDate, modificationDate));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return set;
    }

    public static DistinctVector<PublicPresentation> getVectorFromDB(Vector<DBConstraint> additionalConstraints, String sortString) throws SQLException {
        PreparedStatement stmt = AbstractTable.createExtendedQueryString(queryString, additionalConstraints, sortString);
        ResultSet rs = stmt.executeQuery();
        DistinctVector<PublicPresentation> returnValue = PublicPresentation.getVector(rs);
        rs.close();
        stmt.close();
        return returnValue;
    }

    public static boolean tableOK() {
        return AbstractTable.tableOK(tableName);
    }

    public static void createPublicPresentationTable(Statement statement) throws SQLException {
        statement.execute(createTableSQLString);
        statement.close();
    }

    @Override
    public int insertIntoDB() throws SQLException {
        super.insertIntoDB();
        PreparedStatement insertStmt = DBAccess.dbAccess.getPreparedStatement(publicPresentationInsertString);
        insertStmt.setInt(1, this.id);
        insertStmt.setString(2, this.coopPartner);
        if (this.cancelFee != null) {
            insertStmt.setFloat(3, this.cancelFee.floatValue());
        } else {
            insertStmt.setNull(3, 6);
        }
        insertStmt.executeUpdate();
        insertStmt.close();
        AbstractTable.fireTableChangedEvent(14);
        return this.id;
    }

    @Override
    public void updateDB() throws SQLException {
        super.updateDB();
        PreparedStatement updateStmt = DBAccess.dbAccess.getPreparedStatement(publicPresentationUpdateString);
        updateStmt.setString(1, this.coopPartner);
        if (this.cancelFee != null) {
            updateStmt.setFloat(2, this.cancelFee.floatValue());
        } else {
            updateStmt.setNull(2, 6);
        }
        updateStmt.setInt(3, this.id);
        updateStmt.executeUpdate();
        updateStmt.close();
        AbstractTable.fireTableChangedEvent(14);
    }

    public static Vector<DBColumn> getColumns() {
        Vector<DBColumn> columns = Presentation.getColumns();
        columns.add(columns.size() - 2, new DBColumn("ppr.cooppartner", Messages.getString("MAP.PublicPresentation.CoopPartner"), String.class));
        columns.add(columns.size() - 2, new DBColumn("ppr.cancelfee", Messages.getString("MAP.PublicPresentation.CancelFee"), Float.class));
        return columns;
    }

    public static Vector<DBColumn> getColumnsWithSemtype() {
        Vector<DBColumn> columns = PublicPresentation.getColumns();
        columns.set(1, new DBColumn("s.shorttitle", Messages.getString("MAP.Presentation.SeminarTypeST"), String.class));
        return columns;
    }

    public String getCoopPartner() {
        return this.coopPartner;
    }

    public void setCoopPartner(String coopPartner) {
        this.coopPartner = coopPartner;
    }

    public Float getCancelFee() {
        return this.cancelFee;
    }

    public void setCancelFee(Float cancelFee) {
        this.cancelFee = cancelFee;
    }

    public static PublicPresentation getNext(int currentId) {
        PublicPresentation returnValue = null;
        ResultSet rs = AbstractTable.getNext(queryString, PublicPresentation.getColumns().get(0), currentId);
        if (rs != null) {
            returnValue = (PublicPresentation)PublicPresentation.getVector(rs).iterator().next();
            try {
                Statement producingStatement = rs.getStatement();
                rs.close();
                if (producingStatement != null) {
                    producingStatement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return returnValue;
    }

    public static PublicPresentation getPrevious(int currentId) {
        PublicPresentation returnValue = null;
        ResultSet rs = AbstractTable.getPrevious(queryString, PublicPresentation.getColumns().get(0), currentId);
        if (rs != null) {
            returnValue = (PublicPresentation)PublicPresentation.getVector(rs).iterator().next();
            try {
                Statement producingStatement = rs.getStatement();
                rs.close();
                if (producingStatement != null) {
                    producingStatement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return returnValue;
    }

    public static PublicPresentation getPublicPresentation(int presentationId) throws SQLException {
        Vector<DBConstraint> keyConstraint = new Vector<DBConstraint>();
        keyConstraint.add(new DBConstraint(PublicPresentation.getColumns().get(0).getInternalColumnName(), 0, new Integer(presentationId), 0));
        DistinctVector<PublicPresentation> presentations = PublicPresentation.getVectorFromDB(keyConstraint, null);
        return (PublicPresentation)presentations.iterator().next();
    }

    public int getCurrentEntrantsCount() throws SQLException {
        PreparedStatement entrantsCountStmt = DBAccess.dbAccess.getPreparedStatement(this.publicPresentationCurrentEntrantsString);
        entrantsCountStmt.setInt(1, this.id);
        ResultSet res = entrantsCountStmt.executeQuery();
        if (res.next()) {
            int val = res.getInt(1);
            res.close();
            entrantsCountStmt.close();
            return val;
        }
        res.close();
        entrantsCountStmt.close();
        throw new SQLException();
    }
}

