/*
 * Decompiled with CFR 0.152.
 */
package semorg.sql.tables;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import semorg.gui.util.Messages;
import semorg.sql.access.DBAccess;
import semorg.sql.tables.AbstractTable;
import semorg.sql.tables.Enumeration;
import semorg.sql.tables.SeminarType;
import semorg.sql.tables.SimpleIDKey;
import semorg.sql.util.DBColumn;
import semorg.sql.util.DBConstraint;
import semorg.sql.util.DistinctVector;
import semorg.sql.util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Presentation
extends AbstractTable
implements SimpleIDKey {
    public static List<Integer> lockedIds = new ArrayList<Integer>();
    protected int id;
    protected int seminarTypeId;
    protected Integer duration;
    protected java.util.Date beginningDay;
    protected java.util.Date endingDay;
    protected Time startingTime;
    protected Time endingTime;
    protected Time firstStartingTime;
    protected Time lastEndingTime;
    protected String location;
    protected String street;
    protected String zipCode;
    protected String city;
    protected String country;
    protected String annex;
    protected boolean cancelled;
    private static String tableName = "presentation";
    private static String superviseQueryString = "SELECT pr.id_pk, pr.seminartype_fk, pr.duration, pr.beginningday, pr.endingday, pr.startingtime, pr.endingtime, pr.firststartingtime, pr.lastendingtime, pr.location, pr.street, pr.zipcode, pr.city, pr.country, pr.annex, pr.cancelled, pr.creationdate, pr.modificationdate FROM presentation pr, supervisor s WHERE pr.id_pk=s.presentationid AND s.lecturerid=?";
    private static String instructQueryString = "SELECT pr.id_pk, pr.seminartype_fk, pr.duration, pr.beginningday, pr.endingday, pr.startingtime, pr.endingtime, pr.firststartingtime, pr.lastendingtime, pr.location, pr.street, pr.zipcode, pr.city, pr.country, pr.annex, pr.cancelled, pr.creationdate, pr.modificationdate FROM presentation pr, instructor i WHERE pr.id_pk=i.presentationid AND i.lecturerid=?";
    private static String presentationQueryString = "SELECT pr.id_pk, pr.seminartype_fk, pr.duration, pr.beginningday, pr.endingday, pr.startingtime, pr.endingtime, pr.firststartingtime, pr.lastendingtime, pr.location, pr.street, pr.zipcode, pr.city, pr.country, pr.annex, pr.cancelled, pr.creationdate, pr.modificationdate FROM presentation pr, seminartype s WHERE pr.seminartype_fk=? AND s.id_pk=pr.seminartype_fk";
    private static String queryString = "SELECT pr.id_pk, pr.seminartype_fk, pr.duration, pr.beginningday, pr.endingday, pr.startingtime, pr.endingtime, pr.firststartingtime, pr.lastendingtime, pr.location, pr.street, pr.zipcode, pr.city, pr.country, pr.annex, pr.cancelled, pr.creationdate, pr.modificationdate FROM presentation pr WHERE true";
    protected static String presentationInsertString = "INSERT INTO " + tableName + " VALUES(?, ?, ?, ?, ?, " + "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static String createTableSQLString = "CREATE TABLE IF NOT EXISTS `" + tableName + "` (" + "`id_pk` integer NOT NULL auto_increment," + "`seminartype_fk` integer NOT NULL," + "`duration` integer," + "`beginningday` date," + "`endingday` date," + "`startingtime` time," + "`endingtime` time," + "`firststartingtime` time," + "`lastendingtime` time," + "`location` varchar(50)," + "`street` varchar(50)," + "`zipcode` varchar(5)," + "`city` varchar(30)," + "`country` varchar(13)," + "`annex` varchar(13)," + "`cancelled` boolean," + "`creationdate` timestamp NOT NULL default '0000-00-00 00:00:00'," + "`modificationdate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP," + "PRIMARY KEY  (`id_pk`)," + "CONSTRAINT `presentation_fk` FOREIGN KEY (`seminartype_fk`) REFERENCES `seminartype` (`id_pk`) ON DELETE CASCADE)";
    protected static String presentationUpdateString = "UPDATE " + tableName + " SET seminartype_fk=?, duration=?, beginningday=?, endingday=?, startingtime=?, endingtime=?, " + "firststartingtime=?, lastendingtime=?, location=?, street=?, zipCode=?, city=?, country=?, annex=?, cancelled=?, " + "modificationdate=? WHERE id_pk=?";

    protected Presentation(int id, int seminarTypeId, Integer duration, java.util.Date beginningDay, java.util.Date endingDay, Time startingTime, Time endingTime, Time firstStartingTime, Time lastEndingTime, String location, String street, String zipCode, String city, String country, String annex, boolean cancelled, Timestamp creationDate, Timestamp modificationDate) throws SQLException {
        super(creationDate, modificationDate);
        this.id = id;
        this.seminarTypeId = seminarTypeId;
        this.duration = duration;
        this.beginningDay = beginningDay;
        this.endingDay = endingDay;
        this.startingTime = startingTime;
        this.endingTime = endingTime;
        this.firstStartingTime = firstStartingTime;
        this.lastEndingTime = lastEndingTime;
        this.location = location;
        this.street = street;
        this.zipCode = zipCode;
        this.city = city;
        this.country = country;
        this.annex = annex;
        this.cancelled = cancelled;
        this.creationDate = creationDate;
        this.modificationDate = modificationDate;
    }

    public String getSeminarTypeDescription() {
        DistinctVector<SeminarType> semTypes;
        Vector<DBConstraint> keyConstraint = new Vector<DBConstraint>();
        keyConstraint.add(new DBConstraint(SeminarType.getColumns().get(0).getInternalColumnName(), 0, new Integer(this.seminarTypeId), 0));
        try {
            semTypes = SeminarType.getVectorFromDB(keyConstraint, null);
        }
        catch (SQLException e) {
            return "";
        }
        if (semTypes.size() > 0) {
            return ((SeminarType)semTypes.iterator().next()).getShortTitle();
        }
        return "";
    }

    public static boolean tableOK() {
        return AbstractTable.tableOK(tableName);
    }

    public static void createPresentationTable(Statement statement) throws SQLException {
        statement.execute(createTableSQLString);
        statement.close();
    }

    public int insertIntoDB() throws SQLException {
        PreparedStatement insertStmt = DBAccess.dbAccess.getPreparedStatement(presentationInsertString);
        insertStmt.setNull(1, 4);
        insertStmt.setInt(2, this.seminarTypeId);
        if (this.duration != null) {
            insertStmt.setInt(3, this.duration);
        } else {
            insertStmt.setNull(3, 4);
        }
        if (this.beginningDay != null) {
            insertStmt.setDate(4, Utility.convertToSQLDate(this.beginningDay));
        } else {
            insertStmt.setNull(4, 91);
        }
        if (this.endingDay != null) {
            insertStmt.setDate(5, Utility.convertToSQLDate(this.endingDay));
        } else {
            insertStmt.setNull(5, 91);
        }
        if (this.startingTime != null) {
            insertStmt.setTime(6, this.startingTime);
        } else {
            insertStmt.setNull(6, 92);
        }
        if (this.endingTime != null) {
            insertStmt.setTime(7, this.endingTime);
        } else {
            insertStmt.setNull(7, 92);
        }
        if (this.firstStartingTime != null) {
            insertStmt.setTime(8, this.firstStartingTime);
        } else {
            insertStmt.setNull(8, 92);
        }
        if (this.lastEndingTime != null) {
            insertStmt.setTime(9, this.lastEndingTime);
        } else {
            insertStmt.setNull(9, 92);
        }
        insertStmt.setString(10, this.location);
        insertStmt.setString(11, this.street);
        insertStmt.setString(12, this.zipCode);
        insertStmt.setString(13, this.city);
        insertStmt.setString(14, this.country);
        insertStmt.setString(15, this.annex);
        insertStmt.setBoolean(16, this.cancelled);
        insertStmt.setTimestamp(17, Utility.convertToTimestamp(this.creationDate));
        insertStmt.setTimestamp(18, Utility.convertToTimestamp(this.modificationDate));
        insertStmt.executeUpdate();
        ResultSet rs = insertStmt.getGeneratedKeys();
        if (!rs.next()) {
            throw new SQLException();
        }
        this.id = rs.getInt(1);
        rs.close();
        insertStmt.close();
        if (this.country.length() > 0) {
            Enumeration.insertcountryStringInDB(this.country);
        }
        if (this.annex.length() > 0) {
            Enumeration.insertAnnexStringInDB(this.annex);
        }
        AbstractTable.fireTableChangedEvent(13);
        return this.id;
    }

    public void updateDB() throws SQLException {
        PreparedStatement updateStmt = DBAccess.dbAccess.getPreparedStatement(presentationUpdateString);
        updateStmt.setInt(1, this.seminarTypeId);
        if (this.duration != null) {
            updateStmt.setInt(2, this.duration);
        } else {
            updateStmt.setNull(2, 4);
        }
        if (this.beginningDay != null) {
            updateStmt.setDate(3, Utility.convertToSQLDate(this.beginningDay));
        } else {
            updateStmt.setNull(3, 91);
        }
        if (this.endingDay != null) {
            updateStmt.setDate(4, Utility.convertToSQLDate(this.endingDay));
        } else {
            updateStmt.setNull(4, 91);
        }
        if (this.startingTime != null) {
            updateStmt.setTime(5, this.startingTime);
        } else {
            updateStmt.setNull(5, 92);
        }
        if (this.endingTime != null) {
            updateStmt.setTime(6, this.endingTime);
        } else {
            updateStmt.setNull(6, 92);
        }
        if (this.firstStartingTime != null) {
            updateStmt.setTime(7, this.firstStartingTime);
        } else {
            updateStmt.setNull(7, 92);
        }
        if (this.lastEndingTime != null) {
            updateStmt.setTime(8, this.lastEndingTime);
        } else {
            updateStmt.setNull(8, 92);
        }
        updateStmt.setString(9, this.location);
        updateStmt.setString(10, this.street);
        updateStmt.setString(11, this.zipCode);
        updateStmt.setString(12, this.city);
        updateStmt.setString(13, this.country);
        updateStmt.setString(14, this.annex);
        updateStmt.setBoolean(15, this.cancelled);
        updateStmt.setTimestamp(16, new Timestamp(System.currentTimeMillis()));
        updateStmt.setInt(17, this.id);
        updateStmt.executeUpdate();
        updateStmt.close();
        if (this.country.length() > 0) {
            Enumeration.insertcountryStringInDB(this.country);
        }
        if (this.annex.length() > 0) {
            Enumeration.insertAnnexStringInDB(this.annex);
        }
        AbstractTable.fireTableChangedEvent(13);
    }

    public static void removeFromDB(Iterable selectedElements) throws SQLException {
        String deleteString = "DELETE FROM " + tableName + " WHERE ";
        Iterator it = selectedElements.iterator();
        int idToDelete = ((Presentation)it.next()).getId();
        deleteString = String.valueOf(deleteString) + "id_pk=" + idToDelete + " ";
        while (it.hasNext()) {
            idToDelete = ((Presentation)it.next()).getId();
            deleteString = String.valueOf(deleteString) + "OR id_pk=" + idToDelete + " ";
        }
        Statement stmt = DBAccess.dbAccess.getStatement();
        stmt.executeUpdate(deleteString);
        stmt.close();
        AbstractTable.fireTableChangedEvent(13);
        AbstractTable.fireTableChangedEvent(14);
        AbstractTable.fireTableChangedEvent(7);
        AbstractTable.fireTableChangedEvent(6);
        AbstractTable.fireTableChangedEvent(4);
    }

    public static Vector<DBColumn> getColumns() {
        Vector<DBColumn> columns = new Vector<DBColumn>();
        columns.add(new DBColumn("pr.id_pk", Messages.getString("MAP.Presentation.IdPK"), Integer.class));
        columns.add(new DBColumn("pr.seminartype_fk", Messages.getString("MAP.Presentation.SeminarTypeFK"), Integer.class));
        columns.add(new DBColumn("pr.duration", Messages.getString("MAP.Presentation.Duration"), Integer.class));
        columns.add(new DBColumn("pr.beginningday", Messages.getString("MAP.Presentation.BeginningDay"), java.util.Date.class));
        columns.add(new DBColumn("pr.endingday", Messages.getString("MAP.Presentation.EndingDay"), java.util.Date.class));
        columns.add(new DBColumn("pr.startingtime", Messages.getString("MAP.Presentation.StartingTime"), Time.class));
        columns.add(new DBColumn("pr.endingtime", Messages.getString("MAP.Presentation.EndingTime"), Time.class));
        columns.add(new DBColumn("pr.firststartingtime", Messages.getString("MAP.Presentation.FirstStartingTime"), Time.class));
        columns.add(new DBColumn("pr.lastendingtime", Messages.getString("MAP.Presentation.LastEndingTime"), Time.class));
        columns.add(new DBColumn("pr.location", Messages.getString("MAP.Presentation.Location"), String.class));
        columns.add(new DBColumn("pr.street", Messages.getString("MAP.Presentation.Street"), String.class));
        columns.add(new DBColumn("pr.street", Messages.getString("MAP.Presentation.ZipCode"), String.class));
        columns.add(new DBColumn("pr.zipcode", Messages.getString("MAP.Presentation.City"), String.class));
        columns.add(new DBColumn("pr.country", Messages.getString("MAP.Presentation.Country"), String.class));
        columns.add(new DBColumn("pr.annex", Messages.getString("MAP.Presentation.Annex"), String.class));
        columns.add(new DBColumn("pr.cancelled", Messages.getString("MAP.Presentation.Cancelled"), Boolean.class));
        columns.addAll(AbstractTable.getColumns("pr."));
        return columns;
    }

    private static DistinctVector<Presentation> getVector(ResultSet resultSet) {
        DistinctVector<Presentation> set = new DistinctVector<Presentation>();
        try {
            while (resultSet.next()) {
                int id = resultSet.getInt("id_pk");
                int seminarTypeId = resultSet.getInt("seminartype_fk");
                Integer duration = resultSet.getInt("duration");
                if (resultSet.wasNull()) {
                    duration = null;
                }
                Date beginningDay = resultSet.getDate("beginningday");
                Date endingDay = resultSet.getDate("endingday");
                Time startingTime = resultSet.getTime("startingtime");
                Time endingTime = resultSet.getTime("endingtime");
                Time firstStartingTime = resultSet.getTime("firststartingtime");
                Time lastEndingTime = resultSet.getTime("lastendingtime");
                String location = resultSet.getString("location");
                String street = resultSet.getString("street");
                String zipCode = resultSet.getString("zipcode");
                String city = resultSet.getString("city");
                String country = resultSet.getString("country");
                String annex = resultSet.getString("annex");
                boolean cancelled = resultSet.getBoolean("cancelled");
                Timestamp creationDate = resultSet.getTimestamp("creationdate");
                Timestamp modificationDate = resultSet.getTimestamp("modificationdate");
                set.add(new Presentation(id, seminarTypeId, duration, beginningDay, endingDay, startingTime, endingTime, firstStartingTime, lastEndingTime, location, street, zipCode, city, country, annex, cancelled, creationDate, modificationDate));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return set;
    }

    public static DistinctVector<Presentation> getPresSupervisedBy(int lecturerId) throws SQLException {
        PreparedStatement stmt = DBAccess.dbAccess.getPreparedStatement(superviseQueryString);
        stmt.setInt(1, lecturerId);
        ResultSet rs = stmt.executeQuery();
        DistinctVector<Presentation> returnValue = Presentation.getVector(rs);
        rs.close();
        stmt.close();
        return returnValue;
    }

    public static DistinctVector<Presentation> getPresInstructedBy(int lecturerId) throws SQLException {
        PreparedStatement stmt = DBAccess.dbAccess.getPreparedStatement(instructQueryString);
        stmt.setInt(1, lecturerId);
        ResultSet rs = stmt.executeQuery();
        DistinctVector<Presentation> returnValue = Presentation.getVector(rs);
        rs.close();
        stmt.close();
        return returnValue;
    }

    public static DistinctVector<Presentation> getPresForSemType(int semTypeId) throws SQLException {
        PreparedStatement stmt = DBAccess.dbAccess.getPreparedStatement(presentationQueryString);
        stmt.setInt(1, semTypeId);
        ResultSet rs = stmt.executeQuery();
        DistinctVector<Presentation> returnValue = Presentation.getVector(rs);
        rs.close();
        stmt.close();
        return returnValue;
    }

    public static DistinctVector<Presentation> getPresentationVectorFromDB(Vector<DBConstraint> additionalConstraints, String sortString) throws SQLException {
        PreparedStatement stmt = AbstractTable.createExtendedQueryString(queryString, additionalConstraints, sortString);
        ResultSet rs = stmt.executeQuery();
        DistinctVector<Presentation> returnValue = Presentation.getVector(rs);
        rs.close();
        stmt.close();
        return returnValue;
    }

    public static Presentation getPresentation(int presentationId) throws SQLException {
        Vector<DBConstraint> keyConstraint = new Vector<DBConstraint>();
        keyConstraint.add(new DBConstraint(Presentation.getColumns().get(0).getInternalColumnName(), 0, new Integer(presentationId), 0));
        DistinctVector<Presentation> pres = Presentation.getPresentationVectorFromDB(keyConstraint, null);
        return (Presentation)pres.iterator().next();
    }

    public static Vector<DBColumn> getColumnsWithSemtype() {
        Vector<DBColumn> columns = Presentation.getColumns();
        columns.set(1, new DBColumn("s.shorttitle", Messages.getString("MAP.Presentation.SeminarTypeST"), String.class));
        return columns;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object otherPresentation) {
        if (otherPresentation instanceof Presentation) {
            return this.id == ((Presentation)otherPresentation).id;
        }
        return super.equals(otherPresentation);
    }

    public String getShortDescription() {
        SeminarType semType = null;
        try {
            semType = SeminarType.getSeminarTypeFromDB(this.seminarTypeId);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        String returnValue = "" + this.id;
        if (semType != null) {
            returnValue = String.valueOf(returnValue) + ", " + Messages.getString("MAP.Presentation.SeminarTypeST") + ": " + semType.getShortTitle();
        }
        return returnValue;
    }

    public static SeminarType getSeminarTypeForPresId(int presId) throws SQLException {
        Presentation tmpPres = null;
        SeminarType tmpSemType = null;
        tmpPres = Presentation.getPresentation(presId);
        if (tmpPres != null) {
            tmpSemType = SeminarType.getSeminarTypeFromDB(tmpPres.getSeminarTypeId());
        }
        if (tmpSemType != null) {
            return tmpSemType;
        }
        return null;
    }

    public String getAnnex() {
        return this.annex;
    }

    public void setAnnex(String annex) {
        this.annex = annex;
    }

    public java.util.Date getBeginningDay() {
        return this.beginningDay;
    }

    public void setBeginningDay(java.util.Date beginningDay) {
        this.beginningDay = beginningDay;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public java.util.Date getEndingDay() {
        return this.endingDay;
    }

    public void setEndingDay(java.util.Date endingDay) {
        this.endingDay = endingDay;
    }

    public Time getEndingTime() {
        return this.endingTime;
    }

    public void setEndingTime(Time endingTime) {
        this.endingTime = endingTime;
    }

    public Time getFirstStartingTime() {
        return this.firstStartingTime;
    }

    public void setFirstStartingTime(Time firstStartingTime) {
        this.firstStartingTime = firstStartingTime;
    }

    public Time getLastEndingTime() {
        return this.lastEndingTime;
    }

    public void setLastEndingTime(Time lastEndingTime) {
        this.lastEndingTime = lastEndingTime;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public int getSeminarTypeId() {
        return this.seminarTypeId;
    }

    public void setSeminarTypeId(int seminarTypeId) {
        this.seminarTypeId = seminarTypeId;
    }

    public Time getStartingTime() {
        return this.startingTime;
    }

    public void setStartingTime(Time startingTime) {
        this.startingTime = startingTime;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    @Override
    public int getId() {
        return this.id;
    }
}

