/*
 * Decompiled with CFR 0.152.
 */
package semorg.sql.tables;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import semorg.gui.util.Messages;
import semorg.sql.access.DBAccess;
import semorg.sql.tables.AbstractTable;
import semorg.sql.tables.Enumeration;
import semorg.sql.tables.SimpleIDKey;
import semorg.sql.util.DBColumn;
import semorg.sql.util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Person
extends AbstractTable
implements SimpleIDKey {
    public static List<Integer> lockedIds = new ArrayList<Integer>();
    protected int id;
    protected String salutation;
    protected String title;
    protected String firstname;
    protected String name;
    protected String street;
    protected String zipCode;
    protected String city;
    protected String country;
    protected String annex;
    protected String phone;
    protected String mobile;
    protected String fax;
    protected String email;
    protected Date birthday;
    protected Date firstContact;
    protected String shortinfo;
    protected String notices;
    private static String tableName = "person";
    protected static String personInsertString = "INSERT INTO " + tableName + " VALUES(?, ?, ?, ?, ?, " + "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static String createTableSQLString = "CREATE TABLE IF NOT EXISTS `" + tableName + "` (" + "`number_pk` integer NOT NULL auto_increment," + "`salutation` varchar(13) NOT NULL," + "`title` varchar(13)," + "`firstname` varchar(30)," + "`name` varchar(30) NOT NULL," + "`street` varchar(50)," + "`zipCode` varchar(5)," + "`city` varchar(30)," + "`country` varchar(13)," + "`annex` varchar(13)," + "`phone` varchar(20)," + "`mobile` varchar(20)," + "`fax` varchar(20)," + "`email` varchar(256)," + "`birthday` date," + "`firstcontact` date," + "`shortinfo` varchar(200)," + "`notices` varchar(200)," + "`creationdate` timestamp NOT NULL default '0000-00-00 00:00:00'," + "`modificationdate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP," + "PRIMARY KEY  (`number_pk`) )";
    protected static String personUpdateString = "UPDATE " + tableName + " SET salutation=?, title=?, firstname=?, name=?, street=?, zipCode=?, " + "city=?, country=?, annex=?, phone=?, mobile=?, fax=?, email=?, birthday=?, firstcontact=?, shortinfo=?, " + "notices=?, modificationdate=? WHERE number_pk=?";

    protected Person(int id, String salutation, String title, String firstname, String name, String street, String zipCode, String city, String country, String annex, String phone, String mobile, String fax, String email, Date birthday, Date firstContact, String shortinfo, String notices, Timestamp creationDate, Timestamp modificationDate) {
        super(creationDate, modificationDate);
        this.id = id;
        this.salutation = salutation;
        this.title = title;
        this.firstname = firstname;
        this.name = name;
        this.street = street;
        this.zipCode = zipCode;
        this.city = city;
        this.country = country;
        this.annex = annex;
        this.phone = phone;
        this.mobile = mobile;
        this.fax = fax;
        this.email = email;
        this.birthday = birthday;
        this.firstContact = firstContact;
        this.shortinfo = shortinfo;
        this.notices = notices;
    }

    public String getAnnex() {
        return this.annex;
    }

    public Date getBirthday() {
        return this.birthday;
    }

    public String getCity() {
        return this.city;
    }

    public String getCountry() {
        return this.country;
    }

    public String getEmail() {
        return this.email;
    }

    public String getFax() {
        return this.fax;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public String getMobile() {
        return this.mobile;
    }

    public String getName() {
        return this.name;
    }

    public String getNotices() {
        return this.notices;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getSalutation() {
        return this.salutation;
    }

    public String getShortinfo() {
        return this.shortinfo;
    }

    public String getStreet() {
        return this.street;
    }

    public String getTitle() {
        return this.title;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public Date getFirstContact() {
        return this.firstContact;
    }

    public void setAnnex(String annex) {
        this.annex = annex;
    }

    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public void setFirstContact(Date firstContact) {
        this.firstContact = firstContact;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNotices(String notices) {
        this.notices = notices;
    }

    public void setNumber(int number) {
        this.id = number;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setSalutation(String salutation) {
        this.salutation = salutation;
    }

    public void setShortinfo(String shortinfo) {
        this.shortinfo = shortinfo;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public static boolean tableOK() {
        return AbstractTable.tableOK(tableName);
    }

    public static void createPersonTable(Statement statement) throws SQLException {
        statement.execute(createTableSQLString);
        statement.close();
    }

    public int insertIntoDB() throws SQLException {
        PreparedStatement insertPersonStmt = DBAccess.dbAccess.getPreparedStatement(personInsertString);
        insertPersonStmt.setNull(1, 4);
        insertPersonStmt.setString(2, this.salutation);
        insertPersonStmt.setString(3, this.title);
        insertPersonStmt.setString(4, this.firstname);
        insertPersonStmt.setString(5, this.name);
        insertPersonStmt.setString(6, this.street);
        insertPersonStmt.setString(7, this.zipCode);
        insertPersonStmt.setString(8, this.city);
        insertPersonStmt.setString(9, this.country);
        insertPersonStmt.setString(10, this.annex);
        insertPersonStmt.setString(11, this.phone);
        insertPersonStmt.setString(12, this.mobile);
        insertPersonStmt.setString(13, this.fax);
        insertPersonStmt.setString(14, this.email);
        if (this.birthday != null) {
            insertPersonStmt.setDate(15, Utility.convertToSQLDate(this.birthday));
        } else {
            insertPersonStmt.setNull(15, 91);
        }
        if (this.firstContact != null) {
            insertPersonStmt.setDate(16, Utility.convertToSQLDate(this.firstContact));
        } else {
            insertPersonStmt.setNull(16, 91);
        }
        insertPersonStmt.setString(17, this.shortinfo);
        insertPersonStmt.setString(18, this.notices);
        insertPersonStmt.setTimestamp(19, Utility.convertToTimestamp(this.creationDate));
        insertPersonStmt.setTimestamp(20, Utility.convertToTimestamp(this.modificationDate));
        insertPersonStmt.executeUpdate();
        ResultSet rs = insertPersonStmt.getGeneratedKeys();
        if (!rs.next()) {
            throw new SQLException();
        }
        this.id = rs.getInt(1);
        rs.close();
        insertPersonStmt.close();
        if (this.salutation.length() > 0) {
            Enumeration.insertSalutationStringInDB(this.salutation);
        }
        if (this.title.length() > 0) {
            Enumeration.insertTitleStringInDB(this.title);
        }
        if (this.country.length() > 0) {
            Enumeration.insertcountryStringInDB(this.country);
        }
        if (this.annex.length() > 0) {
            Enumeration.insertAnnexStringInDB(this.annex);
        }
        AbstractTable.fireTableChangedEvent(12);
        return this.id;
    }

    public void updateDB() throws SQLException {
        PreparedStatement updatePersonStmt = DBAccess.dbAccess.getPreparedStatement(personUpdateString);
        updatePersonStmt.setString(1, this.salutation);
        updatePersonStmt.setString(2, this.title);
        updatePersonStmt.setString(3, this.firstname);
        updatePersonStmt.setString(4, this.name);
        updatePersonStmt.setString(5, this.street);
        updatePersonStmt.setString(6, this.zipCode);
        updatePersonStmt.setString(7, this.city);
        updatePersonStmt.setString(8, this.country);
        updatePersonStmt.setString(9, this.annex);
        updatePersonStmt.setString(10, this.phone);
        updatePersonStmt.setString(11, this.mobile);
        updatePersonStmt.setString(12, this.fax);
        updatePersonStmt.setString(13, this.email);
        if (this.birthday != null) {
            updatePersonStmt.setDate(14, Utility.convertToSQLDate(this.birthday));
        } else {
            updatePersonStmt.setNull(14, 91);
        }
        if (this.firstContact != null) {
            updatePersonStmt.setDate(15, Utility.convertToSQLDate(this.firstContact));
        } else {
            updatePersonStmt.setNull(15, 91);
        }
        updatePersonStmt.setString(16, this.shortinfo);
        updatePersonStmt.setString(17, this.notices);
        updatePersonStmt.setTimestamp(18, new Timestamp(System.currentTimeMillis()));
        updatePersonStmt.setInt(19, this.id);
        updatePersonStmt.executeUpdate();
        updatePersonStmt.close();
        if (this.salutation.length() > 0) {
            Enumeration.insertSalutationStringInDB(this.salutation);
        }
        if (this.title.length() > 0) {
            Enumeration.insertTitleStringInDB(this.title);
        }
        if (this.country.length() > 0) {
            Enumeration.insertcountryStringInDB(this.country);
        }
        if (this.annex.length() > 0) {
            Enumeration.insertAnnexStringInDB(this.annex);
        }
        AbstractTable.fireTableChangedEvent(12);
    }

    public static void removeFromDB(Iterable selectedElements) throws SQLException {
        String deleteString = "DELETE FROM " + tableName + " WHERE ";
        Iterator it = selectedElements.iterator();
        int idToDelete = ((Person)it.next()).getId();
        deleteString = String.valueOf(deleteString) + "number_pk=" + idToDelete + " ";
        while (it.hasNext()) {
            idToDelete = ((Person)it.next()).getId();
            deleteString = String.valueOf(deleteString) + "OR number_pk=" + idToDelete + " ";
        }
        Statement stmt = DBAccess.dbAccess.getStatement();
        stmt.executeUpdate(deleteString);
        stmt.close();
        AbstractTable.fireTableChangedEvent(12);
        AbstractTable.fireTableChangedEvent(1);
        AbstractTable.fireTableChangedEvent(3);
        AbstractTable.fireTableChangedEvent(11);
        AbstractTable.fireTableChangedEvent(2);
        AbstractTable.fireTableChangedEvent(4);
    }

    public static Vector<DBColumn> getColumns() {
        Vector<DBColumn> columns = new Vector<DBColumn>();
        columns.add(new DBColumn("p.number_pk", Messages.getString("MAP.Person.NumberPK"), Integer.class));
        columns.add(new DBColumn("p.salutation", Messages.getString("MAP.Person.Salutation"), String.class));
        columns.add(new DBColumn("p.title", Messages.getString("MAP.Person.Title"), String.class));
        columns.add(new DBColumn("p.firstname", Messages.getString("MAP.Person.Firstname"), String.class));
        columns.add(new DBColumn("p.name", Messages.getString("MAP.Person.Name"), String.class));
        columns.add(new DBColumn("p.street", Messages.getString("MAP.Person.Street"), String.class));
        columns.add(new DBColumn("p.zipCode", Messages.getString("MAP.Person.ZipCode"), String.class));
        columns.add(new DBColumn("p.city", Messages.getString("MAP.Person.City"), String.class));
        columns.add(new DBColumn("p.country", Messages.getString("MAP.Person.Country"), String.class));
        columns.add(new DBColumn("p.annex", Messages.getString("MAP.Person.Annex"), String.class));
        columns.add(new DBColumn("p.phone", Messages.getString("MAP.Person.Phone"), String.class));
        columns.add(new DBColumn("p.mobile", Messages.getString("MAP.Person.Mobile"), String.class));
        columns.add(new DBColumn("p.fax", Messages.getString("MAP.Person.Fax"), String.class));
        columns.add(new DBColumn("p.email", Messages.getString("MAP.Person.Email"), String.class));
        columns.add(new DBColumn("p.birthday", Messages.getString("MAP.Person.Birthday"), Date.class));
        columns.add(new DBColumn("p.firstcontact", Messages.getString("MAP.Person.FirstContact"), Date.class));
        columns.add(new DBColumn("p.shortinfo", Messages.getString("MAP.Person.ShortInfo"), String.class));
        columns.add(new DBColumn("p.notices", Messages.getString("MAP.Person.Notices"), String.class));
        columns.addAll(AbstractTable.getColumns("p."));
        return columns;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object otherPerson) {
        if (otherPerson instanceof Person) {
            return this.id == ((Person)otherPerson).id;
        }
        return super.equals(otherPerson);
    }
}

