/*
 * Decompiled with CFR 0.152.
 */
package semorg.sql.tables;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import semorg.gui.util.Messages;
import semorg.sql.access.DBAccess;
import semorg.sql.tables.AbstractTable;
import semorg.sql.tables.Person;
import semorg.sql.util.DBColumn;
import semorg.sql.util.DBConstraint;
import semorg.sql.util.DistinctVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lecturer
extends Person {
    private String bio;
    private Float dailyFee;
    private Float hourlyFee;
    private static String tableName = "lecturer";
    private static String queryString = "SELECT p.number_pk, p.salutation, p.title, p.firstname, p.name, p.street, p.zipCode, p.city, p.country, p.annex, p.phone, p.mobile, p.fax, p.email, p.birthday, p.firstcontact, p.shortinfo, p.notices, l.bio, l.dailyfee, l.hourlyfee, p.creationdate, p.modificationdate FROM person p, " + tableName + " l WHERE p.number_pk=l.person_fk";
    private static String instructQueryString = "SELECT p.number_pk, p.salutation, p.title, p.firstname, p.name, p.street, p.zipCode, p.city, p.country, p.annex, p.phone, p.mobile, p.fax, p.email, p.birthday, p.firstcontact, p.shortinfo, p.notices, l.bio, l.dailyfee, l.hourlyfee, p.creationdate, p.modificationdate FROM person p, lecturer l, instructor i WHERE p.number_pk=l.person_fk AND p.number_pk=i.lecturerid AND i.presentationid=?";
    private static String superviseQueryString = "SELECT p.number_pk, p.salutation, p.title, p.firstname, p.name, p.street, p.zipCode, p.city, p.country, p.annex, p.phone, p.mobile, p.fax, p.email, p.birthday, p.firstcontact, p.shortinfo, p.notices, l.bio, l.dailyfee, l.hourlyfee, p.creationdate, p.modificationdate FROM person p, lecturer l, supervisor s WHERE p.number_pk=l.person_fk AND p.number_pk=s.lecturerid AND s.presentationid=?";
    private static String conductQueryString = "SELECT p.number_pk, p.salutation, p.title, p.firstname, p.name, p.street, p.zipCode, p.city, p.country, p.annex, p.phone, p.mobile, p.fax, p.email, p.birthday, p.firstcontact, p.shortinfo, p.notices, l.bio, l.dailyfee, l.hourlyfee, p.creationdate, p.modificationdate FROM person p, lecturer l, conduct c WHERE p.number_pk=l.person_fk AND p.number_pk=c.lecturerid AND c.seminartypeid=?";
    private static String lecturerInsertString = "INSERT INTO " + tableName + " VALUES(?, ?, ?, ?)";
    private static String lecturerUpdateString = "UPDATE " + tableName + " SET bio=?, dailyfee=?, hourlyfee=? WHERE person_fk=?";
    private static String createTableSQLString = "CREATE TABLE IF NOT EXISTS `" + tableName + "` (" + "`person_fk` integer NOT NULL," + "`bio` varchar(400)," + "`dailyfee` float," + "`hourlyfee` float," + "PRIMARY KEY  (`person_fk`)," + "CONSTRAINT `lecturer_fk` FOREIGN KEY (`person_fk`) REFERENCES `person` (`number_pk`) ON DELETE CASCADE)";

    public Lecturer(int id, String salutation, String title, String firstname, String name, String street, String zipCode, String city, String country, String annex, String phone, String mobile, String fax, String email, Date birthday, Date firstContact, String bio, Float dailyFee, Float hourlyFee, String shortinfo, String notices, Timestamp creationDate, Timestamp modificationDate) {
        super(id, salutation, title, firstname, name, street, zipCode, city, country, annex, phone, mobile, fax, email, birthday, firstContact, shortinfo, notices, creationDate, modificationDate);
        this.bio = bio;
        this.dailyFee = dailyFee;
        this.hourlyFee = hourlyFee;
    }

    private static DistinctVector<Lecturer> getVector(ResultSet resultSet) {
        DistinctVector<Lecturer> set = new DistinctVector<Lecturer>();
        try {
            while (resultSet.next()) {
                int number = resultSet.getInt("number_pk");
                String salutation = resultSet.getString("salutation");
                String title = resultSet.getString("title");
                String firstname = resultSet.getString("firstname");
                String name = resultSet.getString("name");
                String street = resultSet.getString("street");
                String zipCode = resultSet.getString("zipCode");
                String city = resultSet.getString("city");
                String country = resultSet.getString("country");
                String annex = resultSet.getString("annex");
                String phone = resultSet.getString("phone");
                String mobile = resultSet.getString("mobile");
                String fax = resultSet.getString("fax");
                String email = resultSet.getString("email");
                java.sql.Date birthday = resultSet.getDate("birthday");
                java.sql.Date firstContact = resultSet.getDate("firstcontact");
                String shortinfo = resultSet.getString("shortinfo");
                String notices = resultSet.getString("notices");
                String bio = resultSet.getString("bio");
                Float dailyFee = Float.valueOf(resultSet.getFloat("dailyfee"));
                if (resultSet.wasNull()) {
                    dailyFee = null;
                }
                Float hourlyFee = Float.valueOf(resultSet.getFloat("hourlyfee"));
                if (resultSet.wasNull()) {
                    hourlyFee = null;
                }
                Timestamp creationDate = resultSet.getTimestamp("creationdate");
                Timestamp modificationDate = resultSet.getTimestamp("modificationdate");
                set.add(new Lecturer(number, salutation, title, firstname, name, street, zipCode, city, country, annex, phone, mobile, fax, email, birthday, firstContact, bio, dailyFee, hourlyFee, shortinfo, notices, creationDate, modificationDate));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return set;
    }

    public static DistinctVector<Lecturer> getVectorFromDB(Vector<DBConstraint> additionalConstraints, String sortString) throws SQLException {
        PreparedStatement stmt = AbstractTable.createExtendedQueryString(queryString, additionalConstraints, sortString);
        ResultSet rs = stmt.executeQuery();
        DistinctVector<Lecturer> returnValue = Lecturer.getVector(rs);
        rs.close();
        stmt.close();
        return returnValue;
    }

    public static boolean tableOK() {
        return AbstractTable.tableOK(tableName);
    }

    public static void createLecturerTable(Statement statement) throws SQLException {
        statement.execute(createTableSQLString);
        statement.close();
    }

    @Override
    public int insertIntoDB() throws SQLException {
        super.insertIntoDB();
        PreparedStatement insertStmt = DBAccess.dbAccess.getPreparedStatement(lecturerInsertString);
        insertStmt.setInt(1, this.id);
        insertStmt.setString(2, this.bio);
        if (this.dailyFee != null) {
            insertStmt.setFloat(3, this.dailyFee.floatValue());
        } else {
            insertStmt.setNull(3, 6);
        }
        if (this.hourlyFee != null) {
            insertStmt.setFloat(4, this.hourlyFee.floatValue());
        } else {
            insertStmt.setNull(4, 6);
        }
        insertStmt.executeUpdate();
        insertStmt.close();
        AbstractTable.fireTableChangedEvent(11);
        return this.id;
    }

    @Override
    public void updateDB() throws SQLException {
        super.updateDB();
        PreparedStatement updateStmt = DBAccess.dbAccess.getPreparedStatement(lecturerUpdateString);
        updateStmt.setString(1, this.bio);
        if (this.dailyFee != null) {
            updateStmt.setFloat(2, this.dailyFee.floatValue());
        } else {
            updateStmt.setNull(2, 6);
        }
        if (this.hourlyFee != null) {
            updateStmt.setFloat(3, this.hourlyFee.floatValue());
        } else {
            updateStmt.setNull(3, 6);
        }
        updateStmt.setInt(4, this.id);
        updateStmt.executeUpdate();
        updateStmt.close();
        AbstractTable.fireTableChangedEvent(11);
    }

    public static Vector<DBColumn> getColumns() {
        Vector<DBColumn> columns = Person.getColumns();
        columns.add(columns.size() - 2, new DBColumn("l.bio", Messages.getString("MAP.Lecturer.Bio"), String.class));
        columns.add(columns.size() - 2, new DBColumn("l.dailyfee", Messages.getString("MAP.Lecturer.DailyFee"), Float.class));
        columns.add(columns.size() - 2, new DBColumn("l.hourlyfee", Messages.getString("MAP.Lecturer.HourlyFee"), Float.class));
        return columns;
    }

    public String getBio() {
        return this.bio;
    }

    public void setBio(String bio) {
        this.bio = bio;
    }

    public Float getDailyFee() {
        return this.dailyFee;
    }

    public void setDailyFee(Float dailyFee) {
        this.dailyFee = dailyFee;
    }

    public Float getHourlyFee() {
        return this.hourlyFee;
    }

    public void setHourlyFee(Float hourlyFee) {
        this.hourlyFee = hourlyFee;
    }

    public static Lecturer getNext(int lecturerId) {
        Lecturer returnValue = null;
        ResultSet rs = AbstractTable.getNext(queryString, Lecturer.getColumns().get(0), lecturerId);
        if (rs != null) {
            returnValue = (Lecturer)Lecturer.getVector(rs).iterator().next();
            try {
                Statement producingStatement = rs.getStatement();
                rs.close();
                if (producingStatement != null) {
                    producingStatement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return returnValue;
    }

    public static Lecturer getPrevious(int lecturerId) {
        Lecturer returnValue = null;
        ResultSet rs = AbstractTable.getPrevious(queryString, Lecturer.getColumns().get(0), lecturerId);
        if (rs != null) {
            returnValue = (Lecturer)Lecturer.getVector(rs).iterator().next();
            try {
                Statement producingStatement = rs.getStatement();
                rs.close();
                if (producingStatement != null) {
                    producingStatement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return returnValue;
    }

    public static DistinctVector<Lecturer> getLectInstructing(int presentationId) throws SQLException {
        PreparedStatement stmt = DBAccess.dbAccess.getPreparedStatement(instructQueryString);
        stmt.setInt(1, presentationId);
        ResultSet rs = stmt.executeQuery();
        DistinctVector<Lecturer> returnValue = Lecturer.getVector(rs);
        rs.close();
        stmt.close();
        return returnValue;
    }

    public static DistinctVector<Lecturer> getLectSupervising(int presentationId) throws SQLException {
        PreparedStatement stmt = DBAccess.dbAccess.getPreparedStatement(superviseQueryString);
        stmt.setInt(1, presentationId);
        ResultSet rs = stmt.executeQuery();
        DistinctVector<Lecturer> returnValue = Lecturer.getVector(rs);
        rs.close();
        stmt.close();
        return returnValue;
    }

    public static DistinctVector<Lecturer> getLectConducting(int seminarTypeId) throws SQLException {
        PreparedStatement stmt = DBAccess.dbAccess.getPreparedStatement(conductQueryString);
        stmt.setInt(1, seminarTypeId);
        ResultSet rs = stmt.executeQuery();
        DistinctVector<Lecturer> returnValue = Lecturer.getVector(rs);
        rs.close();
        stmt.close();
        return returnValue;
    }
}

