/*
 * Decompiled with CFR 0.152.
 */
package semorg.sql.tables;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import semorg.gui.util.Messages;
import semorg.sql.access.DBAccess;
import semorg.sql.tables.AbstractTable;
import semorg.sql.util.DBColumn;
import semorg.sql.util.KeyPair;
import semorg.sql.util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Instructor
extends AbstractTable {
    public static List<KeyPair> lockedIds = new ArrayList<KeyPair>();
    protected int lecturerId;
    protected int presentationId;
    private static String tableName = "instructor";
    protected static String supervisorInsertString = "INSERT INTO " + tableName + " VALUES(?, ?, ?, ?)";
    protected static String supervisorDeleteString = "DELETE FROM " + tableName + " WHERE lecturerid=? AND presentationid=?";
    private static String createTableSQLString = "CREATE TABLE IF NOT EXISTS `" + tableName + "` (" + "`lecturerid` integer NOT NULL," + "`presentationid` integer NOT NULL," + "`creationdate` timestamp NOT NULL default '0000-00-00 00:00:00'," + "`modificationdate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP," + "PRIMARY KEY  (`lecturerid`, `presentationid`)," + "CONSTRAINT `instr_lecturer_fk` FOREIGN KEY (`lecturerid`) REFERENCES `lecturer` (`person_fk`) ON DELETE CASCADE, " + "CONSTRAINT `instr_pres_fk` FOREIGN KEY (`presentationid`) REFERENCES `presentation` (`id_pk`) ON DELETE CASCADE)";

    public Instructor(int lecturerId, int presentationId, Timestamp creationDate, Timestamp modificationDate) {
        super(creationDate, modificationDate);
        this.lecturerId = lecturerId;
        this.presentationId = presentationId;
    }

    public static boolean tableOK() {
        return AbstractTable.tableOK(tableName);
    }

    public static void createInstructorTable(Statement statement) throws SQLException {
        statement.execute(createTableSQLString);
        statement.close();
    }

    public void insertIntoDB() throws SQLException {
        PreparedStatement insertStmt = DBAccess.dbAccess.getPreparedStatement(supervisorInsertString);
        insertStmt.setInt(1, this.lecturerId);
        insertStmt.setInt(2, this.presentationId);
        insertStmt.setTimestamp(3, Utility.convertToTimestamp(this.creationDate));
        insertStmt.setTimestamp(4, Utility.convertToTimestamp(this.modificationDate));
        insertStmt.executeUpdate();
        insertStmt.close();
        AbstractTable.fireTableChangedEvent(10);
    }

    public void deleteFromDB() throws SQLException {
        PreparedStatement deleteStmt = DBAccess.dbAccess.getPreparedStatement(supervisorDeleteString);
        deleteStmt.setInt(1, this.lecturerId);
        deleteStmt.setInt(2, this.presentationId);
        deleteStmt.executeUpdate();
        deleteStmt.close();
        AbstractTable.fireTableChangedEvent(10);
    }

    public static Vector<DBColumn> getColumns() {
        Vector<DBColumn> columns = new Vector<DBColumn>();
        columns.add(new DBColumn("lecturerid", Messages.getString("MAP.Instructor.LecturerId"), Integer.class));
        columns.add(new DBColumn("presentationid", Messages.getString("MAP.Instructor.PresentationId"), Integer.class));
        columns.addAll(AbstractTable.getColumns(""));
        return columns;
    }

    public int getLecturerId() {
        return this.lecturerId;
    }

    public int getPresentationId() {
        return this.presentationId;
    }
}

