/*
 * Decompiled with CFR 0.152.
 */
package semorg.sql.tables;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import org.eclipse.swt.widgets.Combo;
import semorg.sql.access.DBAccess;
import semorg.sql.tables.AbstractTable;
import semorg.sql.util.DistinctVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Enumeration {
    public static final int TYPE_SALUTATION = 0;
    public static final int TYPE_TITLE = 1;
    public static final int TYPE_COUNTRY = 2;
    public static final int TYPE_ANNEX = 3;
    private static String tableName = "enumeration";
    private static String createTableSQLString = "CREATE TABLE IF NOT EXISTS `" + tableName + "` (" + "`type` integer NOT NULL," + "`value` varchar(13) NOT NULL," + "PRIMARY KEY  (`type`, `value`) )";
    private static String insertString = "INSERT INTO " + tableName + " VALUES(?, ?)";
    private static String deleteString = "DELETE FROM " + tableName + " WHERE type=? AND value=?";
    private static String updateString = "UPDATE " + tableName + " SET " + "value=? WHERE type=? AND value=?";
    private static String queryString = "SELECT type, value FROM " + tableName + " WHERE type=?";
    private static String checkForSalutationString = "(SELECT number_pk FROM person WHERE salutation=?) UNION (SELECT id_pk FROM company WHERE salutation=?) UNION (SELECT id_pk FROM company WHERE cpsalutation=?) LIMIT 1";
    private static String checkForTitleString = "(SELECT number_pk FROM person WHERE title=?) UNION (SELECT id_pk FROM company WHERE title=?) UNION (SELECT id_pk FROM company WHERE cptitle=?) LIMIT 1";
    private static String checkForCountryString = "(SELECT number_pk FROM person WHERE country=?) UNION (SELECT id_pk FROM company WHERE country=?) UNION (SELECT id_pk FROM presentation WHERE country=?) LIMIT 1";
    private static String checkForAnnexString = "(SELECT number_pk FROM person WHERE annex=?) UNION (SELECT id_pk FROM company WHERE annex=?) UNION (SELECT id_pk FROM presentation WHERE annex=?) LIMIT 1";
    private static String[] updateSalutationStrings = new String[]{"UPDATE person SET salutation=? WHERE salutation=?", "UPDATE company SET salutation=? WHERE salutation=?", "UPDATE company SET cpsalutation=? WHERE cpsalutation=?"};
    private static String[] updateTitleStrings = new String[]{"UPDATE person SET salutation=? WHERE salutation=?", "UPDATE company SET salutation=? WHERE salutation=?", "UPDATE company SET cpsalutation=? WHERE cpsalutation=?"};
    private static String[] updateCountryStrings = new String[]{"UPDATE person SET salutation=? WHERE salutation=?", "UPDATE company SET salutation=? WHERE salutation=?", "UPDATE presentation SET cpsalutation=? WHERE cpsalutation=?"};
    private static String[] updateAnnexStrings = new String[]{"UPDATE person SET salutation=? WHERE salutation=?", "UPDATE company SET salutation=? WHERE salutation=?", "UPDATE presentation SET cpsalutation=? WHERE cpsalutation=?"};
    private int type;
    private String value;

    public Enumeration(int type, String value) {
        this.type = type;
        this.value = value;
    }

    public static void createEnumerationTable(Statement statement) throws SQLException {
        statement.execute(createTableSQLString);
        statement.close();
    }

    public static DistinctVector<Enumeration> getVectorFromDB(int type) throws SQLException {
        PreparedStatement stmt = DBAccess.dbAccess.getPreparedStatement(queryString);
        stmt.setInt(1, type);
        ResultSet rs = stmt.executeQuery();
        DistinctVector<Enumeration> returnValue = Enumeration.getVector(rs);
        rs.close();
        stmt.close();
        return returnValue;
    }

    private static DistinctVector<Enumeration> getVector(ResultSet resultSet) throws SQLException {
        DistinctVector<Enumeration> set = new DistinctVector<Enumeration>();
        while (resultSet.next()) {
            int type = resultSet.getInt("type");
            String value = resultSet.getString("value");
            set.add(new Enumeration(type, value));
        }
        return set;
    }

    public String getValue() {
        return this.value;
    }

    public int getType() {
        return this.type;
    }

    public static Enumeration createNewEnumInDB(int type, String value) throws SQLException {
        PreparedStatement insertStmt = DBAccess.dbAccess.getPreparedStatement(insertString);
        insertStmt.setInt(1, type);
        insertStmt.setString(2, value);
        insertStmt.execute();
        insertStmt.close();
        AbstractTable.fireTableChangedEvent(9);
        return new Enumeration(type, value);
    }

    public boolean removeFromDB() throws SQLException {
        PreparedStatement checkStmt = null;
        switch (this.type) {
            case 0: {
                checkStmt = DBAccess.dbAccess.getPreparedStatement(checkForSalutationString);
                break;
            }
            case 1: {
                checkStmt = DBAccess.dbAccess.getPreparedStatement(checkForTitleString);
                break;
            }
            case 2: {
                checkStmt = DBAccess.dbAccess.getPreparedStatement(checkForCountryString);
                break;
            }
            case 3: {
                checkStmt = DBAccess.dbAccess.getPreparedStatement(checkForAnnexString);
            }
        }
        int i = 1;
        while (i <= 3) {
            checkStmt.setString(i, this.value);
            ++i;
        }
        if (checkStmt.executeQuery().next()) {
            return false;
        }
        PreparedStatement deleteStmt = DBAccess.dbAccess.getPreparedStatement(deleteString);
        deleteStmt.setInt(1, this.type);
        deleteStmt.setString(2, this.value);
        deleteStmt.execute();
        deleteStmt.close();
        AbstractTable.fireTableChangedEvent(9);
        return true;
    }

    public void setValueInDB(String value) throws SQLException {
        PreparedStatement[] updateOtherTablesStmts = new PreparedStatement[3];
        int i = 0;
        while (i < updateOtherTablesStmts.length) {
            switch (this.type) {
                case 0: {
                    updateOtherTablesStmts[i] = DBAccess.dbAccess.getPreparedStatement(updateSalutationStrings[i]);
                    break;
                }
                case 1: {
                    updateOtherTablesStmts[i] = DBAccess.dbAccess.getPreparedStatement(updateTitleStrings[i]);
                    break;
                }
                case 2: {
                    updateOtherTablesStmts[i] = DBAccess.dbAccess.getPreparedStatement(updateCountryStrings[i]);
                    break;
                }
                case 3: {
                    updateOtherTablesStmts[i] = DBAccess.dbAccess.getPreparedStatement(updateAnnexStrings[i]);
                }
            }
            ++i;
        }
        i = 0;
        while (i < updateOtherTablesStmts.length) {
            updateOtherTablesStmts[i].setString(1, value);
            updateOtherTablesStmts[i].setString(2, this.value);
            updateOtherTablesStmts[i].execute();
            ++i;
        }
        PreparedStatement updateStmt = DBAccess.dbAccess.getPreparedStatement(updateString);
        updateStmt.setString(1, value);
        updateStmt.setInt(2, this.type);
        updateStmt.setString(3, this.value);
        updateStmt.execute();
        updateStmt.close();
        this.value = value;
        AbstractTable.fireTableChangedEvent(12);
        AbstractTable.fireTableChangedEvent(5);
        AbstractTable.fireTableChangedEvent(13);
        AbstractTable.fireTableChangedEvent(9);
    }

    private static void addEnums(Combo combo, int type) {
        try {
            DistinctVector<Enumeration> set = Enumeration.getVectorFromDB(type);
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                combo.add(((Enumeration)iter.next()).value);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void addSalutationEnums(Combo salutationCombo) {
        Enumeration.addEnums(salutationCombo, 0);
    }

    public static void addTitleEnums(Combo titleCombo) {
        Enumeration.addEnums(titleCombo, 1);
    }

    public static void addCountryEnums(Combo countryCombo) {
        Enumeration.addEnums(countryCombo, 2);
    }

    public static void addAnnexEnums(Combo annexCombo) {
        Enumeration.addEnums(annexCombo, 3);
    }

    public static void insertSalutationStringInDB(String salutation) {
        try {
            Enumeration.createNewEnumInDB(0, salutation);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void insertTitleStringInDB(String title) {
        try {
            Enumeration.createNewEnumInDB(1, title);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void insertcountryStringInDB(String country) {
        try {
            Enumeration.createNewEnumInDB(2, country);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void insertAnnexStringInDB(String annex) {
        try {
            Enumeration.createNewEnumInDB(3, annex);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

