/*
 * Decompiled with CFR 0.152.
 */
package semorg.sql.tables;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import semorg.gui.util.Messages;
import semorg.sql.access.DBAccess;
import semorg.sql.tables.AbstractTable;
import semorg.sql.util.DBColumn;
import semorg.sql.util.KeyPair;
import semorg.sql.util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Conduct
extends AbstractTable {
    public static List<KeyPair> lockedIds = new ArrayList<KeyPair>();
    protected int lecturerId;
    protected int seminartypeId;
    private static String tableName = "conduct";
    protected static String conductInsertString = "INSERT INTO " + tableName + " VALUES(?, ?, ?, ?)";
    protected static String conductDeleteString = "DELETE FROM " + tableName + " WHERE lecturerid=? AND seminartypeid=?";
    private static String createTableSQLString = "CREATE TABLE IF NOT EXISTS `" + tableName + "` (" + "`lecturerid` integer NOT NULL," + "`seminartypeid` integer NOT NULL," + "`creationdate` timestamp NOT NULL default '0000-00-00 00:00:00'," + "`modificationdate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP," + "PRIMARY KEY  (`lecturerid`, `seminartypeid`)," + "CONSTRAINT `cond_lecturer_fk` FOREIGN KEY (`lecturerid`) REFERENCES `lecturer` (`person_fk`) ON DELETE CASCADE, " + "CONSTRAINT `cond_semtype_fk` FOREIGN KEY (`seminartypeid`) REFERENCES `seminartype` (`id_pk`) ON DELETE CASCADE)";

    public Conduct(int lecturerId, int seminartypeId, Timestamp creationDate, Timestamp modificationDate) {
        super(creationDate, modificationDate);
        this.lecturerId = lecturerId;
        this.seminartypeId = seminartypeId;
    }

    public static boolean tableOK() {
        return AbstractTable.tableOK(tableName);
    }

    public static void createConductTable(Statement statement) throws SQLException {
        statement.execute(createTableSQLString);
        statement.close();
    }

    public void insertIntoDB() throws SQLException {
        PreparedStatement insertStmt = DBAccess.dbAccess.getPreparedStatement(conductInsertString);
        insertStmt.setInt(1, this.lecturerId);
        insertStmt.setInt(2, this.seminartypeId);
        insertStmt.setTimestamp(3, Utility.convertToTimestamp(this.creationDate));
        insertStmt.setTimestamp(4, Utility.convertToTimestamp(this.modificationDate));
        insertStmt.executeUpdate();
        insertStmt.close();
        AbstractTable.fireTableChangedEvent(8);
    }

    public void deleteFromDB() throws SQLException {
        PreparedStatement deleteStmt = DBAccess.dbAccess.getPreparedStatement(conductDeleteString);
        deleteStmt.setInt(1, this.lecturerId);
        deleteStmt.setInt(2, this.seminartypeId);
        deleteStmt.executeUpdate();
        deleteStmt.close();
        AbstractTable.fireTableChangedEvent(8);
    }

    public static Vector<DBColumn> getColumns() {
        Vector<DBColumn> columns = new Vector<DBColumn>();
        columns.add(new DBColumn("lecturerid", Messages.getString("MAP.Conduct.LecturerId"), Integer.class));
        columns.add(new DBColumn("seminartypeid", Messages.getString("MAP.Conduct.SeminarTypeId"), Integer.class));
        columns.addAll(AbstractTable.getColumns(""));
        return columns;
    }

    public int getLecturerId() {
        return this.lecturerId;
    }

    public int getSeminartypeId() {
        return this.seminartypeId;
    }
}

