/*
 * Decompiled with CFR 0.152.
 */
package semorg.sql.tables;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import semorg.gui.util.Messages;
import semorg.sql.access.DBAccess;
import semorg.sql.tables.AbstractTable;
import semorg.sql.tables.Presentation;
import semorg.sql.util.DBColumn;
import semorg.sql.util.DBConstraint;
import semorg.sql.util.DistinctVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompanyInternalPresentation
extends Presentation {
    private Float packagePrice;
    protected Integer maxEntrants;
    private String companyInternalPresentationCurrentEntrantsString = "SELECT COUNT(*) FROM companybooking WHERE presentationid=?";
    private static String tableName = "companyinternalpresentation";
    private static String queryString = "SELECT pr.id_pk, pr.seminartype_fk, pr.duration, pr.beginningday, pr.endingday, pr.startingtime, pr.endingtime, pr.firststartingtime, pr.lastendingtime, pr.location, pr.street, pr.zipcode, pr.city, pr.country, pr.annex, pr.cancelled, cipr.packageprice, cipr.maxentrants, pr.creationdate, pr.modificationdate FROM presentation pr, seminartype s, " + tableName + " cipr " + "WHERE pr.id_pk=cipr.presentation_fk AND s.id_pk=pr.seminartype_fk";
    private static String companyInternalPresentationInsertString = "INSERT INTO " + tableName + " VALUES(?, ?, ?)";
    private static String companyInternalPresentationUpdateString = "UPDATE " + tableName + " SET packageprice=?, maxentrants=? WHERE presentation_fk=?";
    private static String createTableSQLString = "CREATE TABLE IF NOT EXISTS `" + tableName + "` (" + "`presentation_fk` integer NOT NULL," + "`packageprice` float," + "`maxentrants` integer," + "PRIMARY KEY  (`presentation_fk`)," + "CONSTRAINT `companyinternalpresentation_fk` FOREIGN KEY (`presentation_fk`) REFERENCES `presentation` (`id_pk`) ON DELETE CASCADE)";

    public CompanyInternalPresentation(int id, int seminarTypeId, Integer duration, Date beginningDay, Date endingDay, Time startingTime, Time endingTime, Time firstStartingTime, Time lastEndingTime, String location, String street, String zipCode, String city, String country, String annex, boolean cancelled, Float packagePrice, Integer maxEntrants, Timestamp creationDate, Timestamp modificationDate) throws SQLException {
        super(id, seminarTypeId, duration, beginningDay, endingDay, startingTime, endingTime, firstStartingTime, lastEndingTime, location, street, zipCode, city, country, annex, cancelled, creationDate, modificationDate);
        this.packagePrice = packagePrice;
        this.maxEntrants = maxEntrants;
    }

    private static DistinctVector<CompanyInternalPresentation> getVector(ResultSet resultSet) {
        DistinctVector<CompanyInternalPresentation> set = new DistinctVector<CompanyInternalPresentation>();
        try {
            while (resultSet.next()) {
                int id = resultSet.getInt("id_pk");
                int seminarTypeId = resultSet.getInt("seminartype_fk");
                Integer duration = resultSet.getInt("duration");
                if (resultSet.wasNull()) {
                    duration = null;
                }
                java.sql.Date beginningDay = resultSet.getDate("beginningday");
                java.sql.Date endingDay = resultSet.getDate("endingday");
                Time startingTime = resultSet.getTime("startingtime");
                Time endingTime = resultSet.getTime("endingtime");
                Time firstStartingTime = resultSet.getTime("firststartingtime");
                Time lastEndingTime = resultSet.getTime("lastendingtime");
                String location = resultSet.getString("location");
                String street = resultSet.getString("street");
                String zipCode = resultSet.getString("zipcode");
                String city = resultSet.getString("city");
                String country = resultSet.getString("country");
                String annex = resultSet.getString("annex");
                boolean cancelled = resultSet.getBoolean("cancelled");
                Float packagePrice = Float.valueOf(resultSet.getFloat("packageprice"));
                if (resultSet.wasNull()) {
                    packagePrice = null;
                }
                Integer maxEntrants = resultSet.getInt("maxentrants");
                if (resultSet.wasNull()) {
                    maxEntrants = null;
                }
                Timestamp creationDate = resultSet.getTimestamp("creationdate");
                Timestamp modificationDate = resultSet.getTimestamp("modificationdate");
                set.add(new CompanyInternalPresentation(id, seminarTypeId, duration, beginningDay, endingDay, startingTime, endingTime, firstStartingTime, lastEndingTime, location, street, zipCode, city, country, annex, cancelled, packagePrice, maxEntrants, creationDate, modificationDate));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return set;
    }

    public static DistinctVector<CompanyInternalPresentation> getVectorFromDB(Vector<DBConstraint> additionalConstraints, String sortString) throws SQLException {
        PreparedStatement stmt = AbstractTable.createExtendedQueryString(queryString, additionalConstraints, sortString);
        ResultSet rs = stmt.executeQuery();
        DistinctVector<CompanyInternalPresentation> returnValue = CompanyInternalPresentation.getVector(rs);
        rs.close();
        stmt.close();
        return returnValue;
    }

    public static boolean tableOK() {
        return AbstractTable.tableOK(tableName);
    }

    public static void createCompanyInternalPresentationTable(Statement statement) throws SQLException {
        statement.execute(createTableSQLString);
        statement.close();
    }

    @Override
    public int insertIntoDB() throws SQLException {
        super.insertIntoDB();
        PreparedStatement insertStmt = DBAccess.dbAccess.getPreparedStatement(companyInternalPresentationInsertString);
        insertStmt.setInt(1, this.id);
        if (this.packagePrice != null) {
            insertStmt.setFloat(2, this.packagePrice.floatValue());
        } else {
            insertStmt.setNull(2, 6);
        }
        if (this.maxEntrants != null) {
            insertStmt.setInt(3, this.maxEntrants);
        } else {
            insertStmt.setNull(3, 4);
        }
        insertStmt.executeUpdate();
        insertStmt.close();
        AbstractTable.fireTableChangedEvent(7);
        return this.id;
    }

    @Override
    public void updateDB() throws SQLException {
        super.updateDB();
        PreparedStatement updateStmt = DBAccess.dbAccess.getPreparedStatement(companyInternalPresentationUpdateString);
        if (this.packagePrice != null) {
            updateStmt.setFloat(1, this.packagePrice.floatValue());
        } else {
            updateStmt.setNull(1, 6);
        }
        if (this.maxEntrants != null) {
            updateStmt.setInt(2, this.maxEntrants);
        } else {
            updateStmt.setNull(2, 4);
        }
        updateStmt.setInt(3, this.id);
        updateStmt.executeUpdate();
        updateStmt.close();
        AbstractTable.fireTableChangedEvent(7);
    }

    public static Vector<DBColumn> getColumns() {
        Vector<DBColumn> columns = Presentation.getColumns();
        columns.add(columns.size() - 2, new DBColumn("cipr.packageprice", Messages.getString("MAP.CompanyInternalPresentation.PackagePrize"), Float.class));
        columns.add(columns.size() - 2, new DBColumn("pr.maxentrants", Messages.getString("MAP.CompanyInternalPresentation.MaxEntrants"), Integer.class));
        return columns;
    }

    public static Vector<DBColumn> getColumnsWithSemtype() {
        Vector<DBColumn> columns = CompanyInternalPresentation.getColumns();
        columns.set(1, new DBColumn("s.shorttitle", Messages.getString("MAP.Presentation.SeminarTypeST"), String.class));
        return columns;
    }

    public static CompanyInternalPresentation getNext(int currentId) {
        CompanyInternalPresentation returnValue = null;
        ResultSet rs = AbstractTable.getNext(queryString, CompanyInternalPresentation.getColumns().get(0), currentId);
        if (rs != null) {
            returnValue = (CompanyInternalPresentation)CompanyInternalPresentation.getVector(rs).iterator().next();
            try {
                Statement producingStatement = rs.getStatement();
                rs.close();
                if (producingStatement != null) {
                    producingStatement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return returnValue;
    }

    public static CompanyInternalPresentation getPrevious(int currentId) {
        CompanyInternalPresentation returnValue = null;
        ResultSet rs = AbstractTable.getPrevious(queryString, CompanyInternalPresentation.getColumns().get(0), currentId);
        if (rs != null) {
            returnValue = (CompanyInternalPresentation)CompanyInternalPresentation.getVector(rs).iterator().next();
            try {
                Statement producingStatement = rs.getStatement();
                rs.close();
                if (producingStatement != null) {
                    producingStatement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return returnValue;
    }

    public static CompanyInternalPresentation getCompanyInternalPresentation(int presentationId) throws SQLException {
        Vector<DBConstraint> keyConstraint = new Vector<DBConstraint>();
        keyConstraint.add(new DBConstraint(CompanyInternalPresentation.getColumns().get(0).getInternalColumnName(), 0, new Integer(presentationId), 0));
        DistinctVector<CompanyInternalPresentation> presentations = CompanyInternalPresentation.getVectorFromDB(keyConstraint, null);
        return (CompanyInternalPresentation)presentations.iterator().next();
    }

    public int getCurrentEntrantsCount() throws SQLException {
        PreparedStatement entrantsCountStmt = DBAccess.dbAccess.getPreparedStatement(this.companyInternalPresentationCurrentEntrantsString);
        entrantsCountStmt.setInt(1, this.id);
        ResultSet res = entrantsCountStmt.executeQuery();
        if (res.next()) {
            int val = res.getInt(1);
            res.close();
            entrantsCountStmt.close();
            return val;
        }
        res.close();
        entrantsCountStmt.close();
        throw new SQLException();
    }

    public Integer getMaxEntrants() {
        return this.maxEntrants;
    }

    public void setMaxEntrants(Integer maxEntrants) {
        this.maxEntrants = maxEntrants;
    }

    public Float getPackagePrice() {
        return this.packagePrice;
    }

    public void setPackagePrice(Float packagePrice) {
        this.packagePrice = packagePrice;
    }
}

