/*
 * Decompiled with CFR 0.152.
 */
package semorg.sql.tables;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import semorg.gui.util.Messages;
import semorg.sql.access.DBAccess;
import semorg.sql.tables.AbstractTable;
import semorg.sql.tables.Booking;
import semorg.sql.util.DBColumn;
import semorg.sql.util.DBConstraint;
import semorg.sql.util.DistinctVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompanyBooking
extends Booking {
    private int presentationId;
    private int companyId;
    private static String tableName = "companybooking";
    private static String queryString = "SELECT b.id_pk, b.enrolled, b.confirmed, b.billed, b.signedoff, b.messaged, cb.presentationid, cb.companyid, b.creationdate, b.modificationdate FROM booking b, " + tableName + " cb " + "WHERE b.id_pk=cb.booking_fk";
    private static String companyBookingInsertString = "INSERT INTO " + tableName + " VALUES(?, ?, ?)";
    private static String companyBookingUpdateString = "UPDATE " + tableName + " " + "SET presentationid=?, companyid=? " + "WHERE booking_fk=?";
    private static String createTableSQLString = "CREATE TABLE IF NOT EXISTS `" + tableName + "` (" + "`booking_fk` integer NOT NULL," + "`presentationid` integer NOT NULL," + "`companyid` integer NOT NULL," + "PRIMARY KEY  (`booking_fk`)," + "CONSTRAINT `companybooking_fk` FOREIGN KEY (`booking_fk`) REFERENCES `booking` (`id_pk`) ON DELETE CASCADE, " + "CONSTRAINT `cipres_fk` FOREIGN KEY (`presentationid`) REFERENCES `companyinternalpresentation` (`presentation_fk`) ON DELETE CASCADE, " + "CONSTRAINT `company_fk` FOREIGN KEY (`companyid`) REFERENCES `company` (`id_pk`) ON DELETE CASCADE)";

    public CompanyBooking(int id, Date enrolled, Date confirmed, Date billed, Date signedOff, Date messaged, int presentationId, int companyId, Timestamp creationDate, Timestamp modificationDate) throws SQLException {
        super(id, enrolled, confirmed, billed, signedOff, messaged, creationDate, modificationDate);
        this.presentationId = presentationId;
        this.companyId = companyId;
    }

    private static DistinctVector<CompanyBooking> getVector(ResultSet resultSet) {
        DistinctVector<CompanyBooking> set = new DistinctVector<CompanyBooking>();
        try {
            while (resultSet.next()) {
                int id = resultSet.getInt("id_pk");
                java.sql.Date enrolled = resultSet.getDate("enrolled");
                java.sql.Date confirmed = resultSet.getDate("confirmed");
                java.sql.Date billed = resultSet.getDate("billed");
                java.sql.Date signedOff = resultSet.getDate("signedOff");
                java.sql.Date messaged = resultSet.getDate("messaged");
                int presentationId = resultSet.getInt("presentationid");
                int companyId = resultSet.getInt("companyid");
                Timestamp creationDate = resultSet.getTimestamp("creationdate");
                Timestamp modificationDate = resultSet.getTimestamp("modificationdate");
                set.add(new CompanyBooking(id, enrolled, confirmed, billed, signedOff, messaged, presentationId, companyId, creationDate, modificationDate));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return set;
    }

    public static DistinctVector<CompanyBooking> getVectorFromDB(Vector<DBConstraint> additionalConstraints, String sortString) throws SQLException {
        PreparedStatement stmt = AbstractTable.createExtendedQueryString(queryString, additionalConstraints, sortString);
        ResultSet rs = stmt.executeQuery();
        DistinctVector<CompanyBooking> returnValue = CompanyBooking.getVector(rs);
        rs.close();
        stmt.close();
        return returnValue;
    }

    public static boolean tableOK() {
        return AbstractTable.tableOK(tableName);
    }

    public static void createCompanyBookingTable(Statement statement) throws SQLException {
        statement.execute(createTableSQLString);
        statement.close();
    }

    @Override
    public int insertIntoDB() throws SQLException {
        super.insertIntoDB();
        PreparedStatement insertStmt = DBAccess.dbAccess.getPreparedStatement(companyBookingInsertString);
        insertStmt.setInt(1, this.id);
        insertStmt.setInt(2, this.presentationId);
        insertStmt.setInt(3, this.companyId);
        insertStmt.executeUpdate();
        insertStmt.close();
        AbstractTable.fireTableChangedEvent(6);
        return this.id;
    }

    @Override
    public void updateDB() throws SQLException {
        super.updateDB();
        PreparedStatement updateAssoStmt = DBAccess.dbAccess.getPreparedStatement(companyBookingUpdateString);
        updateAssoStmt.setInt(1, this.presentationId);
        updateAssoStmt.setInt(2, this.companyId);
        updateAssoStmt.setInt(3, this.id);
        updateAssoStmt.executeUpdate();
        updateAssoStmt.close();
        AbstractTable.fireTableChangedEvent(6);
    }

    public static Vector<DBColumn> getColumns() {
        Vector<DBColumn> columns = Booking.getColumns();
        columns.add(columns.size() - 2, new DBColumn("cb.presentationid", Messages.getString("MAP.CompanyBooking.PresentationId"), Integer.class));
        columns.add(columns.size() - 2, new DBColumn("cb.companyid", Messages.getString("MAP.CompanyBooking.CompanyId"), Integer.class));
        return columns;
    }

    public static CompanyBooking getNext(int currentId) {
        CompanyBooking returnValue = null;
        ResultSet rs = AbstractTable.getNext(queryString, CompanyBooking.getColumns().get(0), currentId);
        if (rs != null) {
            returnValue = (CompanyBooking)CompanyBooking.getVector(rs).iterator().next();
            try {
                Statement producingStatement = rs.getStatement();
                rs.close();
                if (producingStatement != null) {
                    producingStatement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return returnValue;
    }

    public static CompanyBooking getPrevious(int currentId) {
        CompanyBooking returnValue = null;
        ResultSet rs = AbstractTable.getPrevious(queryString, CompanyBooking.getColumns().get(0), currentId);
        if (rs != null) {
            returnValue = (CompanyBooking)CompanyBooking.getVector(rs).iterator().next();
            try {
                Statement producingStatement = rs.getStatement();
                rs.close();
                if (producingStatement != null) {
                    producingStatement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return returnValue;
    }

    public int getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(int companyId) {
        this.companyId = companyId;
    }

    public int getPresentationId() {
        return this.presentationId;
    }

    public void setPresentationId(int presentationId) {
        this.presentationId = presentationId;
    }

    public static DistinctVector<CompanyBooking> getBookingsOfCompany(int companyId) throws SQLException {
        String extendedQueryString = String.valueOf(queryString) + " AND cb.companyid=?";
        PreparedStatement stmt = DBAccess.dbAccess.getPreparedStatement(extendedQueryString);
        stmt.setInt(1, companyId);
        ResultSet rs = stmt.executeQuery();
        DistinctVector<CompanyBooking> returnValue = CompanyBooking.getVector(rs);
        rs.close();
        stmt.close();
        return returnValue;
    }

    public static DistinctVector<CompanyBooking> getBookingsForPresentation(int presentationId) throws SQLException {
        String extendedQueryString = String.valueOf(queryString) + " AND cb.presentationid=?";
        PreparedStatement stmt = DBAccess.dbAccess.getPreparedStatement(extendedQueryString);
        stmt.setInt(1, presentationId);
        ResultSet rs = stmt.executeQuery();
        DistinctVector<CompanyBooking> returnValue = CompanyBooking.getVector(rs);
        rs.close();
        stmt.close();
        return returnValue;
    }

    public static CompanyBooking getCompanyBooking(int bookingId) throws SQLException {
        Vector<DBConstraint> keyConstraint = new Vector<DBConstraint>();
        keyConstraint.add(new DBConstraint(CompanyBooking.getColumns().get(0).getInternalColumnName(), 0, new Integer(bookingId), 0));
        DistinctVector<CompanyBooking> clients = CompanyBooking.getVectorFromDB(keyConstraint, null);
        return (CompanyBooking)clients.iterator().next();
    }
}

