/*
 * Decompiled with CFR 0.152.
 */
package semorg.sql.tables;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import semorg.sql.access.DBAccess;
import semorg.sql.tables.AbstractTable;
import semorg.sql.tables.Enumeration;
import semorg.sql.tables.SimpleIDKey;
import semorg.sql.util.DBColumn;
import semorg.sql.util.DBConstraint;
import semorg.sql.util.DistinctVector;
import semorg.sql.util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Company
extends AbstractTable
implements SimpleIDKey {
    public static List<Integer> lockedIds = new ArrayList<Integer>();
    protected int id;
    protected String shortName;
    protected String salutation;
    protected String title;
    protected String firstname;
    protected String name;
    protected String street;
    protected String zipCode;
    protected String city;
    protected String country;
    protected String annex;
    protected String phone;
    protected String mobile;
    protected String fax;
    protected String email;
    protected String cpSalutation;
    protected String cpTitle;
    protected String cpFirstname;
    protected String cpName;
    protected String cpPhone;
    protected String cpMobile;
    protected String cpFax;
    protected String cpEmail;
    protected String cpDepartment;
    protected java.util.Date cpBirthDay;
    protected String cpTask;
    protected String shortInfo;
    protected String notices;
    protected Float turnover;
    protected java.util.Date customerSince;
    private static String tableName = "company";
    protected static String companyInsertString = "INSERT INTO " + tableName + " " + "VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " + "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " + "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static String createTableSQLString = "CREATE TABLE IF NOT EXISTS `" + tableName + "` (" + "`id_pk` integer NOT NULL auto_increment," + "`shortname` varchar(10) NOT NULL," + "`salutation` varchar(13) NOT NULL," + "`title` varchar(13)," + "`firstname` varchar(30)," + "`name` varchar(30) NOT NULL," + "`street` varchar(50)," + "`zipcode` varchar(5)," + "`city` varchar(30)," + "`country` varchar(13)," + "`annex` varchar(13)," + "`phone` varchar(20)," + "`mobile` varchar(20)," + "`fax` varchar(20)," + "`email` varchar(256)," + "`cpsalutation` varchar(13) NOT NULL," + "`cptitle` varchar(13)," + "`cpfirstname` varchar(30)," + "`cpname` varchar(30) NOT NULL," + "`cpphone` varchar(20)," + "`cpmobile` varchar(20)," + "`cpfax` varchar(20)," + "`cpemail` varchar(256)," + "`cpdepartment` varchar(30)," + "`cpbirthday` date," + "`cptask` varchar(30)," + "`shortinfo` varchar(200)," + "`notices` varchar(200)," + "`turnover` float," + "`customersince` date," + "`creationdate` timestamp NOT NULL default '0000-00-00 00:00:00'," + "`modificationdate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP," + "PRIMARY KEY  (`id_pk`) )";
    protected static String companyUpdateString = "UPDATE " + tableName + " SET " + "shortname=?, salutation=?, title=?, firstname=?, name=?, " + "street=?, zipcode=?, city=?, country=?, annex=?, " + "phone=?, mobile=?, fax=?, email=?, cpsalutation=?, cptitle=?, " + "cpfirstname=?, cpname=?, cpphone=?, cpmobile=?, " + "cpfax=?, cpemail=?, cpdepartment=?, cpbirthday=?, cptask=?, " + "shortinfo=?, notices=?, turnover=?, customersince=?, " + "modificationdate=? WHERE id_pk=?";
    private static String queryString = "SELECT id_pk, shortname, salutation, title,firstname, name, street, zipcode, city, country, annex, phone, mobile, fax, email, cpsalutation, cptitle, cpfirstname, cpname, cpphone, cpmobile, cpfax, cpemail, cpdepartment, cpbirthday, cptask, shortinfo, notices, turnover, customersince, creationdate, modificationdate FROM " + tableName + " WHERE true";

    public Company(int id, String shortName, String salutation, String title, String firstname, String name, String street, String zipCode, String city, String country, String annex, String phone, String mobile, String fax, String email, String cpSalutation, String cpTitle, String cpFirstname, String cpName, String cpPhone, String cpMobile, String cpFax, String cpEmail, String cpDepartment, java.util.Date cpBirthDay, String cpTask, String shortInfo, String notices, Float turnover, java.util.Date customerSince, Timestamp creationDate, Timestamp modificationDate) {
        super(creationDate, modificationDate);
        this.id = id;
        this.shortName = shortName;
        this.salutation = salutation;
        this.title = title;
        this.firstname = firstname;
        this.name = name;
        this.street = street;
        this.zipCode = zipCode;
        this.city = city;
        this.country = country;
        this.annex = annex;
        this.phone = phone;
        this.mobile = mobile;
        this.fax = fax;
        this.email = email;
        this.cpSalutation = cpSalutation;
        this.cpTitle = cpTitle;
        this.cpFirstname = cpFirstname;
        this.cpName = cpName;
        this.cpPhone = cpPhone;
        this.cpMobile = cpMobile;
        this.cpFax = cpFax;
        this.cpEmail = cpEmail;
        this.cpDepartment = cpDepartment;
        this.cpBirthDay = cpBirthDay;
        this.cpTask = cpTask;
        this.shortInfo = shortInfo;
        this.notices = notices;
        this.turnover = turnover;
        this.customerSince = customerSince;
        this.creationDate = creationDate;
        this.modificationDate = modificationDate;
    }

    public static boolean tableOK() {
        return AbstractTable.tableOK(tableName);
    }

    public static void createCompanyTable(Statement statement) throws SQLException {
        statement.execute(createTableSQLString);
        statement.close();
    }

    public int insertIntoDB() throws SQLException {
        PreparedStatement insertStmt = DBAccess.dbAccess.getPreparedStatement(companyInsertString);
        insertStmt.setNull(1, 4);
        insertStmt.setString(2, this.shortName);
        insertStmt.setString(3, this.salutation);
        insertStmt.setString(4, this.title);
        insertStmt.setString(5, this.firstname);
        insertStmt.setString(6, this.name);
        insertStmt.setString(7, this.street);
        insertStmt.setString(8, this.zipCode);
        insertStmt.setString(9, this.city);
        insertStmt.setString(10, this.country);
        insertStmt.setString(11, this.annex);
        insertStmt.setString(12, this.phone);
        insertStmt.setString(13, this.mobile);
        insertStmt.setString(14, this.fax);
        insertStmt.setString(15, this.email);
        insertStmt.setString(16, this.cpSalutation);
        insertStmt.setString(17, this.cpTitle);
        insertStmt.setString(18, this.cpFirstname);
        insertStmt.setString(19, this.cpName);
        insertStmt.setString(20, this.cpPhone);
        insertStmt.setString(21, this.cpMobile);
        insertStmt.setString(22, this.cpFax);
        insertStmt.setString(23, this.cpEmail);
        insertStmt.setString(24, this.cpDepartment);
        if (this.cpBirthDay != null) {
            insertStmt.setDate(25, Utility.convertToSQLDate(this.cpBirthDay));
        } else {
            insertStmt.setNull(25, 91);
        }
        insertStmt.setString(26, this.cpTask);
        insertStmt.setString(27, this.shortInfo);
        insertStmt.setString(28, this.notices);
        if (this.turnover != null) {
            insertStmt.setFloat(29, this.turnover.floatValue());
        } else {
            insertStmt.setNull(29, 6);
        }
        if (this.customerSince != null) {
            insertStmt.setDate(30, Utility.convertToSQLDate(this.customerSince));
        } else {
            insertStmt.setNull(30, 91);
        }
        insertStmt.setTimestamp(31, Utility.convertToTimestamp(this.creationDate));
        insertStmt.setTimestamp(32, Utility.convertToTimestamp(this.modificationDate));
        insertStmt.executeUpdate();
        ResultSet rs = insertStmt.getGeneratedKeys();
        if (!rs.next()) {
            throw new SQLException();
        }
        this.id = rs.getInt(1);
        rs.close();
        insertStmt.close();
        if (this.salutation.length() > 0) {
            Enumeration.insertSalutationStringInDB(this.salutation);
        }
        if (this.title.length() > 0) {
            Enumeration.insertTitleStringInDB(this.title);
        }
        if (this.country.length() > 0) {
            Enumeration.insertcountryStringInDB(this.country);
        }
        if (this.annex.length() > 0) {
            Enumeration.insertAnnexStringInDB(this.annex);
        }
        if (this.cpSalutation.length() > 0) {
            Enumeration.insertSalutationStringInDB(this.cpSalutation);
        }
        if (this.cpTitle.length() > 0) {
            Enumeration.insertTitleStringInDB(this.cpTitle);
        }
        AbstractTable.fireTableChangedEvent(5);
        return this.id;
    }

    public void updateDB() throws SQLException {
        PreparedStatement updateStmt = DBAccess.dbAccess.getPreparedStatement(companyUpdateString);
        updateStmt.setString(1, this.shortName);
        updateStmt.setString(2, this.salutation);
        updateStmt.setString(3, this.title);
        updateStmt.setString(4, this.firstname);
        updateStmt.setString(5, this.name);
        updateStmt.setString(6, this.street);
        updateStmt.setString(7, this.zipCode);
        updateStmt.setString(8, this.city);
        updateStmt.setString(9, this.country);
        updateStmt.setString(10, this.annex);
        updateStmt.setString(11, this.phone);
        updateStmt.setString(12, this.mobile);
        updateStmt.setString(13, this.fax);
        updateStmt.setString(14, this.email);
        updateStmt.setString(15, this.cpSalutation);
        updateStmt.setString(16, this.cpTitle);
        updateStmt.setString(17, this.cpFirstname);
        updateStmt.setString(18, this.cpName);
        updateStmt.setString(19, this.cpPhone);
        updateStmt.setString(20, this.cpMobile);
        updateStmt.setString(21, this.cpFax);
        updateStmt.setString(22, this.cpEmail);
        updateStmt.setString(23, this.cpDepartment);
        if (this.cpBirthDay != null) {
            updateStmt.setDate(24, Utility.convertToSQLDate(this.cpBirthDay));
        } else {
            updateStmt.setNull(24, 91);
        }
        updateStmt.setString(25, this.cpTask);
        updateStmt.setString(26, this.shortInfo);
        updateStmt.setString(27, this.notices);
        if (this.turnover != null) {
            updateStmt.setFloat(28, this.turnover.floatValue());
        } else {
            updateStmt.setNull(28, 6);
        }
        if (this.customerSince != null) {
            updateStmt.setDate(29, Utility.convertToSQLDate(this.customerSince));
        } else {
            updateStmt.setNull(29, 91);
        }
        updateStmt.setTimestamp(30, new Timestamp(System.currentTimeMillis()));
        updateStmt.setInt(31, this.id);
        updateStmt.executeUpdate();
        updateStmt.close();
        if (this.salutation.length() > 0) {
            Enumeration.insertSalutationStringInDB(this.salutation);
        }
        if (this.title.length() > 0) {
            Enumeration.insertTitleStringInDB(this.title);
        }
        if (this.country.length() > 0) {
            Enumeration.insertcountryStringInDB(this.country);
        }
        if (this.annex.length() > 0) {
            Enumeration.insertAnnexStringInDB(this.annex);
        }
        if (this.cpSalutation.length() > 0) {
            Enumeration.insertSalutationStringInDB(this.cpSalutation);
        }
        if (this.cpTitle.length() > 0) {
            Enumeration.insertTitleStringInDB(this.cpTitle);
        }
        AbstractTable.fireTableChangedEvent(5);
    }

    public static void removeFromDB(Iterable selectedElements) throws SQLException {
        String deleteString = "DELETE FROM " + tableName + " WHERE ";
        Iterator it = selectedElements.iterator();
        int idToDelete = ((Company)it.next()).getId();
        deleteString = String.valueOf(deleteString) + "id_pk=" + idToDelete + " ";
        while (it.hasNext()) {
            idToDelete = ((Company)it.next()).getId();
            deleteString = String.valueOf(deleteString) + "OR id_pk=" + idToDelete + " ";
        }
        Statement stmt = DBAccess.dbAccess.getStatement();
        stmt.executeUpdate(deleteString);
        stmt.close();
        AbstractTable.fireTableChangedEvent(5);
        AbstractTable.fireTableChangedEvent(2);
        AbstractTable.fireTableChangedEvent(6);
    }

    private static DistinctVector<Company> getVector(ResultSet resultSet) {
        DistinctVector<Company> set = new DistinctVector<Company>();
        try {
            while (resultSet.next()) {
                int id = resultSet.getInt("id_pk");
                String shortName = resultSet.getString("shortname");
                String salutation = resultSet.getString("salutation");
                String title = resultSet.getString("title");
                String firstname = resultSet.getString("firstname");
                String name = resultSet.getString("name");
                String street = resultSet.getString("street");
                String zipCode = resultSet.getString("zipcode");
                String city = resultSet.getString("city");
                String country = resultSet.getString("country");
                String annex = resultSet.getString("annex");
                String phone = resultSet.getString("phone");
                String mobile = resultSet.getString("mobile");
                String fax = resultSet.getString("fax");
                String email = resultSet.getString("email");
                String cpSalutation = resultSet.getString("cpsalutation");
                String cpTitle = resultSet.getString("cptitle");
                String cpFirstname = resultSet.getString("cpfirstname");
                String cpName = resultSet.getString("cpname");
                String cpPhone = resultSet.getString("cpphone");
                String cpMobile = resultSet.getString("cpmobile");
                String cpFax = resultSet.getString("cpfax");
                String cpEmail = resultSet.getString("cpemail");
                String cpDepartment = resultSet.getString("cpdepartment");
                Date cpBirthDay = resultSet.getDate("cpbirthday");
                String cpTask = resultSet.getString("cptask");
                String shortInfo = resultSet.getString("shortinfo");
                String notices = resultSet.getString("notices");
                Float turnover = Float.valueOf(resultSet.getFloat("turnover"));
                if (resultSet.wasNull()) {
                    turnover = null;
                }
                Date customerSince = resultSet.getDate("customersince");
                Timestamp creationDate = resultSet.getTimestamp("creationdate");
                Timestamp modificationDate = resultSet.getTimestamp("modificationdate");
                set.add(new Company(id, shortName, salutation, title, firstname, name, street, zipCode, city, country, annex, phone, mobile, fax, email, cpSalutation, cpTitle, cpFirstname, cpName, cpPhone, cpMobile, cpFax, cpEmail, cpDepartment, cpBirthDay, cpTask, shortInfo, notices, turnover, customerSince, creationDate, modificationDate));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return set;
    }

    public static DistinctVector<Company> getVectorFromDB(Vector<DBConstraint> additionalConstraints, String sortString) throws SQLException {
        PreparedStatement stmt = AbstractTable.createExtendedQueryString(queryString, additionalConstraints, sortString);
        ResultSet rs = stmt.executeQuery();
        DistinctVector<Company> returnValue = Company.getVector(rs);
        rs.close();
        stmt.close();
        return returnValue;
    }

    public static Vector<DBColumn> getColumns() {
        Vector<DBColumn> columns = new Vector<DBColumn>();
        columns.add(new DBColumn("id_pk", "Nummer", Integer.class));
        columns.add(new DBColumn("shortname", "Kurzname", String.class));
        columns.add(new DBColumn("salutation", "Firma-Anrede", String.class));
        columns.add(new DBColumn("title", "Firma-Titel", String.class));
        columns.add(new DBColumn("firstname", "Firma-Vorname", String.class));
        columns.add(new DBColumn("name", "Firma-Name", String.class));
        columns.add(new DBColumn("street", "Firma-Strasse", String.class));
        columns.add(new DBColumn("zipcode", "Firma-PLZ", String.class));
        columns.add(new DBColumn("city", "Firma-Stadt", String.class));
        columns.add(new DBColumn("country", "Firma-Land", String.class));
        columns.add(new DBColumn("annex", "Firma-Zusatz", String.class));
        columns.add(new DBColumn("phone", "Firma-Telefon", String.class));
        columns.add(new DBColumn("mobile", "Firma-Handy", String.class));
        columns.add(new DBColumn("fax", "Firma-Fax", String.class));
        columns.add(new DBColumn("email", "Firma-Email", String.class));
        columns.add(new DBColumn("cpsalutation", "Partner-Anrede", String.class));
        columns.add(new DBColumn("cptitle", "Partner-Titel", String.class));
        columns.add(new DBColumn("cpfirstname", "Partner-Vorname", String.class));
        columns.add(new DBColumn("cpname", "Partner-Name", String.class));
        columns.add(new DBColumn("cpphone", "Partner-Telefon", String.class));
        columns.add(new DBColumn("cpmobile", "Partner-Handy", String.class));
        columns.add(new DBColumn("cpfax", "Partner-Fax", String.class));
        columns.add(new DBColumn("cpemail", "Partner-Email", String.class));
        columns.add(new DBColumn("cpdepartment", "Partner-Abteilung", String.class));
        columns.add(new DBColumn("cpbirthday", "Partner-Geburtstag", java.util.Date.class));
        columns.add(new DBColumn("cptask", "Partner-Funktion", String.class));
        columns.add(new DBColumn("shortinfo", "Kurzmitteilung", String.class));
        columns.add(new DBColumn("notices", "Notizen", String.class));
        columns.add(new DBColumn("turnover", "Umsatz", Float.class));
        columns.add(new DBColumn("customersince", "Kunde seit", java.util.Date.class));
        columns.addAll(AbstractTable.getColumns(""));
        return columns;
    }

    public static Company getNext(int lecturerId) {
        Company returnValue = null;
        ResultSet rs = AbstractTable.getNext(queryString, Company.getColumns().get(0), lecturerId);
        if (rs != null) {
            returnValue = (Company)Company.getVector(rs).iterator().next();
            try {
                Statement producingStatement = rs.getStatement();
                rs.close();
                if (producingStatement != null) {
                    producingStatement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return returnValue;
    }

    public static Company getPrevious(int lecturerId) {
        Company returnValue = null;
        ResultSet rs = AbstractTable.getPrevious(queryString, Company.getColumns().get(0), lecturerId);
        if (rs != null) {
            returnValue = (Company)Company.getVector(rs).iterator().next();
            try {
                Statement producingStatement = rs.getStatement();
                rs.close();
                if (producingStatement != null) {
                    producingStatement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return returnValue;
    }

    public static Company getCompany(int companyId) throws SQLException {
        Vector<DBConstraint> keyConstraint = new Vector<DBConstraint>();
        keyConstraint.add(new DBConstraint(Company.getColumns().get(0).getInternalColumnName(), 0, new Integer(companyId), 0));
        DistinctVector<Company> companys = Company.getVectorFromDB(keyConstraint, null);
        return (Company)companys.iterator().next();
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object otherCompany) {
        if (otherCompany instanceof Company) {
            return this.id == ((Company)otherCompany).id;
        }
        return super.equals(otherCompany);
    }

    @Override
    public int getId() {
        return this.id;
    }

    public String getAnnex() {
        return this.annex;
    }

    public void setAnnex(String annex) {
        this.annex = annex;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public java.util.Date getCpBirthDay() {
        return this.cpBirthDay;
    }

    public void setCpBirthDay(java.util.Date cpBirthDay) {
        this.cpBirthDay = cpBirthDay;
    }

    public String getCpDepartment() {
        return this.cpDepartment;
    }

    public void setCpDepartment(String cpDepartment) {
        this.cpDepartment = cpDepartment;
    }

    public String getCpEmail() {
        return this.cpEmail;
    }

    public void setCpEmail(String cpEmail) {
        this.cpEmail = cpEmail;
    }

    public String getCpFax() {
        return this.cpFax;
    }

    public void setCpFax(String cpFax) {
        this.cpFax = cpFax;
    }

    public String getCpFirstname() {
        return this.cpFirstname;
    }

    public void setCpFirstname(String cpFirstname) {
        this.cpFirstname = cpFirstname;
    }

    public String getCpMobile() {
        return this.cpMobile;
    }

    public void setCpMobile(String cpMobile) {
        this.cpMobile = cpMobile;
    }

    public String getCpName() {
        return this.cpName;
    }

    public void setCpName(String cpName) {
        this.cpName = cpName;
    }

    public String getCpPhone() {
        return this.cpPhone;
    }

    public void setCpPhone(String cpPhone) {
        this.cpPhone = cpPhone;
    }

    public String getCpSalutation() {
        return this.cpSalutation;
    }

    public void setCpSalutation(String cpSalutation) {
        this.cpSalutation = cpSalutation;
    }

    public String getCpTask() {
        return this.cpTask;
    }

    public void setCpTask(String cpTask) {
        this.cpTask = cpTask;
    }

    public String getCpTitle() {
        return this.cpTitle;
    }

    public void setCpTitle(String cpTitle) {
        this.cpTitle = cpTitle;
    }

    public java.util.Date getCustomerSince() {
        return this.customerSince;
    }

    public void setCustomerSince(java.util.Date customerSince) {
        this.customerSince = customerSince;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNotices() {
        return this.notices;
    }

    public void setNotices(String notices) {
        this.notices = notices;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getSalutation() {
        return this.salutation;
    }

    public void setSalutation(String salutation) {
        this.salutation = salutation;
    }

    public String getShortInfo() {
        return this.shortInfo;
    }

    public void setShortInfo(String shortInfo) {
        this.shortInfo = shortInfo;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Float getTurnover() {
        return this.turnover;
    }

    public void setTurnover(Float turnover) {
        this.turnover = turnover;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }
}

