/*
 * Decompiled with CFR 0.152.
 */
package semorg.sql.tables;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import semorg.gui.util.Messages;
import semorg.sql.access.DBAccess;
import semorg.sql.tables.AbstractTable;
import semorg.sql.tables.Booking;
import semorg.sql.tables.Client;
import semorg.sql.util.DBColumn;
import semorg.sql.util.DBConstraint;
import semorg.sql.util.DistinctVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientBooking
extends Booking {
    private int presentationId;
    private int clientId;
    private int debitorId;
    private int substituteId;
    private static String tableName = "clientbooking";
    private static String queryString = "SELECT b.id_pk, b.enrolled, b.confirmed, b.billed, b.signedoff, b.messaged, cb.presentationid, cb.clientid, cb.debitorid, cb.substitute_fk, b.creationdate, b.modificationdate FROM booking b, " + tableName + " cb " + "WHERE b.id_pk=cb.booking_fk";
    private static String clientBookingInsertString = "INSERT INTO " + tableName + " VALUES(?, ?, ?, ?, ?)";
    private static String clientBookingUpdateString = "UPDATE " + tableName + " " + "SET presentationid=?, clientid=?, debitorid=?, substitute_fk=? " + "WHERE booking_fk=?";
    private static String createTableSQLString = "CREATE TABLE IF NOT EXISTS `" + tableName + "` (" + "`booking_fk` integer NOT NULL," + "`presentationid` integer NOT NULL," + "`clientid` integer NOT NULL," + "`debitorid` integer," + "`substitute_fk` integer," + "PRIMARY KEY  (`booking_fk`), " + "CONSTRAINT `booking_fk` FOREIGN KEY (`booking_fk`) REFERENCES `booking` (`id_pk`) ON DELETE CASCADE, " + "CONSTRAINT `ppres_fk` FOREIGN KEY (`presentationid`) REFERENCES `publicpresentation` (`presentation_fk`) ON DELETE CASCADE, " + "CONSTRAINT `cl_fk` FOREIGN KEY (`clientid`) REFERENCES `client` (`person_fk`) ON DELETE CASCADE, " + "CONSTRAINT `deb_fk` FOREIGN KEY (`debitorid`) REFERENCES `client` (`person_fk`) ON DELETE SET NULL, " + "CONSTRAINT `substitute_fk` FOREIGN KEY (`substitute_fk`) REFERENCES `client` (`person_fk`) ON DELETE SET NULL)";

    public ClientBooking(int id, Date enrolled, Date confirmed, Date billed, Date signedOff, Date messaged, int presentationId, int clientId, int debitorId, int substituteId, Timestamp creationDate, Timestamp modificationDate) throws SQLException {
        super(id, enrolled, confirmed, billed, signedOff, messaged, creationDate, modificationDate);
        this.presentationId = presentationId;
        this.clientId = clientId;
        this.debitorId = debitorId;
        this.substituteId = substituteId;
    }

    public String getSubstituteDescription() {
        DistinctVector<Client> substitutes;
        if (this.substituteId == 0) {
            return "";
        }
        Vector<DBConstraint> keyConstraint = new Vector<DBConstraint>();
        keyConstraint.add(new DBConstraint(Client.getColumns().get(0).getInternalColumnName(), 0, new Integer(this.substituteId), 0));
        try {
            substitutes = Client.getVectorFromDB(keyConstraint, null);
        }
        catch (SQLException e) {
            return "";
        }
        if (substitutes.size() >= 1) {
            Client substitute = (Client)substitutes.iterator().next();
            return String.valueOf(substitute.getFirstname()) + " " + substitute.getName();
        }
        return "";
    }

    private static DistinctVector<ClientBooking> getVector(ResultSet resultSet) {
        DistinctVector<ClientBooking> set = new DistinctVector<ClientBooking>();
        try {
            while (resultSet.next()) {
                int id = resultSet.getInt("id_pk");
                java.sql.Date enrolled = resultSet.getDate("enrolled");
                java.sql.Date confirmed = resultSet.getDate("confirmed");
                java.sql.Date billed = resultSet.getDate("billed");
                java.sql.Date signedOff = resultSet.getDate("signedOff");
                java.sql.Date messaged = resultSet.getDate("messaged");
                int presentationId = resultSet.getInt("presentationid");
                int clientId = resultSet.getInt("clientid");
                int debitorId = resultSet.getInt("debitorid");
                int substituteId = resultSet.getInt("substitute_fk");
                Timestamp creationDate = resultSet.getTimestamp("creationdate");
                Timestamp modificationDate = resultSet.getTimestamp("modificationdate");
                set.add(new ClientBooking(id, enrolled, confirmed, billed, signedOff, messaged, presentationId, clientId, debitorId, substituteId, creationDate, modificationDate));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return set;
    }

    public static DistinctVector<ClientBooking> getVectorFromDB(Vector<DBConstraint> additionalConstraints, String sortString) throws SQLException {
        PreparedStatement stmt = AbstractTable.createExtendedQueryString(queryString, additionalConstraints, sortString);
        ResultSet rs = stmt.executeQuery();
        DistinctVector<ClientBooking> returnValue = ClientBooking.getVector(rs);
        rs.close();
        stmt.close();
        return returnValue;
    }

    public static boolean tableOK() {
        return AbstractTable.tableOK(tableName);
    }

    public static void createClientBookingTable(Statement statement) throws SQLException {
        statement.execute(createTableSQLString);
        statement.close();
    }

    @Override
    public int insertIntoDB() throws SQLException {
        super.insertIntoDB();
        PreparedStatement insertStmt = DBAccess.dbAccess.getPreparedStatement(clientBookingInsertString);
        insertStmt.setInt(1, this.id);
        insertStmt.setInt(2, this.presentationId);
        insertStmt.setInt(3, this.clientId);
        if (this.debitorId != 0) {
            insertStmt.setInt(4, this.debitorId);
        } else {
            insertStmt.setNull(4, 4);
        }
        if (this.substituteId != 0) {
            insertStmt.setInt(5, this.substituteId);
        } else {
            insertStmt.setNull(5, 4);
        }
        insertStmt.executeUpdate();
        insertStmt.close();
        AbstractTable.fireTableChangedEvent(4);
        return this.id;
    }

    @Override
    public void updateDB() throws SQLException {
        super.updateDB();
        PreparedStatement updateStmt = DBAccess.dbAccess.getPreparedStatement(clientBookingUpdateString);
        updateStmt.setInt(1, this.presentationId);
        updateStmt.setInt(2, this.clientId);
        if (this.debitorId != 0) {
            updateStmt.setInt(3, this.debitorId);
        } else {
            updateStmt.setNull(3, 4);
        }
        if (this.substituteId != 0) {
            updateStmt.setInt(4, this.substituteId);
        } else {
            updateStmt.setNull(4, 4);
        }
        updateStmt.setInt(5, this.id);
        updateStmt.executeUpdate();
        updateStmt.close();
        AbstractTable.fireTableChangedEvent(4);
    }

    public static Vector<DBColumn> getColumns() {
        Vector<DBColumn> columns = Booking.getColumns();
        columns.add(columns.size() - 2, new DBColumn("cb.presentationid", Messages.getString("MAP.ClientBooking.PresentationId"), Integer.class));
        columns.add(columns.size() - 2, new DBColumn("cb.clientid", Messages.getString("MAP.ClientBooking.ClientId"), Integer.class));
        columns.add(columns.size() - 2, new DBColumn("cb.debitorid", Messages.getString("MAP.ClientBooking.DebitorId"), Integer.class));
        columns.add(columns.size() - 2, new DBColumn("c.substitute_fk", Messages.getString("MAP.ClientBooking.SubstituteFK"), Integer.class));
        return columns;
    }

    public static ClientBooking getClientBooking(int bookingId) throws SQLException {
        Vector<DBConstraint> keyConstraint = new Vector<DBConstraint>();
        keyConstraint.add(new DBConstraint(ClientBooking.getColumns().get(0).getInternalColumnName(), 0, new Integer(bookingId), 0));
        DistinctVector<ClientBooking> clients = ClientBooking.getVectorFromDB(keyConstraint, null);
        return (ClientBooking)clients.iterator().next();
    }

    public static ClientBooking getNext(int currentId) {
        ClientBooking returnValue = null;
        ResultSet rs = AbstractTable.getNext(queryString, ClientBooking.getColumns().get(0), currentId);
        if (rs != null) {
            returnValue = (ClientBooking)ClientBooking.getVector(rs).iterator().next();
            try {
                Statement producingStatement = rs.getStatement();
                rs.close();
                if (producingStatement != null) {
                    producingStatement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return returnValue;
    }

    public static ClientBooking getPrevious(int currentId) {
        ClientBooking returnValue = null;
        ResultSet rs = AbstractTable.getPrevious(queryString, ClientBooking.getColumns().get(0), currentId);
        if (rs != null) {
            returnValue = (ClientBooking)ClientBooking.getVector(rs).iterator().next();
            try {
                Statement producingStatement = rs.getStatement();
                rs.close();
                if (producingStatement != null) {
                    producingStatement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return returnValue;
    }

    public int getClientId() {
        return this.clientId;
    }

    public void setClientId(int clientId) {
        this.clientId = clientId;
    }

    public int getDebitorId() {
        return this.debitorId;
    }

    public void setDebitorId(int debitorId) {
        this.debitorId = debitorId;
    }

    public int getPresentationId() {
        return this.presentationId;
    }

    public void setPresentationId(int presentationId) {
        this.presentationId = presentationId;
    }

    public static DistinctVector<ClientBooking> getBookingsOfClient(int clientId) throws SQLException {
        String extendedQueryString = String.valueOf(queryString) + " AND cb.clientid=?";
        PreparedStatement stmt = DBAccess.dbAccess.getPreparedStatement(extendedQueryString);
        stmt.setInt(1, clientId);
        ResultSet rs = stmt.executeQuery();
        DistinctVector<ClientBooking> returnValue = ClientBooking.getVector(rs);
        rs.close();
        stmt.close();
        return returnValue;
    }

    public static DistinctVector<ClientBooking> getBookingsForPresentation(int presentationId) throws SQLException {
        String extendedQueryString = String.valueOf(queryString) + " AND cb.presentationid=?";
        PreparedStatement stmt = DBAccess.dbAccess.getPreparedStatement(extendedQueryString);
        stmt.setInt(1, presentationId);
        ResultSet rs = stmt.executeQuery();
        DistinctVector<ClientBooking> returnValue = ClientBooking.getVector(rs);
        rs.close();
        stmt.close();
        return returnValue;
    }

    public int getSubstituteId() {
        return this.substituteId;
    }

    public void setSubstituteId(int substituteId) {
        this.substituteId = substituteId;
    }
}

