/*
 * Decompiled with CFR 0.152.
 */
package semorg.sql.tables;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import semorg.gui.util.Messages;
import semorg.sql.access.DBAccess;
import semorg.sql.tables.AbstractTable;
import semorg.sql.tables.Company;
import semorg.sql.tables.Person;
import semorg.sql.util.DBColumn;
import semorg.sql.util.DBConstraint;
import semorg.sql.util.DistinctVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client
extends Person {
    private String task;
    private Float turnover;
    private int employerId;
    private static String tableName = "client";
    private static String queryString = "SELECT p.number_pk, p.salutation, p.title, p.firstname, p.name, p.street, p.zipCode, p.city, p.country, p.annex, p.phone, p.mobile, p.fax, p.email, p.birthday, p.firstcontact, p.shortinfo, p.notices, c.task, c.turnover, c.employer_fk, p.creationdate, p.modificationdate FROM person p, " + tableName + " c WHERE p.number_pk=c.person_fk";
    private static String clientInsertString = "INSERT INTO " + tableName + " VALUES(?, ?, ?, ?)";
    private static String clientUpdateString = "UPDATE " + tableName + " SET task=?, turnover=?, employer_fk=? WHERE person_fk=?";
    private static String createTableSQLString = "CREATE TABLE IF NOT EXISTS `" + tableName + "` (" + "`person_fk` integer NOT NULL," + "`task` varchar(50)," + "`turnover` float," + "`employer_fk` integer," + "PRIMARY KEY  (`person_fk`)," + "CONSTRAINT `employer_fk` FOREIGN KEY (`employer_fk`) REFERENCES `company` (`id_pk`) ON DELETE SET NULL, " + "CONSTRAINT `client_fk` FOREIGN KEY (`person_fk`) REFERENCES `person` (`number_pk`) ON DELETE CASCADE)";

    public Client(int id, String salutation, String title, String firstname, String name, String street, String zipCode, String city, String country, String annex, String phone, String mobile, String fax, String email, Date birthday, Date firstContact, String task, Float turnover, int employerId, String shortinfo, String notices, Timestamp creationDate, Timestamp modificationDate) {
        super(id, salutation, title, firstname, name, street, zipCode, city, country, annex, phone, mobile, fax, email, birthday, firstContact, shortinfo, notices, creationDate, modificationDate);
        this.task = task;
        this.turnover = turnover;
        this.employerId = employerId;
    }

    public String getEmployerDescription() {
        DistinctVector<Company> employers;
        if (this.employerId == 0) {
            return "";
        }
        Vector<DBConstraint> keyConstraint = new Vector<DBConstraint>();
        keyConstraint.add(new DBConstraint(Company.getColumns().get(0).getInternalColumnName(), 0, new Integer(this.employerId), 0));
        try {
            employers = Company.getVectorFromDB(keyConstraint, null);
        }
        catch (SQLException e) {
            return "";
        }
        if (employers.size() >= 1) {
            Company employer = (Company)employers.iterator().next();
            return employer.getShortName();
        }
        return "";
    }

    private static DistinctVector<Client> getVector(ResultSet resultSet) {
        DistinctVector<Client> set = new DistinctVector<Client>();
        try {
            while (resultSet.next()) {
                int id = resultSet.getInt("number_pk");
                String salutation = resultSet.getString("salutation");
                String title = resultSet.getString("title");
                String firstname = resultSet.getString("firstname");
                String name = resultSet.getString("name");
                String street = resultSet.getString("street");
                String zipCode = resultSet.getString("zipCode");
                String city = resultSet.getString("city");
                String country = resultSet.getString("country");
                String annex = resultSet.getString("annex");
                String phone = resultSet.getString("phone");
                String mobile = resultSet.getString("mobile");
                String fax = resultSet.getString("fax");
                String email = resultSet.getString("email");
                java.sql.Date birthday = resultSet.getDate("birthday");
                java.sql.Date firstContact = resultSet.getDate("firstcontact");
                String shortinfo = resultSet.getString("shortinfo");
                String notices = resultSet.getString("notices");
                String task = resultSet.getString("task");
                Float turnover = Float.valueOf(resultSet.getFloat("turnover"));
                if (resultSet.wasNull()) {
                    turnover = null;
                }
                int employerId = resultSet.getInt("employer_fk");
                Timestamp creationDate = resultSet.getTimestamp("creationdate");
                Timestamp modificationDate = resultSet.getTimestamp("modificationdate");
                set.add(new Client(id, salutation, title, firstname, name, street, zipCode, city, country, annex, phone, mobile, fax, email, birthday, firstContact, task, turnover, employerId, shortinfo, notices, creationDate, modificationDate));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return set;
    }

    public static DistinctVector<Client> getVectorFromDB(Vector<DBConstraint> additionalConstraints, String sortString) throws SQLException {
        PreparedStatement stmt = AbstractTable.createExtendedQueryString(queryString, additionalConstraints, sortString);
        ResultSet rs = stmt.executeQuery();
        DistinctVector<Client> returnValue = Client.getVector(rs);
        rs.close();
        stmt.close();
        return returnValue;
    }

    public static boolean tableOK() {
        return AbstractTable.tableOK(tableName);
    }

    public static void createClientTable(Statement statement) throws SQLException {
        statement.execute(createTableSQLString);
        statement.close();
    }

    @Override
    public int insertIntoDB() throws SQLException {
        super.insertIntoDB();
        PreparedStatement insertStmt = DBAccess.dbAccess.getPreparedStatement(clientInsertString);
        insertStmt.setInt(1, this.id);
        insertStmt.setString(2, this.task);
        if (this.turnover != null) {
            insertStmt.setFloat(3, this.turnover.floatValue());
        } else {
            insertStmt.setNull(3, 6);
        }
        if (this.employerId != 0) {
            insertStmt.setInt(4, this.employerId);
        } else {
            insertStmt.setNull(4, 4);
        }
        insertStmt.executeUpdate();
        insertStmt.close();
        AbstractTable.fireTableChangedEvent(3);
        return this.id;
    }

    @Override
    public void updateDB() throws SQLException {
        super.updateDB();
        PreparedStatement updateStmt = DBAccess.dbAccess.getPreparedStatement(clientUpdateString);
        updateStmt.setString(1, this.task);
        if (this.turnover != null) {
            updateStmt.setFloat(2, this.turnover.floatValue());
        } else {
            updateStmt.setNull(2, 6);
        }
        if (this.employerId != 0) {
            updateStmt.setInt(3, this.employerId);
        } else {
            updateStmt.setNull(3, 4);
        }
        updateStmt.setInt(4, this.id);
        updateStmt.executeUpdate();
        updateStmt.close();
        AbstractTable.fireTableChangedEvent(3);
    }

    public static Client getNext(int currentId) {
        Client returnValue = null;
        ResultSet rs = AbstractTable.getNext(queryString, Client.getColumns().get(0), currentId);
        if (rs != null) {
            returnValue = (Client)Client.getVector(rs).iterator().next();
            try {
                Statement producingStatement = rs.getStatement();
                rs.close();
                if (producingStatement != null) {
                    producingStatement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return returnValue;
    }

    public static Client getPrevious(int currentId) {
        Client returnValue = null;
        ResultSet rs = AbstractTable.getPrevious(queryString, Client.getColumns().get(0), currentId);
        if (rs != null) {
            returnValue = (Client)Client.getVector(rs).iterator().next();
            try {
                Statement producingStatement = rs.getStatement();
                rs.close();
                if (producingStatement != null) {
                    producingStatement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return returnValue;
    }

    public static Vector<DBColumn> getColumns() {
        Vector<DBColumn> columns = Person.getColumns();
        columns.add(columns.size() - 2, new DBColumn("c.task", Messages.getString("MAP.Client.Task"), String.class));
        columns.add(columns.size() - 2, new DBColumn("c.turnover", Messages.getString("MAP.Client.TurnOver"), Float.class));
        columns.add(columns.size() - 2, new DBColumn("c.employer_fk", Messages.getString("MAP.Client.EmployerFK"), Integer.class));
        return columns;
    }

    public int getEmployerId() {
        return this.employerId;
    }

    public void setEmployerId(int employerId) {
        this.employerId = employerId;
    }

    public String getTask() {
        return this.task;
    }

    public void setTask(String task) {
        this.task = task;
    }

    public Float getTurnover() {
        return this.turnover;
    }

    public void setTurnover(Float turnover) {
        this.turnover = turnover;
    }

    public static Client getClient(int clientId) throws SQLException {
        Vector<DBConstraint> keyConstraint = new Vector<DBConstraint>();
        keyConstraint.add(new DBConstraint(Client.getColumns().get(0).getInternalColumnName(), 0, new Integer(clientId), 0));
        DistinctVector<Client> clients = Client.getVectorFromDB(keyConstraint, null);
        return (Client)clients.iterator().next();
    }

    public static DistinctVector<Client> getEmployees(int companyId) throws SQLException {
        String employeeQueryString = String.valueOf(queryString) + " AND c.employer_fk=?";
        PreparedStatement stmt = DBAccess.dbAccess.getPreparedStatement(employeeQueryString);
        stmt.setInt(1, companyId);
        ResultSet rs = stmt.executeQuery();
        DistinctVector<Client> returnValue = Client.getVector(rs);
        rs.close();
        stmt.close();
        return returnValue;
    }
}

