/*
 * Decompiled with CFR 0.152.
 */
package semorg.sql.tables;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import semorg.gui.util.Messages;
import semorg.sql.access.DBAccess;
import semorg.sql.tables.AbstractTable;
import semorg.sql.tables.SimpleIDKey;
import semorg.sql.util.DBColumn;
import semorg.sql.util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Booking
extends AbstractTable
implements SimpleIDKey {
    public static List<Integer> lockedIds = new ArrayList<Integer>();
    protected int id;
    protected Date enrolled;
    protected Date confirmed;
    protected Date billed;
    protected Date signedOff;
    protected Date messaged;
    private static String tableName = "booking";
    protected static String bookingInsertString = "INSERT INTO " + tableName + " VALUES(?, ?, ?, ?, ?, ?, ?, ?)";
    private static String createTableSQLString = "CREATE TABLE IF NOT EXISTS `" + tableName + "` (" + "`id_pk` integer NOT NULL auto_increment," + "`enrolled` date," + "`confirmed` date," + "`billed` date," + "`signedoff` date," + "`messaged` date," + "`creationdate` timestamp NOT NULL default '0000-00-00 00:00:00'," + "`modificationdate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP," + "PRIMARY KEY  (`id_pk`))";
    protected static String bookingUpdateString = "UPDATE " + tableName + " SET enrolled=?, confirmed=?, billed=?, signedoff=?, " + "messaged=?, modificationdate=? WHERE id_pk=?";

    protected Booking(int id, Date enrolled, Date confirmed, Date billed, Date signedOff, Date messaged, Timestamp creationDate, Timestamp modificationDate) {
        super(creationDate, modificationDate);
        this.id = id;
        this.enrolled = enrolled;
        this.confirmed = confirmed;
        this.billed = billed;
        this.signedOff = signedOff;
        this.messaged = messaged;
    }

    public static boolean tableOK() {
        return AbstractTable.tableOK(tableName);
    }

    public static void createBookingTable(Statement statement) throws SQLException {
        statement.execute(createTableSQLString);
        statement.close();
    }

    public int insertIntoDB() throws SQLException {
        PreparedStatement insertStmt = DBAccess.dbAccess.getPreparedStatement(bookingInsertString);
        insertStmt.setNull(1, 4);
        if (this.enrolled != null) {
            insertStmt.setDate(2, Utility.convertToSQLDate(this.enrolled));
        } else {
            insertStmt.setNull(2, 91);
        }
        if (this.confirmed != null) {
            insertStmt.setDate(3, Utility.convertToSQLDate(this.confirmed));
        } else {
            insertStmt.setNull(3, 91);
        }
        if (this.billed != null) {
            insertStmt.setDate(4, Utility.convertToSQLDate(this.billed));
        } else {
            insertStmt.setNull(4, 91);
        }
        if (this.signedOff != null) {
            insertStmt.setDate(5, Utility.convertToSQLDate(this.signedOff));
        } else {
            insertStmt.setNull(5, 91);
        }
        if (this.messaged != null) {
            insertStmt.setDate(6, Utility.convertToSQLDate(this.messaged));
        } else {
            insertStmt.setNull(6, 91);
        }
        insertStmt.setTimestamp(7, Utility.convertToTimestamp(this.creationDate));
        insertStmt.setTimestamp(8, Utility.convertToTimestamp(this.modificationDate));
        insertStmt.executeUpdate();
        ResultSet rs = insertStmt.getGeneratedKeys();
        if (!rs.next()) {
            throw new SQLException();
        }
        this.id = rs.getInt(1);
        rs.close();
        insertStmt.close();
        AbstractTable.fireTableChangedEvent(2);
        return this.id;
    }

    public void updateDB() throws SQLException {
        PreparedStatement updateStmt = DBAccess.dbAccess.getPreparedStatement(bookingUpdateString);
        if (this.enrolled != null) {
            updateStmt.setDate(1, Utility.convertToSQLDate(this.enrolled));
        } else {
            updateStmt.setNull(1, 91);
        }
        if (this.confirmed != null) {
            updateStmt.setDate(2, Utility.convertToSQLDate(this.confirmed));
        } else {
            updateStmt.setNull(2, 91);
        }
        if (this.billed != null) {
            updateStmt.setDate(3, Utility.convertToSQLDate(this.billed));
        } else {
            updateStmt.setNull(3, 91);
        }
        if (this.signedOff != null) {
            updateStmt.setDate(4, Utility.convertToSQLDate(this.signedOff));
        } else {
            updateStmt.setNull(4, 91);
        }
        if (this.messaged != null) {
            updateStmt.setDate(5, Utility.convertToSQLDate(this.messaged));
        } else {
            updateStmt.setNull(5, 91);
        }
        updateStmt.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
        updateStmt.setInt(7, this.id);
        updateStmt.executeUpdate();
        updateStmt.close();
        AbstractTable.fireTableChangedEvent(2);
    }

    public static void removeFromDB(Iterable selectedElements) throws SQLException {
        String deleteString = "DELETE FROM " + tableName + " WHERE ";
        Iterator it = selectedElements.iterator();
        int idToDelete = ((Booking)it.next()).getId();
        deleteString = String.valueOf(deleteString) + "id_pk=" + idToDelete + " ";
        while (it.hasNext()) {
            idToDelete = ((Booking)it.next()).getId();
            deleteString = String.valueOf(deleteString) + "OR id_pk=" + idToDelete + " ";
        }
        Statement stmt = DBAccess.dbAccess.getStatement();
        stmt.executeUpdate(deleteString);
        stmt.close();
        AbstractTable.fireTableChangedEvent(2);
        AbstractTable.fireTableChangedEvent(6);
        AbstractTable.fireTableChangedEvent(4);
    }

    public static Vector<DBColumn> getColumns() {
        Vector<DBColumn> columns = new Vector<DBColumn>();
        columns.add(new DBColumn("b.id_pk", Messages.getString("MAP.Booking.IdPK"), Date.class));
        columns.add(new DBColumn("b.enrolled", Messages.getString("MAP.Booking.Enrolled"), Date.class));
        columns.add(new DBColumn("b.confirmed", Messages.getString("MAP.Booking.Confirmed"), Date.class));
        columns.add(new DBColumn("b.billed", Messages.getString("MAP.Booking.Billed"), Date.class));
        columns.add(new DBColumn("b.signedOff", Messages.getString("MAP.Booking.SignedOff"), Date.class));
        columns.add(new DBColumn("b.messaged", Messages.getString("MAP.Booking.Messaged"), Date.class));
        columns.addAll(AbstractTable.getColumns("b."));
        return columns;
    }

    public Date getBilled() {
        return this.billed;
    }

    public void setBilled(Date billed) {
        this.billed = billed;
    }

    public Date getConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(Date confirmed) {
        this.confirmed = confirmed;
    }

    public Date getEnrolled() {
        return this.enrolled;
    }

    public void setEnrolled(Date enrolled) {
        this.enrolled = enrolled;
    }

    public Date getMessaged() {
        return this.messaged;
    }

    public void setMessaged(Date messaged) {
        this.messaged = messaged;
    }

    public Date getSignedOff() {
        return this.signedOff;
    }

    public void setSignedOff(Date signedOff) {
        this.signedOff = signedOff;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object otherBooking) {
        if (otherBooking instanceof Booking) {
            return this.id == ((Booking)otherBooking).id;
        }
        return super.equals(otherBooking);
    }
}

