/*
 * Decompiled with CFR 0.152.
 */
package semorg.sql.tables;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import semorg.gui.util.Messages;
import semorg.sql.access.DBAccess;
import semorg.sql.tables.AbstractTable;
import semorg.sql.tables.Person;
import semorg.sql.util.DBColumn;
import semorg.sql.util.DBConstraint;
import semorg.sql.util.DistinctVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Associate
extends Person {
    private int entitlement;
    private String password;
    private String occupation;
    private static String tableName = "associate";
    private static String queryString = "SELECT p.number_pk, p.salutation, p.title, p.firstname, p.name, p.street, p.zipCode, p.city, p.country, p.annex, p.phone, p.mobile, p.fax, p.email, p.birthday, p.firstcontact, p.shortinfo, p.notices, a.entitlement, a.password, a.occupation, p.creationdate, p.modificationdate FROM person p, " + tableName + " a WHERE p.number_pk=a.person_fk";
    private static String associateInsertString = "INSERT INTO " + tableName + " VALUES(?, ?, ?, ?)";
    private static String associateUpdateString = "UPDATE " + tableName + " SET entitlement=?, password=?, occupation=? WHERE person_fk=?";
    private static String createTableSQLString = "CREATE TABLE IF NOT EXISTS `" + tableName + "` (" + "`person_fk` integer NOT NULL," + "`entitlement` integer NOT NULL," + "`password` varchar(6)," + "`occupation` varchar(30)," + "PRIMARY KEY  (`person_fk`)," + "CONSTRAINT `associate_fk` FOREIGN KEY (`person_fk`) REFERENCES `person` (`number_pk`) ON DELETE CASCADE)";

    public Associate(int id, String salutation, String title, String firstname, String name, String street, String zipCode, String city, String country, String annex, String phone, String mobile, String fax, String email, Date birthday, Date firstContact, int entitlement, String password, String occupation, String shortinfo, String notices, Timestamp creationDate, Timestamp modificationDate) {
        super(id, salutation, title, firstname, name, street, zipCode, city, country, annex, phone, mobile, fax, email, birthday, firstContact, shortinfo, notices, creationDate, modificationDate);
        this.entitlement = entitlement;
        this.password = password;
        this.occupation = occupation;
    }

    private static DistinctVector<Associate> getVector(ResultSet resultSet) {
        DistinctVector<Associate> set = new DistinctVector<Associate>();
        try {
            while (resultSet.next()) {
                int number = resultSet.getInt("number_pk");
                String salutation = resultSet.getString("salutation");
                String title = resultSet.getString("title");
                String firstname = resultSet.getString("firstname");
                String name = resultSet.getString("name");
                String street = resultSet.getString("street");
                String zipCode = resultSet.getString("zipCode");
                String city = resultSet.getString("city");
                String country = resultSet.getString("country");
                String annex = resultSet.getString("annex");
                String phone = resultSet.getString("phone");
                String mobile = resultSet.getString("mobile");
                String fax = resultSet.getString("fax");
                String email = resultSet.getString("email");
                java.sql.Date birthday = resultSet.getDate("birthday");
                java.sql.Date firstContact = resultSet.getDate("firstcontact");
                String shortinfo = resultSet.getString("shortinfo");
                String notices = resultSet.getString("notices");
                int entitlement = resultSet.getInt("entitlement");
                String password = resultSet.getString("password");
                String occupation = resultSet.getString("occupation");
                Timestamp creationDate = resultSet.getTimestamp("creationdate");
                Timestamp modificationDate = resultSet.getTimestamp("modificationdate");
                set.add(new Associate(number, salutation, title, firstname, name, street, zipCode, city, country, annex, phone, mobile, fax, email, birthday, firstContact, entitlement, password, occupation, shortinfo, notices, creationDate, modificationDate));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return set;
    }

    public static DistinctVector<Associate> getVectorFromDB(Vector<DBConstraint> additionalConstraints, String sortString) throws SQLException {
        PreparedStatement stmt = AbstractTable.createExtendedQueryString(queryString, additionalConstraints, sortString);
        ResultSet rs = stmt.executeQuery();
        DistinctVector<Associate> returnValue = Associate.getVector(rs);
        rs.close();
        stmt.close();
        return returnValue;
    }

    public static boolean tableOK() {
        return AbstractTable.tableOK(tableName);
    }

    public static void createAssociateTable(Statement statement) throws SQLException {
        statement.execute(createTableSQLString);
        statement.close();
    }

    public int getEntitlement() {
        return this.entitlement;
    }

    public String getOccupation() {
        return this.occupation;
    }

    public String getPassword() {
        return this.password;
    }

    public void setEntitlement(int entitlement) {
        this.entitlement = entitlement;
    }

    public void setOccupation(String occupation) {
        this.occupation = occupation;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public int insertIntoDB() throws SQLException {
        super.insertIntoDB();
        PreparedStatement insertStmt = DBAccess.dbAccess.getPreparedStatement(associateInsertString);
        insertStmt.setInt(1, this.id);
        insertStmt.setInt(2, this.entitlement);
        insertStmt.setString(3, this.password);
        insertStmt.setString(4, this.occupation);
        insertStmt.executeUpdate();
        insertStmt.close();
        AbstractTable.fireTableChangedEvent(1);
        return this.id;
    }

    @Override
    public void updateDB() throws SQLException {
        super.updateDB();
        PreparedStatement updateStmt = DBAccess.dbAccess.getPreparedStatement(associateUpdateString);
        updateStmt.setInt(1, this.entitlement);
        updateStmt.setString(2, this.password);
        updateStmt.setString(3, this.occupation);
        updateStmt.setInt(4, this.id);
        updateStmt.executeUpdate();
        updateStmt.close();
        AbstractTable.fireTableChangedEvent(1);
    }

    public static Associate getNext(int associateId) {
        Associate returnValue = null;
        ResultSet rs = AbstractTable.getNext(queryString, Associate.getColumns().get(0), associateId);
        if (rs != null) {
            returnValue = (Associate)Associate.getVector(rs).iterator().next();
            try {
                Statement producingStatement = rs.getStatement();
                rs.close();
                if (producingStatement != null) {
                    producingStatement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return returnValue;
    }

    public static Associate getPrevious(int associateId) {
        Associate returnValue = null;
        ResultSet rs = AbstractTable.getPrevious(queryString, Associate.getColumns().get(0), associateId);
        if (rs != null) {
            returnValue = (Associate)Associate.getVector(rs).iterator().next();
            try {
                Statement producingStatement = rs.getStatement();
                rs.close();
                if (producingStatement != null) {
                    producingStatement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return returnValue;
    }

    public static Vector<DBColumn> getColumns() {
        Vector<DBColumn> columns = Person.getColumns();
        columns.add(columns.size() - 2, new DBColumn("a.entitlement", Messages.getString("MAP.Associate.Entitlement"), Integer.class));
        columns.add(columns.size() - 2, new DBColumn("a.password", Messages.getString("MAP.Associate.Password"), String.class));
        columns.add(columns.size() - 2, new DBColumn("a.occupation", Messages.getString("MAP.Associate.Occupation"), String.class));
        return columns;
    }
}

