/*
 * Decompiled with CFR 0.152.
 */
package semorg.sql.tables;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import semorg.gui.util.DBTableChangedListener;
import semorg.gui.util.Messages;
import semorg.sql.access.DBAccess;
import semorg.sql.util.DBColumn;
import semorg.sql.util.DBConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTable {
    private static Set<DBTableChangedListener> tableChangedListeners = new HashSet<DBTableChangedListener>();
    public static final int NULL_ID = 0;
    protected Timestamp creationDate;
    protected Timestamp modificationDate;

    public AbstractTable(Timestamp creationDate, Timestamp modificationDate) {
        this.creationDate = creationDate;
        this.modificationDate = modificationDate;
    }

    public Timestamp getCreationDate() {
        return this.creationDate;
    }

    public Timestamp getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Timestamp modificationDate) {
        this.modificationDate = modificationDate;
    }

    protected static PreparedStatement createExtendedQueryString(String queryString, Vector<DBConstraint> additionalConstraints, String sortString) throws SQLException {
        String extendedQueryString = new String(queryString);
        if (additionalConstraints != null) {
            extendedQueryString = String.valueOf(extendedQueryString) + " AND";
            Iterator<DBConstraint> iter = additionalConstraints.iterator();
            while (iter.hasNext()) {
                DBConstraint constraint = iter.next();
                extendedQueryString = String.valueOf(extendedQueryString) + " " + constraint.getColumnName();
                switch (constraint.getRelation()) {
                    case 0: {
                        extendedQueryString = String.valueOf(extendedQueryString) + "=";
                        break;
                    }
                    case 1: {
                        extendedQueryString = String.valueOf(extendedQueryString) + "!=";
                        break;
                    }
                    case 3: {
                        extendedQueryString = String.valueOf(extendedQueryString) + ">";
                        break;
                    }
                    case 2: {
                        extendedQueryString = String.valueOf(extendedQueryString) + "<";
                        break;
                    }
                    case 4: {
                        extendedQueryString = String.valueOf(extendedQueryString) + " LIKE ";
                    }
                }
                extendedQueryString = String.valueOf(extendedQueryString) + "?";
                if (!iter.hasNext()) continue;
                switch (constraint.getConjunction()) {
                    case 1: {
                        extendedQueryString = String.valueOf(extendedQueryString) + " AND";
                        break;
                    }
                    case 2: {
                        extendedQueryString = String.valueOf(extendedQueryString) + " OR";
                    }
                }
            }
        }
        if (sortString != null) {
            extendedQueryString = String.valueOf(extendedQueryString) + " " + sortString;
        }
        PreparedStatement stmt = DBAccess.dbAccess.getPreparedStatement(extendedQueryString);
        if (additionalConstraints != null) {
            Iterator<DBConstraint> iter = additionalConstraints.iterator();
            int i = 1;
            while (iter.hasNext()) {
                DBConstraint constraint = iter.next();
                if (constraint.getValue() instanceof Integer) {
                    stmt.setInt(i, (Integer)constraint.getValue());
                } else if (constraint.getValue() instanceof Time) {
                    stmt.setTime(i, (Time)constraint.getValue());
                } else if (constraint.getValue() instanceof Timestamp) {
                    stmt.setTimestamp(i, (Timestamp)constraint.getValue());
                } else if (constraint.getValue() instanceof Date) {
                    long valueTime = ((Date)constraint.getValue()).getTime();
                    stmt.setDate(i, new java.sql.Date(valueTime));
                } else if (constraint.getValue() instanceof Float) {
                    stmt.setFloat(i, ((Float)constraint.getValue()).floatValue());
                } else if (constraint.getValue() instanceof Boolean) {
                    stmt.setBoolean(i, (Boolean)constraint.getValue());
                } else {
                    String valueString = (String)constraint.getValue();
                    if (constraint.getRelation() == 4) {
                        valueString = String.valueOf('%') + valueString + '%';
                    }
                    stmt.setString(i, valueString);
                }
                ++i;
            }
        }
        return stmt;
    }

    protected static Vector<DBColumn> getColumns(String tableAbbreviation) {
        Vector<DBColumn> columns = new Vector<DBColumn>();
        columns.add(new DBColumn(String.valueOf(tableAbbreviation) + "creationdate", Messages.getString("MAP.AbstractTable.CreationDate"), Timestamp.class));
        columns.add(new DBColumn(String.valueOf(tableAbbreviation) + "modificationdate", Messages.getString("MAP.AbstractTable.ModificationDate"), Timestamp.class));
        return columns;
    }

    protected static boolean tableOK(String tableName) {
        try {
            Statement stmt = DBAccess.dbAccess.getStatement();
            stmt.execute("DESCRIBE " + tableName);
            return true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected static ResultSet getNext(String queryString, DBColumn sortColumn, int currentKey) {
        try {
            Statement stmt = DBAccess.dbAccess.getStatement();
            ResultSet rs = stmt.executeQuery(String.valueOf(queryString) + " AND " + sortColumn.getInternalColumnName() + ">" + currentKey + " ORDER BY " + sortColumn.getInternalColumnName() + " ASC LIMIT 1");
            if (rs.isBeforeFirst()) {
                return rs;
            }
            rs.close();
            stmt.close();
            Statement stmt2 = DBAccess.dbAccess.getStatement();
            ResultSet rs2 = stmt2.executeQuery(String.valueOf(queryString) + " ORDER BY " + sortColumn.getInternalColumnName() + " ASC LIMIT 1");
            if (rs2.isBeforeFirst()) {
                return rs2;
            }
            rs2.close();
            stmt2.close();
            return null;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static ResultSet getPrevious(String queryString, DBColumn sortColumn, int currentKey) {
        try {
            Statement stmt = DBAccess.dbAccess.getStatement();
            ResultSet rs = stmt.executeQuery(String.valueOf(queryString) + " AND " + sortColumn.getInternalColumnName() + "<" + currentKey + " ORDER BY " + sortColumn.getInternalColumnName() + " DESC LIMIT 1");
            if (rs.isBeforeFirst()) {
                return rs;
            }
            rs.close();
            stmt.close();
            Statement stmt2 = DBAccess.dbAccess.getStatement();
            ResultSet rs2 = stmt2.executeQuery(String.valueOf(queryString) + " ORDER BY " + sortColumn.getInternalColumnName() + " DESC LIMIT 1");
            if (rs2.isBeforeFirst()) {
                return rs2;
            }
            rs2.close();
            stmt2.close();
            return null;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static void fireTableChangedEvent(int type) {
        for (DBTableChangedListener listener : tableChangedListeners) {
            if (listener.getType() != type) continue;
            listener.dBTableChanged();
        }
    }

    public static void addDBTableChangedListener(DBTableChangedListener listener) {
        tableChangedListeners.add(listener);
    }

    public static void removeDBTableChangedListener(DBTableChangedListener listener) {
        tableChangedListeners.remove(listener);
    }
}

