/*
 * Decompiled with CFR 0.152.
 */
package semorg.sql.access;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import semorg.sql.tables.Associate;
import semorg.sql.tables.Booking;
import semorg.sql.tables.Client;
import semorg.sql.tables.ClientBooking;
import semorg.sql.tables.Company;
import semorg.sql.tables.CompanyBooking;
import semorg.sql.tables.CompanyInternalPresentation;
import semorg.sql.tables.Conduct;
import semorg.sql.tables.Enumeration;
import semorg.sql.tables.Instructor;
import semorg.sql.tables.Lecturer;
import semorg.sql.tables.Person;
import semorg.sql.tables.Presentation;
import semorg.sql.tables.PublicPresentation;
import semorg.sql.tables.SeminarType;
import semorg.sql.tables.Supervisor;

public class DBAccess {
    public static DBAccess dbAccess;
    private static String chosenDataBaseDriver;
    private static String chosenDriverURL;
    private static String databaseName;
    private static String mysqlURL;
    private static String databaseUsername;
    private static String databasePassword;
    private Connection connection = null;

    static {
        chosenDataBaseDriver = "com.mysql.jdbc.Driver";
        chosenDriverURL = "jdbc:mysql:///";
        databaseName = "husemorg";
        mysqlURL = "jdbc:mysql:///mysql";
        databaseUsername = "semorg";
        databasePassword = "semorg";
    }

    private DBAccess() throws SQLException, ClassNotFoundException {
        Class.forName(chosenDataBaseDriver);
        try {
            this.connection = DriverManager.getConnection(String.valueOf(chosenDriverURL) + databaseName, databaseUsername, databasePassword);
        }
        catch (SQLException e) {
            System.out.println("The database schema husemorg does not exist and is now created.");
            this.createDatabaseAndConnect();
        }
    }

    private void createDatabaseAndConnect() throws SQLException {
        Connection conn = DriverManager.getConnection(mysqlURL, databaseUsername, databasePassword);
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE DATABASE IF NOT EXISTS " + databaseName);
        stmt.close();
        conn.close();
        this.connection = DriverManager.getConnection(String.valueOf(chosenDriverURL) + databaseName, databaseUsername, databasePassword);
        this.createTables();
    }

    private void createTables() throws SQLException {
        Person.createPersonTable(this.connection.createStatement());
        Associate.createAssociateTable(this.connection.createStatement());
        Lecturer.createLecturerTable(this.connection.createStatement());
        Company.createCompanyTable(this.connection.createStatement());
        SeminarType.createSeminarTypeTable(this.connection.createStatement());
        Client.createClientTable(this.connection.createStatement());
        Presentation.createPresentationTable(this.connection.createStatement());
        PublicPresentation.createPublicPresentationTable(this.connection.createStatement());
        CompanyInternalPresentation.createCompanyInternalPresentationTable(this.connection.createStatement());
        Booking.createBookingTable(this.connection.createStatement());
        CompanyBooking.createCompanyBookingTable(this.connection.createStatement());
        ClientBooking.createClientBookingTable(this.connection.createStatement());
        Conduct.createConductTable(this.connection.createStatement());
        Supervisor.createSupervisorTable(this.connection.createStatement());
        Instructor.createInstructorTable(this.connection.createStatement());
        Enumeration.createEnumerationTable(this.connection.createStatement());
    }

    public static void init() throws ClassNotFoundException, SQLException {
        dbAccess = new DBAccess();
    }

    public PreparedStatement getPreparedStatement(String sqlString) throws SQLException {
        return this.connection.prepareStatement(sqlString);
    }

    public Statement getStatement() throws SQLException {
        return this.connection.createStatement();
    }
}

