/*
 * Decompiled with CFR 0.152.
 */
package semorg.gui.util;

import java.sql.Time;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import semorg.sql.util.Utility;

public class TimeControl
extends Composite {
    private final Spinner hours;
    private final Spinner minutes;
    private final Button checker;
    private final Label floatingPoint;
    private Text backgroundHack;
    private final Font defaultFont;
    private boolean activated;
    private boolean enabled;
    private Set<TimeChangeListener> listeners = new HashSet<TimeChangeListener>();

    public TimeControl(Composite par) {
        super(par, 0);
        this.setLayout((Layout)new FormLayout());
        this.defaultFont = new Font((Device)this.getDisplay(), new FontData("Sans Serif", 8, 0));
        this.floatingPoint = new Label((Composite)this, 0);
        this.floatingPoint.setText(":");
        this.floatingPoint.setBackground(par.getDisplay().getSystemColor(1));
        this.floatingPoint.setLayoutData((Object)Utility.getFormData(0, 2, 0, 18, 0, 57, 0, 59));
        this.floatingPoint.setFont(this.defaultFont);
        this.hours = new Spinner((Composite)this, 0x4000000);
        this.hours.setMinimum(0);
        this.hours.setMaximum(23);
        this.hours.setFont(this.defaultFont);
        this.hours.setLayoutData((Object)Utility.getFormData(0, 2, 0, 18, 0, 21, 0, 57));
        this.hours.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                TimeControl.this.fireInputChanged();
            }
        });
        this.minutes = new Spinner((Composite)this, 0);
        this.minutes.setMinimum(0);
        this.minutes.setMaximum(59);
        this.minutes.setFont(this.defaultFont);
        this.minutes.setLayoutData((Object)Utility.getFormData(0, 2, 0, 18, 0, 59, 0, 95));
        this.minutes.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                TimeControl.this.fireInputChanged();
            }
        });
        this.checker = new Button((Composite)this, 32);
        this.checker.setLayoutData((Object)Utility.getFormData(0, 4, 0, 16, 0, 6, 0, 18));
        this.checker.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                TimeControl.this.setActivated(TimeControl.this.checker.getSelection());
                TimeControl.this.fireInputChanged();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        this.backgroundHack = new Text((Composite)this, 2056);
        this.backgroundHack.setEnabled(false);
        this.backgroundHack.setBackground(par.getDisplay().getSystemColor(1));
        this.backgroundHack.setLayoutData((Object)Utility.getFormData(0, 0, 0, 20, 0, 0, 0, 97));
        this.setActivated(false);
    }

    public int getHours() {
        if (this.activated) {
            return this.hours.getSelection();
        }
        return -1;
    }

    public int getMinutes() {
        if (this.activated) {
            return this.minutes.getSelection();
        }
        return -1;
    }

    public Time getTime() {
        if (this.activated) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, this.hours.getSelection());
            calendar.set(12, this.minutes.getSelection());
            calendar.set(13, 0);
            calendar.set(14, 0);
            return new Time(calendar.getTimeInMillis());
        }
        return null;
    }

    private void fireInputChanged() {
        for (TimeChangeListener listener : this.listeners) {
            listener.timeChanged();
        }
    }

    public void addTimeChangeListener(TimeChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeTimeChangeListener(TimeChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void setTime(Time time) {
        this.setActivated(time != null);
        if (time != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(time);
            this.hours.setSelection(calendar.get(11));
            this.minutes.setSelection(calendar.get(12));
        }
    }

    protected void setActivated(boolean activ) {
        this.activated = activ;
        this.checker.setSelection(this.activated);
        this.hours.setEnabled(this.enabled && this.activated);
        this.minutes.setEnabled(this.enabled && this.activated);
        if (this.activated) {
            this.hours.setForeground(this.getDisplay().getSystemColor(2));
            this.minutes.setForeground(this.getDisplay().getSystemColor(2));
        } else {
            this.hours.setForeground(this.getDisplay().getSystemColor(16));
            this.minutes.setForeground(this.getDisplay().getSystemColor(16));
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.hours.setEnabled(enabled && this.activated);
        this.minutes.setEnabled(enabled && this.activated);
        this.checker.setEnabled(enabled);
        this.floatingPoint.setEnabled(enabled);
    }

    public void setData(String key, String value) {
        super.setData(key, (Object)value);
        if (key.equals("ATOSJ_COMPONENT_NAME_KEY")) {
            this.hours.setData(key, (Object)(String.valueOf(value) + "_hours"));
            this.minutes.setData(key, (Object)(String.valueOf(value) + "_minutes"));
            this.checker.setData(key, (Object)(String.valueOf(value) + "_checker"));
        }
    }

    public void setToolTipText(String toolTipText) {
        this.checker.setToolTipText(toolTipText);
        this.floatingPoint.setToolTipText(toolTipText);
        this.hours.setToolTipText(toolTipText);
        this.minutes.setToolTipText(toolTipText);
    }

    public static interface TimeChangeListener {
        public void timeChanged();
    }
}

